package tsStreamRipper;

import java.util.Comparator;

import org.apache.commons.cli.Option;

/**
 * Anzeigereihenfolge der Optionen für die Kommandozeile
 */
public class CliOptionComparator implements Comparator<Option>
{
    private static final String[] arguments = new String[]
    { "host", "channel", "channelKd", "channelId", "musicDir", "tmpDir", "webport", "streamport", "user", "pass", "convert",
            "convert_mp3", "keepOrig", "switchFilenameFormat", "overwrite", "verbose", "remainTimeOffset", "epgType", "help" };

    @Override
    public int compare(Option o1, Option o2)
    {
        int i1 = getPos(o1.getOpt());
        int i2 = getPos(o2.getOpt());

        if (i1 > i2)
        {
            return 1;
        }
        else if (i2 > i1)
        {
            return -1;
        }
        else
        {
            return 0;
        }
    }

    public int getPos(String s)
    {
        int i = 0;
        for (String element : arguments)
        {
            if (element.equalsIgnoreCase(s))
            {
                return i;
            }
            i++;
        }
        throw new RuntimeException("Parameter unbekannt : " + s);
    }
}
