package tsStreamRipper;

import java.io.File;
import java.util.logging.Logger;

import tsStreamRipper.audio.ConverterOption;
import tsStreamRipper.dream.filestream.IFileStreamNameFormatter;
import tsStreamRipper.dream.webinterface.HttpParameter;
import tsStreamRipper.dream.webinterface.parser.EPGType;

public class Configuration
{
    private static final Logger log = Logger.getLogger(Configuration.class.getName());
    
    private HttpParameter httpParameter = null;
    private String channel = null;
    private File tmpDir = null;
    private File destination = null;
    private ConverterOption convOpt = null;
    private IFileStreamNameFormatter nameFormatter = null;
    private boolean overwriteFiles = true;
    private int restdauerKorrektur = 20; // + 20 Sekunden gegenüber gemeldetem Liedende.
    private EPGType epgType = null;

    public Configuration(HttpParameter httpParameter, String channel, File tmpDir, File destination, ConverterOption convOpt, IFileStreamNameFormatter nameFormatter,
            boolean overwriteFiles, int restdauerKorrektur, EPGType epgType) throws Exception
    {
        super();
        this.httpParameter = httpParameter;
        this.channel = channel;
        this.tmpDir = tmpDir;
        this.destination = destination;
        this.convOpt = convOpt;
        this.nameFormatter = nameFormatter;
        this.overwriteFiles = overwriteFiles;
        this.restdauerKorrektur = restdauerKorrektur;
        this.epgType = epgType;
        
        if (this.tmpDir == null)
        {
            this.tmpDir = new File(System.getProperty("java.io.tmpdir"));
        }
        
        if (this.tmpDir != null)
        {
            if (!this.tmpDir.exists())
            {
                String s = String.format("tmpDir '%s' existiert nicht, oder keine Berechtigung zum Zugriff.", this.tmpDir.getAbsoluteFile());
                log.severe(s);
                throw new Exception (s);
            }
        }

        if (this.destination != null)
        {
            if (!this.destination.exists())
            {
                String s = String.format("musicDir '%s' existiert nicht, oder keine Berechtigung zum Zugriff.", this.destination.getAbsoluteFile());
                log.severe(s);
                System.exit(1);
            }
        }

    }

    public HttpParameter getHttpParameter()
    {
        return httpParameter;
    }

    public String getChannel()
    {
        return channel;
    }

    public File getTmpDir()
    {
        return tmpDir;
    }

    public File getDestination()
    {
        return destination;
    }

    public ConverterOption getConvOpt()
    {
        return convOpt;
    }

    public IFileStreamNameFormatter getNameFormatter()
    {
        return nameFormatter;
    }

    public boolean isOverwriteFiles()
    {
        return overwriteFiles;
    }

    public int getRestdauerKorrektur()
    {
        return restdauerKorrektur;
    }

    public EPGType getEpgType()
    {
        return epgType;
    }

    
}
