package tsStreamRipper.audio;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConvertMp2ToMp3 extends BaseConvert
{
    private static final Logger log = Logger.getLogger(ConvertMp2ToAAC.class.getName());

    private File out = null;

    private File lame = null;

    private ID3 id3 = null;

    /**
     * 
     * @param in
     * @throws IOException
     */
    public ConvertMp2ToMp3(File in, File out, ID3 id3, File lame, boolean removeOrig) throws IOException
    {
        super(removeOrig, in);
        this.out = out;
        this.lame = lame;
        this.id3 = id3;

        if (lame != null && !lame.exists())
        {
            throw new IOException("LAME encoder path fehlerhaft : " + lame.getAbsolutePath());
        }
    }

    @Override
    protected void preConvert()
    {
        super.preConvert();
        if (log.isLoggable(Level.FINE))
        {
            log.fine("Convertiere MP2-File " + getInfile().getAbsolutePath());
            log.fine("  -> MP3 File : " + out.getAbsolutePath());
        }
    }
  
    @Override
    protected List<String> getArgumentList()
    {
        LinkedList<String> args = new LinkedList<String>();

        args.add(lame.getAbsolutePath()); // Command
        args.add("-V");
        args.add("2");
        args.add("--disptime");
        args.add("1000");
        args.add("--nohist");
        args.add("--flush");
        args.add("--ta");
        args.add(id3.getInterpret());
        args.add("--tt");
        args.add(id3.getTitel());
        args.add("--tl");
        args.add(id3.getAlbum());
        args.add("--ty");
        args.add(id3.getJahr());
        args.add(getInfile().getAbsolutePath());
        args.add(out.getAbsolutePath());
        return args;
    }
    
    @Override
    protected String getConverterName()
    {
        return "LAME";
    }

    @Override
    protected String getTargetFileFormat()
    {
        return "MP3";
    }
    
//    public static void main(String[] args) throws IOException
//    {
//        File in = new File("/temp/music/b.mp2");
//        File out = new File("/temp/music/b.m4a");
//
//        ID3 id3 = new ID3();
//        id3.setAlbum("AlbumTest");
//        id3.setInterpret("IntTest");
//        id3.setJahr("2010");
//        id3.setTitel("TestTitel");
//
//        ConvertMp2ToMp3 c = new ConvertMp2ToMp3(in, out, id3, new File("/usr/local/bin/lame"), false);
//        c.startEncoding();
//        System.out.println("Fertig ...");
//    }
}