package tsStreamRipper.audio;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class ConverterFactory
{
    private static final Logger log = Logger.getLogger(ConverterFactory.class.getName());

    public enum ConverterType
    {
        AAC,
        MP3
    };

    public static IExternalEncoder getEncoder(ConverterOption opt, File inFile, ID3 id3, File tmpDir)
    {
        CharSequence outFileName = inFile.getAbsolutePath();
        outFileName = outFileName.subSequence(0, outFileName.length() - 3);
        StringBuilder sb = new StringBuilder(outFileName).append(getFileExtension(opt.getType()));
        File outFile = new File(sb.toString());

        if (opt.getType().equals(ConverterType.MP3))
        {
            // MP2-Datein werden mit der Endung .MP3 gespiechert. Von daher müssen sie
            // zunächst nach MP2 umbenannt werden, damit die Zieldatei eine MP3 Endung
            // bekommen kann

            CharSequence mp2FileName = inFile.getAbsolutePath();
            mp2FileName = mp2FileName.subSequence(0, mp2FileName.length() - 3);
            File tmpFile = new File(mp2FileName + "mp2");
            inFile.renameTo(tmpFile);
            inFile = tmpFile;
            log.fine(" : " + inFile.getAbsolutePath());
        }

//        log.fine("Konverter");
//        log.fine("================================================================================");
//        log.fine("Inputfile  : " + inFile.getAbsolutePath());
//        log.fine("Outputfile : " + outFile.getAbsolutePath());

        if (opt.getType().equals(ConverterType.AAC))
        {
            try
            {
                return new ConvertMp2ToAAC(inFile, outFile, id3, tmpDir, opt.getConverterPath(), opt
                        .isRemoveOriginalFile());
            }
            catch (IOException e)
            {
                log.severe("Fehler beim Erstellen des Converter-Threads:");
                e.printStackTrace();
            }
        }
        else if (opt.getType().equals(ConverterType.MP3))
        {
            try
            {
                return new ConvertMp2ToMp3(inFile, outFile, id3, opt.getConverterPath(), opt
                        .isRemoveOriginalFile());
            }
            catch (IOException e)
            {
                log.severe("Fehler beim Erstellen des Converter-Threads:");
                e.printStackTrace();
            }
        }
        else
        {
            log.severe("Unknown Type : " + opt.getType().toString());
        }
        return null;
    }

    private static String getFileExtension(ConverterType type)
    {
        switch (type)
        {
        case AAC:
            return "m4a";
        case MP3:
            return "mp3";
        default:
            log.severe("Unknown Type : " + type.toString());
            return "";
        }
    }
}
