package tsStreamRipper.audio;

import java.io.File;

import tsStreamRipper.audio.ConverterFactory.ConverterType;

public class ConverterOption
{
    private ConverterType type = null;
    private File converterPath = null;
    private boolean removeOriginalFile = false;

    public ConverterType getType()
    {
        return type;
    }

    public File getConverterPath()
    {
        return converterPath;
    }

    public boolean isRemoveOriginalFile()
    {
        return removeOriginalFile;
    }

    public ConverterOption(ConverterType type, File converterPath, boolean removeOriginalFile) throws Exception
    {
        super();
        this.type = type;
        this.converterPath = converterPath;
        this.removeOriginalFile = removeOriginalFile;

        if (!converterPath.exists())
        {
            throw new Exception("Externes Konvertierungsprogramm kann nicht gefunden werden : "
                    + converterPath.getAbsolutePath());
        }

        if (converterPath.isDirectory())
        {
            throw new Exception(
                    "Der angegebene Pfad ist ein Verzeichnis. Externes Konvertierungsprogramm bitte Vollqualifiziert angeben (z.B. mit 'c:/faac/faac.exe') : "
                            + converterPath.getAbsolutePath());
        }
        if (!converterPath.canExecute())
        {
            throw new Exception("Das angegebene Konvertierungsprogramm ist nicht ausführbar : "
                    + converterPath.getAbsolutePath());
        }

    }

}
