package tsStreamRipper.dream.webinterface;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import tsStreamRipper.dream.webinterface.parser.BaseCommandParser;
import tsStreamRipper.dream.webstreaming.IExceptionCallback;

public class CheckStandbyCommand extends WebCommand
{
    private Boolean inStandby = null;

    private boolean toggleState = false;

    public CheckStandbyCommand(HttpParameter httpParameter, IExceptionCallback exceptionCallback)
    {
        super(httpParameter, exceptionCallback);
    }

    public CheckStandbyCommand(HttpParameter httpParameter, IExceptionCallback exceptionCallback, boolean toggleState)
    {
        super(httpParameter, exceptionCallback);
        this.toggleState = toggleState;
    }

    public Boolean getInStandby()
    {
        return inStandby;
    }

    @Override
    protected String getCommandName()
    {
        if (!toggleState)
        {
            return "powerstate";
        }
        else
        {
            return "powerstate?newstate=0";
        }
    }

    @Override
    protected DefaultHandler getDocumentParser()
    {
        return new BaseCommandParser()
        {
            @Override
            protected String[] getKeysOfInterest()
            {
                return new String[]
                { "e2instandby" };
            }

            @Override
            public void endDocument() throws SAXException
            {
                super.endDocument();
                String inSB = getKeyValues().get("e2instandby");
                if (inSB != null)
                {
                    inStandby = Boolean.parseBoolean(inSB);
                }
            }
        };
    }
}
