package tsStreamRipper.dream.webinterface;

/**
 * HTTP Parameter Datenstruktur
 */
public class HttpParameter
{
    /**
     * Stream Host
     */
    private String host = null;
    /**
     * Stream Port
     */
    private int port = 8001;
    
    /**
     * Port des WebInterfaces
     */
    private int webPort = 80;
    
    // Authentifizierung
    private String user = "";
    private String pass = "";

    /**
     * 
     * @param host
     *            Hostname/IP
     * @param webPort
     *            Port des WebInterfaces
     * @param port
     *            Port des Streaming Interfaces
     * @param user
     *            Username
     * @param pass
     *            Passwort
     */
    public HttpParameter(String host, int webPort, int port, String user, String pass)
    {
        super();
        this.host = host;
        this.port = port;
        this.webPort = webPort;
        if (user != null)
            this.user = user;
        if (pass != null)
            this.pass = pass;
    }

    public String getHost()
    {
        return host;
    }

    public int getPort()
    {
        return port;
    }

    public String getUser()
    {
        return user;
    }

    public String getPass()
    {
        return pass;
    }

    public void setPort(int port)
    {
        this.port = port;
    }

    public int getWebPort()
    {
        return webPort;
    }

}
