package tsStreamRipper.dream.webinterface;

import org.xml.sax.helpers.DefaultHandler;

import tsStreamRipper.dream.webinterface.parser.GetCurrentParser;
import tsStreamRipper.dream.webstreaming.IDurationCallback;
import tsStreamRipper.dream.webstreaming.IEitCallback;
import tsStreamRipper.dream.webstreaming.IExceptionCallback;

/**
 * Dreambox-Webinterface Command : /getcurrent.<br>
 * 
 * Da die Dreambox über das Streaming-Interface keine PID mit EIT Informationen über alle verfügbaren Kanäle schickt,
 * müssen wir sie uns aus der Dreambox selber rausholen. Dieses Kommando liefert Info's über das aktuell eingestellte
 * Programm.
 * 
 */
public class StreamInfo extends WebCommand
{
    private IDurationCallback duration = null;
    private IEitCallback epg = null;
    
    /**
     *
     * @param duration
     *            Callback für Aufnahmedauer
     * @param epg
     *            Callback für den EPG-Handler, der die EIT ausließt.
     */
    public StreamInfo(HttpParameter httpParameter, IExceptionCallback exceptionCallback, IDurationCallback duration, IEitCallback epg)
    {
        super(httpParameter, exceptionCallback);
        this.duration = duration;
        this.epg = epg;
    }

    @Override
    protected String getCommandName()
    {
        // geht nicht ... muss neues WebIF her ...
//        return "epgservice?sRef="+sRef;
        return "getcurrent";
    }

    @Override
    protected DefaultHandler getDocumentParser()
    {
        return new GetCurrentParser(duration, epg);
    }
    
    @Override
    protected boolean doDebugContent()
    {
        return false;
    }

}
