package tsStreamRipper.dream.webinterface;

import org.xml.sax.helpers.DefaultHandler;

import tsStreamRipper.dream.webinterface.parser.ZapCommandParser;
import tsStreamRipper.dream.webstreaming.IExceptionCallback;

/**
 * Schaltet die Dreambox auf die <code>channelId</code>
 */
public class ZapCommand extends WebCommand
{
    private String channelId = null;
    
    public ZapCommand(HttpParameter httpParameter, IExceptionCallback exceptionCallback, String channelId)
    {
        super(httpParameter, exceptionCallback);
        this.channelId = channelId;
    }

    @Override
    protected String getCommandName()
    {
        return "zap?sRef=" + channelId;
    }

    @Override
    protected DefaultHandler getDocumentParser()
    {
        return new ZapCommandParser();
    }

    /**
     * Nach dem Zappen der Box 2 Sekunden zum Programmwechsel geben
     */
    @Override
    protected long sleepTimeBeforeNotify()
    {
        return 2000;
    }
}
