package tsStreamRipper.dream.webinterface.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * Generischer XML Parser für Key-Value Paarungen, ohne Baumstruktur ... 
 */
abstract public class BaseCommandParser extends DefaultHandler
{
    private String currentKey = null;

    private HashSet<String> myKeys = new HashSet<String>();

    private HashMap<String,String> myValues = new HashMap<String, String>();

    protected abstract String[] getKeysOfInterest();

    /**
     * @return Fertige Datenstruktur als Key-Value Paarung. 
     */
    protected HashMap<String, String> getKeyValues()
    {
        return myValues;
    }
    
    @Override
    public void startDocument() throws SAXException
    {
        super.startDocument();
        Collections.addAll(myKeys, getKeysOfInterest());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException
    {
        String key = qName.toLowerCase();
        if (myKeys.contains(key))
        {
            currentKey = key;
        }
        else
        {
            currentKey = null;
        }
    }
    
    @Override
    public void characters(char[] ch, int start, int length) throws SAXException
    {
        if (currentKey != null)
        {
            String s = new String(ch, start, length).trim();
            if (!"".equalsIgnoreCase(s))
            {
                myValues.put(currentKey, s);
            }
        }
    }
    
    
}
