package tsStreamRipper.dream.webinterface.parser;

import java.lang.reflect.Constructor;
import java.util.logging.Logger;

import tsStreamRipper.dream.filestream.FileStream;
import tsStreamRipper.dream.webstreaming.IEitCallback;

public enum EPGType
{
    SKY_RADIO("SKY Radio", SkyRadioEpgInfo.class),
    SWISS_SATELLITE_RADIO("Swiss Satellite Radio", SwissSatelliteRadioEpgInfo.class),
    KD_23_5_GRAD("KD 23,5°", KdEpgInfo.class);
    
    private static final Logger log = Logger.getLogger(EPGType.class.getName());
    private String display = null;
    private Class<? extends IEitCallback> epgClass = null;
    
    
    @Override
    public String toString()
    {
        return display;
    }
    
    private EPGType(String display, Class<? extends IEitCallback> epgClass)
    {
        this.display = display;
        this.epgClass = epgClass;
    }
    
    public IEitCallback getEpgParser(FileStream fs)
    {
        try
        {
            Constructor<? extends IEitCallback> constructor = epgClass.getConstructor(new Class[]{FileStream.class});
            IEitCallback epgParser = constructor.newInstance(new Object[]{fs});
            return epgParser;
        }
        catch (Exception e)
        {
            log.severe("Kann EPG Parser nicht instanziieren.");
            throw new RuntimeException(e);
        }
    }
}
