package tsStreamRipper.dream.webinterface.parser;

import java.util.logging.Logger;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import tsStreamRipper.dream.webstreaming.IDurationCallback;
import tsStreamRipper.dream.webstreaming.IEitCallback;

/**
 * Parser für die XML-Rückgabestruktur der Web-Befehls "/getcurrent"
 */
public class GetCurrentParser extends DefaultHandler
{
    private static final Logger log = Logger.getLogger(GetCurrentParser.class.getName());

    private IDurationCallback duration = null;

    private IEitCallback epgCallback = null;

    private State currentState = null;

    private E2Event event = null;

    private E2Event currentEvent = null;

    public GetCurrentParser(IDurationCallback duration, IEitCallback epgCallback)
    {
        this.duration = duration;
        this.epgCallback = epgCallback;
    }

    public enum State
    {
        e2eventlist,
        e2eventservicereference,
        e2event,
        e2eventid,
        e2eventstart,
        e2eventcurrenttime,
        e2eventremaining,
        e2eventdescription,
        e2eventdescriptionextended,
        e2eventtitle
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException
    {
        currentState = getEnumState(qName);

        if (currentState == null)
        {
            return;
        }

        switch (currentState)
        {
        case e2event:
            event = new E2Event();
            break;

        default:
            break;
        }
    }

    private State getEnumState(String enumName)
    {
        try
        {
            State s = State.valueOf(enumName);
            return s;
        }
        catch (Exception e)
        {
            return null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException
    {
        if (currentState == null)
        {
            return;
        }
        switch (currentState)
        {
        case e2eventcurrenttime:
            event.addE2eventcurrenttime(new String(ch, start, length));
            break;
        case e2eventstart:
            event.addE2eventstart(new String(ch, start, length));
            break;
        case e2eventid:
            event.addE2eventid(new String(ch, start, length));
            break;
        case e2eventdescriptionextended:
            event.addE2eventdescriptionextended(new String(ch, start, length));
            break;
        case e2eventtitle:
            event.addE2eventtitle(new String(ch, start, length));
            break;
        case e2eventremaining:
            event.addE2eventremaining(new String(ch, start, length));
            break;
        case e2eventdescription:
            event.adde2Eventdescription(new String(ch, start, length));
            break;
        default:
            break;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException
    {
        State endState = getEnumState(qName);
        if (endState == null)
        {
            return;
        }
        switch (endState)
        {
        case e2event:
            if (event.isCurrentRunningEvent())
            {
                currentEvent = event;
            }
            event = new E2Event();
            break;

        default:
            break;
        }
    }

    @Override
    public void endDocument() throws SAXException
    {
        if (currentEvent != null)
        {
            // Restdauer dem aufrufenden Thread mitteilen
            duration.setDuration(currentEvent.getRemaining());
            
            // EPG Informationen zurückmelden 
            epgCallback.setTitle(currentEvent.getE2eventtitle());
            epgCallback.setEventDescription(currentEvent.getE2eventdescription());
            epgCallback.setExtendedInfo(currentEvent.getE2eventdescriptionextended());

            // user darüber informieren ...
            log.info(String.format("Aktueller Stream : %s mit Restdauer von %s Sekunden.", currentEvent
                    .getE2eventtitle(), currentEvent.getRemaining()));
        }
        else
        {
            log.warning("Keine Information über aktuellen Stream vorhanden.");
            log.warning("Falls HTTP Authentifizierung aktiv ist, muss \"-user\" und \"-pass\" gesetzt sein!");
        }
    }
}
