package tsStreamRipper.dream.webinterface.parser;

import java.util.logging.Level;
import java.util.logging.Logger;

import tsStreamRipper.dream.filestream.FileStream;
import tsStreamRipper.dream.webstreaming.IEitCallback;
import tsStreamRipper.util.SimpleStringTokenizer;

public class KdEpgInfo implements IEitCallback
{
    private static final Logger log = Logger.getLogger(KdEpgInfo.class.getName());

    private FileStream fs = null;

    public KdEpgInfo(FileStream fs)
    {
        this.fs = fs;
    }

    @Override
    public void setTitle(String title)
    {
        // Ignored
    }

    @Override
    public void setExtendedInfo(String extendedInfo)
    {
        // Ignored
    }

    @Override
    public void setEventDescription(String eventDescription)
    {
        SimpleStringTokenizer line = new SimpleStringTokenizer(eventDescription, '\n');
        while (line.hasMoreTokens())
        {
            SimpleStringTokenizer kv = new SimpleStringTokenizer(line.nextToken(), ':');
            String key = kv.nextToken().toString().trim();
            String value = kv.nextToken().toString().trim();
            if (key.equalsIgnoreCase("Song"))
            {
                if (log.isLoggable(Level.FINER))
                    log.finer("setting Titel : '" + value + "'");
                fs.setTitel(value);
            }
            else if (key.equalsIgnoreCase("Artist"))
            {
                if (log.isLoggable(Level.FINER))
                    log.finer("Interpret : '" + value + "'");
                fs.setInterpret(value);
            }
            else if (key.equalsIgnoreCase("Album"))
            {
                if (log.isLoggable(Level.FINER))
                    log.finer("setting Album : '" + value + "'");
                fs.setAlbum(value);
            }
            else if (key.equalsIgnoreCase("Jahr"))
            {
                if (log.isLoggable(Level.FINER))
                    log.finer("setting Jahr : '" + value + "'");
                fs.setJahr(value);
            }
        }
    }

}
