package tsStreamRipper.dream.webinterface.parser;

import java.util.logging.Level;
import java.util.logging.Logger;

import tsStreamRipper.dream.webstreaming.IEitCallback;
import tsStreamRipper.dream.filestream.FileStream;
import tsStreamRipper.util.SimpleStringTokenizer;

/**
 * EPG Parser für SKY RADIO
 */
public class SkyRadioEpgInfo implements IEitCallback
{
    private static final Logger log = Logger.getLogger(SkyRadioEpgInfo.class.getName());

    private FileStream fs = null;
    
    public SkyRadioEpgInfo(FileStream fs)
    {
        this.fs = fs;
    }
    
    @Override
    public void setExtendedInfo(String extendedInfo)
    {
        // Titel & Album

        SimpleStringTokenizer line = new SimpleStringTokenizer(extendedInfo, '\n');
        while (line.hasMoreTokens())
        {
            SimpleStringTokenizer kv = new SimpleStringTokenizer(line.nextToken(), ':');
            String key = kv.nextToken().toString().trim();
            String value = kv.nextToken().toString().trim();
            if (key.equalsIgnoreCase("Titel"))
            {
                if (log.isLoggable(Level.FINER))
                    log.finer("setting Titel : '" + value + "'");
                fs.setTitel(value);
            }
            else if (key.equalsIgnoreCase("Album"))
            {
                if (log.isLoggable(Level.FINER))
                    log.finer("setting Album : '" + value + "'");
                fs.setAlbum(value);
            }
            else if (key.equalsIgnoreCase("Jahr"))
            {
                if (log.isLoggable(Level.FINER))
                    log.finer("setting Jahr : '" + value + "'");
                fs.setJahr(value);
            }
        }
    }

    @Override
    public void setTitle(String title)
    {
        SimpleStringTokenizer sst = new SimpleStringTokenizer(title, ':');
        sst.nextToken();
        CharSequence s = sst.nextToken();
        if (s.length() > 0)
        {
            try
            {
                String fn = s.subSequence(1, s.length()).toString().trim();
                if (log.isLoggable(Level.FINER))
                    log.finer("Interpret : '" + fn + "'");
                fs.setInterpret(fn);
            }
            catch (Exception e)
            {
                log.warning(String.format("Exception - Kann Titel nicht setzen. EPG Data : %s", title));
            }
        }
        else
        {
            log.warning(String.format("Kann Titel nicht setzen. EPG Data : '%s'", title));
        }
    }

    @Override
    public void setEventDescription(String eventDescription)
    {
        // Ignored
    }

}
