package tsStreamRipper.dream.webstreaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Logger;

/**
 * Ein OutputStream, der überwacht werden kann, weil die auf den OutputStream geschriebenen Bytes über den InputStream
 * zur Verfügung gestellt werden.
 * 
 * Achtung:<br>
 * Der InputStream muss ausgelesen werden, weil ansonsten die Datenverabeitung in den OutputStream stockt.
 * 
 */
public class ObservableOutputStream extends OutputStream
{
    private static final Logger log = Logger.getLogger(ObservableOutputStream.class.getName());
    
    private PipedInputStream in = null;
    private PipedOutputStream outPipe = null;

    private OutputStream base = null;

    public ObservableOutputStream(OutputStream out)
    {
        super();
        base = out;

        in = new PipedInputStream();
        try
        {
            outPipe = new PipedOutputStream(in);
        }
        catch (IOException e)
        {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(int b) throws IOException
    {
        try
        {
            base.write(b);
        
            // notify Observer ...
            outPipe.write(b);
        }
        catch (IOException e)
        {
            // Wenn der Observer (in unserem Fall die Stilleerkennung) fertig ist, terminiert er. In diesem Fall 
            // bekommt man eine IOException mit "Read End Dead".
            log.finer(e.getMessage());
        }
    }

    /**
     * Observierbarer InputStream
     * 
     * @return
     */
    public InputStream getObserver()
    {
        return in;
    }
}
