package tsStreamRipper.dream.webstreaming;

import java.io.IOException;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.ClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

import tsStreamRipper.dream.webinterface.HttpParameter;

/**
 * Basisklasse zur Kommunikation mit der Dreambox.
 */
public abstract class StreamBase extends Thread
{
    private HttpParameter httpParameter = null;

    private IExceptionCallback exceptionCallback = null;
    
    private boolean stopStreaming = false;

    public StreamBase(HttpParameter httpParameter, IExceptionCallback exceptionCallback)
    {
        this.httpParameter = httpParameter;
        this.exceptionCallback = exceptionCallback;
    }

    /**
     * @return Das Ergebnis der Anfrage.
     * 
     * @throws IOException
     * @throws ClientProtocolException
     */
    protected HttpEntity getEntity() throws Exception
    {
        try
        {
            HttpClient httpclient = new DefaultHttpClient();
            HttpContext localContext = new BasicHttpContext();
            CredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, AuthScope.ANY_PORT), new UsernamePasswordCredentials(
                    httpParameter.getUser(), httpParameter.getPass()));
            localContext.setAttribute(ClientContext.CREDS_PROVIDER, credsProvider);

            HttpGet httpget = new HttpGet(getUrl());
            HttpResponse response = httpclient.execute(httpget, localContext);

            HttpEntity entity = response.getEntity();
            return entity;
        }
        catch (Exception e)
        {
            // Caller benachrichtigen, das ein Fehler passiert ist.
            exceptionCallback.exceptionOccured(e);
            throw e;
        }
    }

    abstract protected String getUrl();

    public HttpParameter getHttpParameter()
    {
        return httpParameter;
    }

    /**
     * Thread soll stoppen ...
     */
    public void stopStreamBaseThread()
    {
        this.stopStreaming = true;
    }
    
    public boolean isThreadStopping()
    {
        return stopStreaming;
    }
}
