package tsStreamRipper.mp3;

import javazoom.jl.decoder.Obuffer;


/**
 * Einfache Ruheerkennung.
 */
public class SilenceRecognitionBuffer extends Obuffer
{

    private int silenceCountLeft = 0;
    private int silenceCountRight = 0;
    

    /**
     * Ruhe-Schwelle (Absolut).
     */
    private int silThres = 0; // 55 Threshold mit 7er Schwelle war noch OK

    /**
     * Anzahl der Samples, die unterhalb des Schwelle liegen müssen, bevor Ruhe erkannt wird.
     * 
     * Unterhalb 7 Samples wirds eng. Dann kann es dazu kommen, das Musiksücke zu früh abgeschnitten werden.
     */
    private int silSamples = 0;   

    public SilenceRecognitionBuffer(int schwelle, int samples)
    {
        silThres = schwelle;
        silSamples = samples;
    }
    
    @Override
    public void append(int arg0, short arg1)
    {
        if (arg0 == 0)
        {
            if (Math.abs(arg1) < silThres)
            {
                silenceCountLeft++;
            }
            else
            {
                silenceCountLeft = 0;
            }
        }
        if (arg0 == 1)
        {
            if (Math.abs(arg1) < silThres)
            {
                silenceCountRight++;
            }
            else
            {
                silenceCountRight = 0;
            }
        }
    }

    public boolean isSilence()
    {
        return silenceCountLeft >= silSamples && silenceCountRight >= silSamples;
    }
    

    @Override
    public void clear_buffer()
    {
    }

    @Override
    public void close()
    {
    }

    @Override
    public void set_stop_flag()
    {
    }

    @Override
    public void write_buffer(int arg0)
    {
    }
}
