package tsStreamRipper.mpeg;

import java.util.logging.Logger;

/**
 * PES Header including sync block. Code übernommen aus dem 'mpeg2pesdemux' Projekt.
 */
public class MPEG2PESHeader
{
    private static final Logger log = Logger.getLogger(MPEG2PESHeader.class.getName());

    private byte[] data = null;

    private int headerOffset = 6;

    /**
     * Header should habe at least 12 bytes ...
     * 
     * @param header
     * @param type
     */
    public MPEG2PESHeader(byte[] header)
    {
        data = header;
        if (header[0] == 0 && header[1] == 0 && header[2] == 1)
        {
            // info();
        }
        else
        {
            log.warning("PES Header invalid ... Should start with 0x00 0x00 0x01.");
        }
    }

    public int getSize()
    {
        return (int) ((0xff & data[4]) << 8) + (int) (0xff & data[5]);
    }

    public int getType()
    {
        return 0xff & data[3];
    }

    public boolean isMetaStreamPacket()
    {
        return (0xE0 & getType()) == 0xE0 || (0xE0 & getType()) == 0xC0;
    }

    public boolean isVideoPacket()
    {
        return (0xE0 & getType()) == 0xE0;
    }

    public boolean isAudioPacket()
    {
        return (0xE0 & getType()) == 0xC0;
    }

    public boolean hasPTS()
    {
        return data != null && getSize() > 0 && (128 & data[headerOffset + 1]) > 0;
    }

    public boolean hasDTS()
    {
        return data != null && getSize() > 0 && (64 & data[headerOffset + 1]) > 0;
    }

    public long getPTS()
    {
        if ((128 & data[headerOffset + 1]) > 0)
        {
            return 0xFFFFFFFFL & (14L & data[headerOffset + 3]) << 28 | (255L & data[headerOffset + 4]) << 22
                    | (254L & data[headerOffset + 5]) << 14 | (255L & data[headerOffset + 6]) << 7
                    | (254 & data[headerOffset + 7]) >>> 1;
        }
        return 0;
    }

    public long getDTS()
    {
        if ((128 & data[headerOffset + 1]) > 0)
        {
            return 0xFFFFFFFFL & (14L & data[headerOffset + 8]) << 28 | (255L & data[headerOffset + 9]) << 22
                    | (254L & data[headerOffset + 10]) << 14 | (255L & data[headerOffset + 11]) << 7
                    | (254 & data[headerOffset + 12]) >>> 1;
        }
        return 0;
    }
    
    public String info()
    {
        StringBuilder sb = new StringBuilder();
        if (isAudioPacket())
        {
            sb.append("AUDIO ");
            if (hasPTS())
            {
                sb.append("PTS");
            }
            if (hasDTS())
            {
                sb.append("DTS");
            }
        }
        else if (isVideoPacket())
        {
            sb.append("VIDEO");
        }
        else
        {
            sb.append("UNKNOWN");
        }
        return sb.toString();
    }
}
