package tsStreamRipper.mpeg;

import java.io.IOException;
import java.util.logging.Logger;

import mpeg2demux.MPEG2PESPacket;

/**
 * Hier kann ein MPEG2PES Packet direkt im Konstruktor übergeben werden.
 * 
 * Intern wird ohne dem 6-Byte großen Header gearbeitet. Deshalb wird der Abgeschnitten und nur die Nutzdaten übergeben.
 * 
 * Header :<br>
 * ==============================================<br>
 * 3 byte PES-Packet packet start : 0x00 0x00 0x01<br>
 * 1 byte streamId<br>
 * 2 bytes PES-Packet length<br>
 */
public class MPEG2PESPacketExt extends MPEG2PESPacket
{
    private static final Logger log = Logger.getLogger(MPEG2PESPacketExt.class.getName());

    private int PES_SIZE = 0;

    /**
     * 
     * @param PESdata
     * @throws IOException
     */
    public MPEG2PESPacketExt(byte[] PESdata) throws IOException
    {
        if (PESdata[0] == 0 && PESdata[1] == 0 && PESdata[2] == 1)
        {
            int streamId = 0xff & PESdata[3];

            if ((streamId & 0xE0) == 0xE0 || (streamId & 0xE0) == 0xC0)
            {
                setType(streamId);
                PES_SIZE = (int) ((0xff & PESdata[4]) << 8) + (int) (0xff & PESdata[5]);
                data = new byte[PES_SIZE];
                if (PES_SIZE != PESdata.length - 6)
                {
                    log.warning("PES SIZE differs from data Size : " + PES_SIZE + " / " + (PESdata.length - 6));
                    PES_SIZE = Math.min(PESdata.length, PES_SIZE) - 6;
                }
                System.arraycopy(PESdata, 6, data, 0, PES_SIZE);
                size = PES_SIZE;
            }
            else
            {
                throw new IOException("Unknown STREAM-ID");
            }
        }
        else
        {
            throw new IOException("Invalid PES HEADER.");
        }
    }

    public int getPesSize()
    {
        return PES_SIZE;
    }
}
