package tsStreamRipper.mpeg.elementarystream;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;

/**
 * Diese Klasse bildet einen Elementary Streams ab. Ihre Aufgabe besteht darin die einzelnen Transportstrom Segemente
 * zu einem einem Paket zusammen zu setzen.
 */
public abstract class ElementaryStream
{
    /**
     * AUDIO : Audio-Stream VIDEO : Video-Stream PSI : Andere Prorgamm Spezifische Streams
     */
    public enum StreamType
    {
        AUDIO,
        VIDEO,
        PSI
    };

    private static final Logger log = Logger.getLogger(ElementaryStream.class.getName());

    private long pid = 0;
    
    int errorCnt = 0;

    private StreamType type = null;

    // PES reassemble PES Frames
    private boolean isSynced = false;
    private int currentpos = 0;
    private byte[] elementaryFrameBuffer = new byte[65536];

    public ElementaryStream(long pid, StreamType type)
    {
        this.pid = pid;
        this.type = type;
    }

    public void handleAdaptionField(byte[] adaptionField)
    {
        
    }
    
    /**
     * Hier landen einzelne PES Segmente
     * 
     * @param pesFrame
     *            Payload of Transport Packet
     * 
     * @param payloadStart
     *            Payload starts Flag
     * 
     * @throws IOException
     */
    public void handlePacket(byte[] pesFrame, boolean payloadStart) throws IOException
    {
        if (!isSynced)
        {
            if (payloadStart)
            {
                isSynced = true;
            }
            else
            {
                log.info("synchronisiere PES Packet ...");
                return;
            }
        }

        if (payloadStart)
        {
            // handle completed Frame
            byte[] reassembeldPesPacket = new byte[currentpos];
            System.arraycopy(elementaryFrameBuffer, 0, reassembeldPesPacket, 0, currentpos);
            handleCompletePacket(reassembeldPesPacket);
            // Reset buffer
            currentpos = 0;
            Arrays.fill(elementaryFrameBuffer, (byte) 0);
        }
        System.arraycopy(pesFrame, 0, elementaryFrameBuffer, currentpos, pesFrame.length);
        currentpos += pesFrame.length;
    }

    private void handleCompletePacket(byte[] reassembeldPesPacket)
    {
        if (reassembeldPesPacket.length < 3)
        {
            log.warning("PES Packet is leer ...");
            return;
        }

        if (reassembeldPesPacket[0] == 0x00 && reassembeldPesPacket[1] == 0x00 && reassembeldPesPacket[2] == 0x01)
        {
            try
            {
                handleCompletePESPacket(reassembeldPesPacket);
                errorCnt = 0;
            }
            catch (Exception e)
            {
                e.printStackTrace();
            }
        }
        else if (reassembeldPesPacket[0] == 0x00)
        {
            try
            {
                handleCompletePSIPacket(reassembeldPesPacket);
                errorCnt = 0;
            }
            catch (Exception e)
            {
                e.printStackTrace();
                log.warning("PSI Packet kann nicht verarbeitet werden ...");
            }
        }
        else
        {
            errorCnt++;
            log.warning("Kein PES Payload gefunden ...");
        }
        
        if (errorCnt > 10)
        {
            log.severe("PES Payload vermutlich verschlüsselt. Bitte CAM/Karte prüfen.");
            throw new RuntimeException("PES Payload vermutlich verschlüsselt. Bitte CAM/Karte prüfen.");
        }
    }

    public long getPid()
    {
        return pid;
    }

    public StreamType getType()
    {
        return type;
    }

    protected abstract void handleCompletePESPacket(byte[] pesPacket) throws IOException;

    protected abstract void handleCompletePSIPacket(byte[] psiPacket) throws IOException;
}
