package tsStreamRipper.mpeg.elementarystream;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

import mpeg2demux.MPEG2StreamDemuxer;
import tsStreamRipper.mpeg.MPEG2PESPacketExt;

/**
 * Diese Implementierung verarbeitet PES Pakete und schreibt den Nutzdatenanteil in einen OutputStream.
 * 
 * Das Verarbeiten der PES Pakete selbst erfolgt derzeit durch 'mpeg2demux' von Andreas Rosenberg. Sie scheint, soweit
 * ich das sehen kann, zu funktionieren. Ansonsten müsste die Nutzdatenextraktion gemäß PES Paket Spezifikation
 * hier erfolgen.
 */
public class OutputElementaryStream extends ElementaryStream
{
    private static final Logger log = Logger.getLogger(OutputElementaryStream.class.getName());

    private MPEG2StreamDemuxer demuxer = new MPEG2StreamDemuxer();

    public OutputElementaryStream(long pid, StreamType type, OutputStream os)
    {
        super(pid, type);
        setOutputStream(os);
    }

    @Override
    protected void handleCompletePESPacket(byte[] pesPacket) throws IOException
    {
        MPEG2PESPacketExt packet = new MPEG2PESPacketExt(pesPacket);
        demuxer.onPacketReceive(packet, 0, null);
    }

    @Override
    protected void handleCompletePSIPacket(byte[] psiPacket) throws IOException
    {
        log.warning("cannot handle PSI data");
    }

    /**
     * Setzt einen neuen OutputStream
     * 
     * @param out
     *            Der neue OutputStream
     */
    public void setOutputStream(OutputStream out)
    {
        demuxer.setAudioOut(new BufferedOutputStream(out));
    }
}
