package tsStreamRipper.mpeg.elementarystream;

import java.io.IOException;
import java.util.logging.Logger;

import tsStreamRipper.mpeg.section.pat.Pat;

/**
 * Hier wir die PAT Tabelle der Transportstroms analysiert. 
 */
public class PatElementaryStream extends ElementaryStream
{
    private static final Logger log = Logger.getLogger(PatElementaryStream.class.getName());
    
    public PatElementaryStream(long pid)
    {
        super(pid, StreamType.PSI);
    }

    @Override
    protected void handleCompletePESPacket(byte[] pesPacket) throws IOException
    {
        log.warning("cannot handle PES Packets");
    }

    @Override
    protected void handleCompletePSIPacket(byte[] psiPacket) throws IOException
    {
        //
        // Die PID's die aufgeführt werden, scheinen im WebStream nicht drin zu sein ... 
        // Von daher können wir die EIT Tabelle nicht auslesen! Also schenken wir uns auch die Analyse der
        // PAT Tabelle
        //
        
//        Pat p = new Pat(psiPacket);
//        System.out.println(p.info());
    }

}
