package tsStreamRipper.mpeg.section.pat;

import java.util.ArrayList;
import java.util.List;

import tsStreamRipper.util.BitCoder;

/**
 * Section Table : PAT
 */
public class Pat
{
    private int table_id;
    @SuppressWarnings("unused")
    private int pointer_field;
    private int section_syntax_indicator;
    @SuppressWarnings("unused")
    private int reserved_1;
    private int section_length;
    private int transport_stream_id;
    @SuppressWarnings("unused")
    private int reserved_2;
    @SuppressWarnings("unused")
    private int version_number;
    private int current_next_indicator;
    private int section_number;
    private int last_section_number;

    private BitCoder bc = new BitCoder();

    private List<PatListEntry> patList = new ArrayList<PatListEntry>();

    /**
     * PAT
     * 
     * @param pat
     *            PAT byte[]
     */
    public Pat(byte[] b)
    {
        pointer_field = b[0];
        table_id = b[1];
        section_syntax_indicator = bc.getBits(b, 1, 8, 1);
        reserved_1 = bc.getBits(b, 1, 10, 2);
        section_length = bc.getBits(b, 1, 12, 12);
        transport_stream_id = bc.getBits(b, 1, 24, 16);
        reserved_2 = bc.getBits(b, 1, 40, 2);
        version_number = bc.getBits(b, 1, 42, 5);
        current_next_indicator = bc.getBits(b, 1, 47, 1);
        section_number = bc.getBits(b, 1, 48, 8);
        last_section_number = bc.getBits(b, 1, 56, 8);

        int posistion = 9; // 72 Bit gelesen = 9. Bytes
        while ((b[posistion] & 0xff) != 0xFF && posistion <= b.length - 5)
        {
            patList.add(new PatListEntry(b, posistion * 8));
            posistion += 4; // 32 Bit = 4 Bytes Pro Eintrag
        }

    }

    public String info()
    {
        StringBuilder sb = new StringBuilder();

        sb.append("");
        sb.append("PAT-Table. Lists : ").append((section_length - 12) / 4).append("\r\n");
        sb.append("======================================================\r\n");
        sb.append("TABLE_ID                 : ").append(table_id);
        if (table_id != 0)
        {
            sb.append(" ERROR. Should be 0x00");
        }
        sb.append("\r\n");
        sb.append("section length           : ").append(section_length).append("\r\n");
        sb.append("section number           : ").append(section_number).append("\r\n");
        sb.append("last section number      : ").append(last_section_number).append("\r\n");
        sb.append("section syntax indicator : ").append(section_syntax_indicator).append("\r\n");
        sb.append("current_next indicator   : ").append(current_next_indicator).append("\r\n");
        sb.append("transport stream ID      : ").append(transport_stream_id).append("\r\n");

        for (PatListEntry entry : patList)
        {
            sb.append(entry.info()).append("\r\n");
        }

        return sb.toString();
    }
}
