package tsStreamRipper.mpeg.section.pat;

import tsStreamRipper.util.BitCoder;

/**
 * Section Table PAT: Pat-Entries
 */
public class PatListEntry
{
    /**
     * Position of List-Entry in PAT
     */
    private int offset; 
    private byte[] pat;
    
    private BitCoder bc = new BitCoder();
    
    public PatListEntry(byte[] pat, int offset)
    {
        this.offset = offset;
        this.pat = pat;
    }
    
    public int getProgramNum()
    {
        return bc.getBits(pat, offset, 0, 16);
    }

    public int getProgramPid()
    {
        return bc.getBits(pat, offset, 19, 13);
    }
    
    public String info()
    {
        StringBuilder sb = new StringBuilder();
        sb.append("programm num : ").append(getProgramNum()).append(" on PID : ").append(getProgramPid());
        return sb.toString();
    }
}
