package tsStreamRipper.util;

/**
 * Hier sind einige Bitoperationen gekapselt.
 */
public class BitCoder
{

    /**
     * Setzt ein Bit.
     * 
     * @param bitmap
     *            Die Bitmap
     * 
     * @param newBit
     *            Das neue Bit
     * 
     * @return Logisches Oder. Carrylose bitweise addition.
     */
    public int addBit(int bitmap, int newBit)
    {
        return (bitmap | newBit);
    }

    /**
     * Setzt ein Bit.
     * 
     * @param bitmap
     *            Die Bitmap
     * 
     * @param newBit
     *            Das neue Bit
     * 
     * @return Logisches Oder. Carrylose bitweise addition.
     */
    public long addBit(long bitmap, long newBit)
    {
        return (bitmap | newBit);
    }

    /**
     * Entfernt ein Bit.
     * 
     * @param bitmap
     *            Die Bitmap. Diese wird nicht verändert!
     * 
     * @param newBit
     *            Das neue Bit
     * 
     * @return Die Bitmap ohne das Bit ...
     */
    public int removeBit(int bitmap, int removeBit)
    {
        return (bitmap & ~removeBit);
    }

    /**
     * @param bitmap
     *            Die Bitmap. Diese wird nicht verändert!
     * 
     * @param bitmap
     *            Die Bitmap
     * 
     * @param newBit
     *            Das neue Bit
     * 
     * @return Die Bitmap ohne das Bit ...
     */
    public long removeBit(long bitmap, long removeBit)
    {
        return (bitmap & ~removeBit);
    }

    /**
     * Überprüft ob alle geforderten Bits innerhalb der Bitmap gesetzt sind.
     * 
     * @param bitmap
     *            Die Bitmap
     * 
     * @param theBits
     *            Die geforderten Bits
     * 
     * @return TRUE : Die Bits sind gesetzt.
     *         <p>
     *         FALSE : Die Bits sind nicht gesetzt.
     */
    public boolean allBitsSet(int bitmap, int theBits)
    {
        return (bitmap & theBits) == theBits;
    }

    /**
     * Überprüft ob mindestens eines der geforderten Bits innerhalb der Bitmap gesetzt ist.
     * 
     * @param bitmap
     *            Die Bitmap
     * 
     * @param theBits
     *            Die geforderten Bits
     * 
     * @return TRUE : Die Bits sind gesetzt.
     *         <p>
     *         FALSE : Die Bits sind nicht gesetzt.
     */
    public boolean minOneBitSet(int bitmap, int theBits)
    {
        return (bitmap & theBits) != 0;
    }

    /**
     * 
     * @param bitmap
     *            Die Bitmap
     * 
     * @param Bitnummer
     *            Beginnend mit 0
     * @return
     */
    public boolean isBitSet(int bitmap, int bitnummer)
    {
        int base = 1;
        for (int i = 0; i < bitnummer; i++)
        {
            base = base << 1;
        }
        return (bitmap & base) != 0;
    }

    /**
     * Überprüft ob alle geforderten Bits innerhalb der Bitmap gesetzt sind.
     * 
     * @param bitmap
     *            Die Bitmap
     * 
     * @param theBits
     *            Die geforderten Bits
     * 
     * @return TRUE : Die Bits sind gesetzt.
     *         <p>
     *         FALSE : Die Bits sind nicht gesetzt.
     */
    public boolean allBitsSet(long bitmap, long theBits)
    {
        return (bitmap & theBits) == theBits;
    }

    /**
     * Überprüft ob mindestens eines der geforderten Bits innerhalb der Bitmap gesetzt ist.
     * 
     * @param bitmap
     *            Die Bitmap
     * 
     * @param theBits
     *            Die geforderten Bits
     * 
     * @return TRUE : Die Bits sind gesetzt.
     *         <p>
     *         FALSE : Die Bits sind nicht gesetzt.
     */
    public boolean minOneBitSet(long bitmap, long theBits)
    {
        return (bitmap & theBits) > 0;
    }

    /**
     * Gibt den Int aus einem Bitstream zurück ... Im Bitstream werden die Bit's von hi nach low gelesen.
     * 
     * @param bitStream
     *            Das Byte-Array mit den Werten
     * @param offset
     *            Optionaler Offset der zur <code>position</code> hinzugefügt wird.
     * @param position
     *            Erste Position
     * @param count
     *            Anzahl der Bits, die gelesen werden
     * @return
     */
    public int getBits(byte[] bitStream, int offset, int position, int count)
    {
        position += offset;
        int value = 0;

        for (int i = 0; i < count; i++)
        {
            int currentByte = position / 8;
            int currentBit = 7 - position % 8;
            value = value << 1;
            int uInt = (int) bitStream[currentByte] & 0xff;
            if (isBitSet(uInt, currentBit))
            {
                value += 1;
            }
            position++;
        }
        return value;
    }
}
