package tsStreamRipper.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream extends InputStream
{
//    private static final Logger log = Logger.getLogger("ByteBufferInputStream.class");
    
    private ByteBuffer buffer = null;

    public ByteBufferInputStream(ByteBuffer buffer)
    {
        this.buffer = buffer;
    }

    @Override
    public int read() throws IOException
    {
        if (!buffer.hasRemaining())
        {
            return -1;
        }
        return buffer.get();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException
    {
        //
        // Hier kann man sehen, wieviele Bytes aus dem Puffer gelesen werden ... 
        // JLayer hat hier 8192 Bytes gelesen, was weit über der MP2-Framesize liegt.
        // JLayer ist nun gepatched ... 
        //
        
//        log.severe(String.format("Buffer Offset : %d - Len : %d - Position : %d" , off, len, buffer.position()));
  
        
        len = Math.min(len, buffer.remaining());
        buffer.get(b, off, len);
        return len;
    }
}
