package tsStreamRipper.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream extends OutputStream
{
    // Backing Buffer
    private ByteBuffer buffer = null;
    
    public ByteBufferOutputStream()
    {
        this(1024*1024);  // Default 1 MB
    }
    
    public ByteBufferOutputStream(int bufferSize)
    {
        buffer = ByteBuffer.allocateDirect(bufferSize);
    }
    
    @Override
    public void write(int b) throws IOException
    {
        buffer.put((byte)b);
    }

    @Override
    public void write(byte[] b) throws IOException
    {
        buffer.put(b);
    }
    
    @Override
    public void write(byte[] b, int off, int len) throws IOException
    {
        buffer.put(b, off, len);
    }
    
    public ByteBuffer getBuffer()
    {
        return buffer;
    }
    
    /**
     * Löscht den gewrapptedn Buffer. Buffer ist anschließend leer.
     */
    public void clear()
    {
        buffer.clear();
    }
}
