package tsStreamRipper.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;


public class ByteOps
{
    private static String JAVA_CODE_PAGE = "ISO-8859-1";

    public final static Object convertByteArrayToObject(byte[] data)
        throws ClassNotFoundException, StreamCorruptedException, IOException
    {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ObjectInputStream ois;
        try
        {
            ois = new ObjectInputStream(bais);
            Object o = ois.readObject();

            ois.close();

            return o;
        }
        catch (StreamCorruptedException e)
        {
            throw e;
        }
        catch (IOException e)
        {
            throw e;
        }
        catch (ClassNotFoundException e)
        {
            throw e;
        }
    }

    public static String printHex(byte[] ba)
    {
        StringBuffer sb = new StringBuffer(5 * ba.length + 20);

        for (int i = 0; i < ba.length; ++i)
        {
            if (i % 16 == 0)
            {
                sb.append(Integer.toHexString((i & 0xFFFF) | 0x10000).substring(1, 5) + " - ");
            }
            sb.append(Integer.toHexString((ba[i] & 0xFF) | 0x100).substring(1, 3) + " ");
            if (i % 16 == 15 || i == ba.length - 1)
            {
                int j;
                for (j = 16 - i % 16; j > 1; --j)
                    sb.append("   ");
                sb.append(" - ");
                int start = (i / 16) * 16;
                int end = (ba.length < i + 1) ? ba.length : (i + 1);
                for (j = start; j < end; ++j)
                    if (ba[j] >= 32 && ba[j] <= 126)
                        sb.append((char)ba[j]);
                    else
                        sb.append(".");
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String printHex(String quelle)
    {
        return printHex(zuByteArrayMitIsoCodePage(quelle));
    }

    public static byte[] zuByteArrayMitIsoCodePage(String quelle)
    {
        try
        {
            return quelle.getBytes(JAVA_CODE_PAGE);
        }
        catch (UnsupportedEncodingException e)
        {
            return new byte[0];
        }
    }


}

