package tsStreamRipper.util;

/**
 * Auf Performance getrimmter String-Tokenizer.
 */
public class SimpleStringTokenizer
{
    private CharSequence currentString = null;
    private char currentDelim = ':';
    private int currentPos = 0;
    private int currentMaxLength = 0;
    private boolean moreTokens = true;

    public SimpleStringTokenizer(CharSequence currentString, char currentDelim)
    {
        super();
        this.currentDelim = currentDelim;
        this.currentString = currentString;
        postInit();
    }

    public void setCurrentDelim(char currentDelim)
    {
        this.currentDelim = currentDelim;
        postInit();
    }

    public void setCurrentString(CharSequence currentString)
    {
        this.currentString = currentString;
        postInit();
    }

    private void postInit()
    {
        currentPos = 0;
        if (currentString != null)
        {
            currentMaxLength = currentString.length();
            moreTokens = true;
        }
        else
        {
            currentMaxLength = 0;
            moreTokens = false;
        }
    }

    /**
     * Liefert das nächste Token.
     * 
     * Beim überlesen der Tokens wird ein Leerstring zurückgegeben: Wenn <code>hasMoreTokens</code> <code>false</code> liefert, dann liefert dernächste Aufruf von nextToken einen
     * Leerstring (<code>""</code>) zurück. <br>
     * Wenn der Tokenizer mit NULL initilisiert wird, dann liefert nextToken NULL zurück.
     * 
     * @return
     */
    public CharSequence nextToken()
    {
        if (currentString == null)
        {
            return null;
        }

        for (int i = currentPos; i < currentMaxLength; i++)
        {
            if (currentString.charAt(i) == currentDelim)
            {
                CharSequence result = currentString.subSequence(currentPos, i);
                if (i < currentMaxLength)
                {
                    currentPos = i + 1;
                }
                return result;
            }
        }
        moreTokens = false;
        int cp = currentPos;
        currentPos = currentMaxLength;
        return currentString.subSequence(cp, currentMaxLength);
    }

    public boolean hasMoreTokens()
    {
        return moreTokens;
    }

}
