package tsStreamRipper.util;

/**
 * "Unsigned" Zugriff auf ein Byte-Array
 */
public class UnsignedByteArray
{
    private byte[] ba = null;

    public UnsignedByteArray(){}
    
    public UnsignedByteArray(byte[] ba)
    {
        this.ba = ba;
    }

    public int valueAt(int i)
    {
        return (int) ba[i] & 0xFF;
    }

    public int length()
    {
        return ba.length;
    }

    public void setWrappedByteArray(byte[] ba)
    {
        this.ba = ba;
    }
    
    public byte[] getWrappedData()
    {
        return ba;
    }
}
