package tsStreamRipper.util.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

/**
 * Formatierte Logausgabe
 */
public class LogFormatter extends Formatter
{
    private SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    
    @Override
    public String format(LogRecord record)
    {
        return String.format("%s %8s %s\r\n",sdf.format(new Date()), record.getLevel().getName(), record.getMessage());
    }

}
