#!/bin/sh                                                                       
#    

MOUNTPOINT=/media/net/Linkstation  ## hier muss der mountpoint auf der Dreambox rein
SERVERSHARE=//192.168.0.5/freigabe ## hier dier Freigabe auf dem NAS
UN=username ## Benutzername
PW=passwort ## geheimes Passwort ;)

NOW=`date +%s`                                                                  

## berprfen ob die Box im Standby ist
if [ "$(cat /proc/stb/avs/0/input | grep encoder)" ]
then
  ## wenn nicht im Standby dann Magic Packet senden
  echo "Dreambox not in Standby! -> send WOL Package to NAS"
  python /usr/script/nas-wol.py 
 
  ## prfen ob die Freigabe gemountet ist
  if [ "$(df | grep $SERVERSHARE)" ];
  then
    ## wenn gemounted nichts tun
    echo "$MOUNTPOINT already mounted -> exit(0)"
    exit 0
  else
    ## wenn nicht mounten
    echo -n "$MOUNTPOINT not mounted -> trying to mount " 
     mount -t cifs $SERVERSHARE $MOUNTPOINT -o username=$UN,password=$PW,rw        
	## nochmal berprfen und ergebnis ausgeben
	if [ "$(df | grep $SERVERSHARE)" ]
	then
	  echo "-> success"
	  exit 0
	else
	  echo "-> failed"
	  exit 1
	fi
  fi
else    
  ## wenn im Standby
  echo "Dreambox is in Standby!"
  ## prfen ob die timers.xml leer ist (42 Bytes)
  if [ "$(ls -l /etc/enigma2/timers.xml | grep 42)" ]
  then
    ## wenn leer nichts tun
    echo "/etc/enigma2/timers.xml is empty -> exit(0)"
	exit 0
  else
    ## ansonsten  
    ## prfen ob timers.xml existiert
    if [ "$(ls /etc/enigma2 | grep timers.xml)" ]
    then
	  ## prfen ob in der TRESHOLD Zeit (600 = 10 min) ein Timer startet
      COUNT=0
      TIMER=/etc/enigma2/timers.xml                    
      THRESHOLD=900
      TIMERBEGINS=`grep begin $TIMER |sed 's/.*begin="//' | sed 's/".*//'`  
      echo "Check for upcoming timers..."    
      for START in $TIMERBEGINS                                                       
      do                                                                              
        echo -n "Timer: $START, "  
        # diff ist (timer start time - current time)                                                   
        DIFF=$(($START-$NOW))                                                         
        echo "Diff to now: $DIFF"             
        # wenn diff > 0 ist dann wurde der Timer noch nicht ausgefhrt
        if [ $DIFF -gt 0 ]                                                            
        then                                                                          
          echo "Timer is not processed yet."                                                    
          # wenn diff < $TRESHOLD ist startet der Timer bald
          if [ $DIFF -le $THRESHOLD ]                                                 
          then                                                                                 
            echo -n "Timer is starting soon -> wakeup Dreambox from Standby "  
            ## Dreambox aus dem Standby wecken                               
            wget -q -O- http://127.0.0.1/web/powerstate?newstate=0
			echo "-> send WOL to NAS"
			## Magic Packet an das NAS senden
			python /usr/script/nas-wol.py
          fi                                                                          
        else    
		  # ansonsten ausgefhrten Timer zhlen
          echo "Timer already processed."
          COUNT=$(( $COUNT + 1 ))          
        fi
      done
	  # prfen ob ausgefhrte Timer in der Liste sind 	 
      if [ $COUNT -gt 0 ]
      then
	    ## wenn ja dann aufrumen 
        echo "Timer cleanup..."
        wget -q -O- http://127.0.0.1/web/timercleanup?cleanup=true
        wget -q -O- http://127.0.0.1/web/timerlistwrite?write=true
      fi
    else	
	  echo "timers.xml does not exist."
	  exit 1
	fi
  fi
fi  

