# -*- coding: iso-8859-15-*-
# ClockToTextGer german version
# modded by hardy73 v2.0
from Converter import Converter
from time import localtime, strftime
from Components.Element import cached
from Components.config import config

class ClockToTextGer(Converter, object):
	DEFAULT = 0
	WITH_SECONDS = 1
	IN_MINUTES = 2
	DATE = 3
	FORMAT = 4
	AS_LENGTH = 5
	TIMESTAMP = 6
	
	# add: date, date as string, weekday, ... 
	# (whatever you need!)
	
	def __init__(self, type):
		Converter.__init__(self, type)
		if type == "WithSeconds":
			self.type = self.WITH_SECONDS
		elif type == "InMinutes":
			self.type = self.IN_MINUTES
		elif type == "Date":
			self.type = self.DATE
		elif type == "AsLength":
			self.type = self.AS_LENGTH
		elif type == "Timestamp":	
			self.type = self.TIMESTAMP
		elif str(type).find("Format") != -1:
			self.type = self.FORMAT
			self.fmt_string = type[7:]
		else:
			self.type = self.DEFAULT

	@cached
	def getText(self):
		time = self.source.time
		if time is None:
			return ""

		# handle durations
		if self.type == self.IN_MINUTES:
			return "%d min" % (time / 60)
		elif self.type == self.AS_LENGTH:
			return "%d:%02d" % (time / 60, time % 60)
		elif self.type == self.TIMESTAMP:
			return str(time)
		
		t = localtime(time)
		
		if self.type == self.WITH_SECONDS:
			return "%2d:%02d:%02d" % (t.tm_hour, t.tm_min, t.tm_sec)
		elif self.type == self.DEFAULT:
			return "%02d:%02d" % (t.tm_hour, t.tm_min)
		elif self.type == self.DATE:
			backstring = strftime("%A %B %d, %Y", t)
			if config.osd.language.value == "de_DE":
				backstring = backstring.replace('Monday', 'Montag')
				backstring = backstring.replace('Tuesday', 'Dienstag')
				backstring = backstring.replace('Wednesday', 'Mittwoch')
				backstring = backstring.replace('Thursday', 'Donnerstag')
				backstring = backstring.replace('Friday', 'Freitag')
				backstring = backstring.replace('Saturday', 'Samstag')
				backstring = backstring.replace('Sunday', 'Sonntag')
				backstring = backstring.replace('January', 'Januar')
				backstring = backstring.replace('February', 'Februar')
				backstring = backstring.replace('March', 'Mrz')
				backstring = backstring.replace('April', 'April')
				backstring = backstring.replace('May', 'Mai')
				backstring = backstring.replace('June', 'Juni')
				backstring = backstring.replace('July', 'Juli')
				backstring = backstring.replace('October', 'Oktober')
				backstring = backstring.replace('December', 'Dezember')
			return backstring
		elif self.type == self.FORMAT:
			spos = self.fmt_string.find('%')
			apos = self.fmt_string.find('%a')
			aapos = self.fmt_string.find('%A')
			bpos = self.fmt_string.find('%b')
			bbpos = self.fmt_string.find('%B')
			if spos > 0:
				s1 = self.fmt_string[:spos]
				s2 = strftime(self.fmt_string[spos:], t)
				backstring = str(s1+s2)
				if config.osd.language.value == "de_DE":
					if apos > -1:
						backstring = backstring.replace('Mon', 'Mo')
						backstring = backstring.replace('Tue', 'Di')
						backstring = backstring.replace('Wed', 'Mi')
						backstring = backstring.replace('Thu', 'Do')
						backstring = backstring.replace('Fri', 'Fr')
						backstring = backstring.replace('Sat', 'Sa')
						backstring = backstring.replace('Sun', 'So')
					if aapos > -1:
						backstring = backstring.replace('Monday', 'Montag')
						backstring = backstring.replace('Tuesday', 'Dienstag')
						backstring = backstring.replace('Wednesday', 'Mittwoch')
						backstring = backstring.replace('Thursday', 'Donnerstag')
						backstring = backstring.replace('Friday', 'Freitag')
						backstring = backstring.replace('Saturday', 'Samstag')
						backstring = backstring.replace('Sunday', 'Sonntag')
					if bpos > -1:
						backstring = backstring.replace('Mar', 'Mrz')
						backstring = backstring.replace('May', 'Mai')
						backstring = backstring.replace('June', 'Jun')
						backstring = backstring.replace('July', 'Jul')
						backstring = backstring.replace('Sept', 'Sep')
						backstring = backstring.replace('Oct', 'Okt')
						backstring = backstring.replace('Dec', 'Dez')
					if bbpos > -1:
						backstring = backstring.replace('January', 'Januar')
						backstring = backstring.replace('February', 'Februar')
						backstring = backstring.replace('March', 'Mrz')
						backstring = backstring.replace('April', 'April')
						backstring = backstring.replace('May', 'Mai')
						backstring = backstring.replace('June', 'Juni')
						backstring = backstring.replace('July', 'Juli')
						backstring = backstring.replace('October', 'Oktober')
						backstring = backstring.replace('December', 'Dezember')
				return backstring
			else:
				backstring = strftime(self.fmt_string, t)
				if config.osd.language.value == "de_DE":
					if apos > -1:
						backstring = backstring.replace('Mon', 'Mo')
						backstring = backstring.replace('Tue', 'Di')
						backstring = backstring.replace('Wed', 'Mi')
						backstring = backstring.replace('Thu', 'Do')
						backstring = backstring.replace('Fri', 'Fr')
						backstring = backstring.replace('Sat', 'Sa')
						backstring = backstring.replace('Sun', 'So')
					if aapos > -1:
						backstring = backstring.replace('Monday', 'Montag')
						backstring = backstring.replace('Tuesday', 'Dienstag')
						backstring = backstring.replace('Wednesday', 'Mittwoch')
						backstring = backstring.replace('Thursday', 'Donnerstag')
						backstring = backstring.replace('Friday', 'Freitag')
						backstring = backstring.replace('Saturday', 'Samstag')
						backstring = backstring.replace('Sunday', 'Sonntag')
					if bpos > -1:
						backstring = backstring.replace('Mar', 'Mrz')
						backstring = backstring.replace('May', 'Mai')
						backstring = backstring.replace('June', 'Jun')
						backstring = backstring.replace('July', 'Jul')
						backstring = backstring.replace('Sept', 'Sep')
						backstring = backstring.replace('Oct', 'Okt')
						backstring = backstring.replace('Dec', 'Dez')
					if bbpos > -1:
						backstring = backstring.replace('January', 'Januar')
						backstring = backstring.replace('February', 'Februar')
						backstring = backstring.replace('March', 'Mrz')
						backstring = backstring.replace('April', 'April')
						backstring = backstring.replace('May', 'Mai')
						backstring = backstring.replace('June', 'Juni')
						backstring = backstring.replace('July', 'Juli')
						backstring = backstring.replace('October', 'Oktober')
						backstring = backstring.replace('December', 'Dezember')
				return backstring
		else:
			return "???"

	text = property(getText)
