#-*- coding: utf-8 -*-
import sys, urllib, re, shutil, os, datetime, time
import socket
import ssl
from urllib2 import Request, urlopen, URLError
from SkySql import *
from SkyMainFunctions import *

from StringIO import StringIO
USE_GZIP = True
try:
	import gzip
except Exception:
	sys.exc_clear()
	USE_GZIP = False

class SkyTheMovieDB(object):
	
	def __init__(self,timeout=10):
		self.alternate_lang = "en"
		self.timeout = timeout
		self.sky_log_path = "/usr/lib/enigma2/python/Plugins/Extensions/skyrecorder/sky_log"
		if USE_GZIP:
			self.headers1 = {
			'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:19.0) Gecko/20100101 Firefox/19.0',
			'Accept-Charset': 'ISO-8859-1,utf-8;q=0.7,*;q=0.7',
			'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
			'Cache-Control': 'max-age=3',
			'Accept-Encoding': 'gzip, deflate',
			'Accept-Language': 'de-de,de;q=0.8,en-us;q=0.5,en;q=0.3'}
		else:
			self.headers1 = {
			'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:19.0) Gecko/20100101 Firefox/19.0',
			'Accept-Charset': 'ISO-8859-1,utf-8;q=0.7,*;q=0.7',
			'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
			'Cache-Control': 'max-age=3',
			'Accept-Language': 'de-de,de;q=0.8,en-us;q=0.5,en;q=0.3'}
		self.headers2 = getHttpHeader2()
	
	def cleanName(self,text):
		#text1 = text.decode("iso-8859-1")
		#text = text1.encode("utf-8")
		text = text.replace('&amp;','&')
		text = text.replace('/','')
		text = text.replace(':','_') # for enigma2 getRecordingFilename
		text = text.replace('–','-')
		# finally kill the rest
		text = re.sub('-+',"-",text)
		return text
	
	def prepareSearchString(self,text):
		#text1 = text.decode("iso-8859-1")
		#text = text1.encode("utf-8")
		
		# FIXME: some hacks
		text = re.sub("[Mm]arvel's ","",text)
		text = re.sub("[?]","",text)
		text = urllib.quote_plus(text)
		return text
		
		text = text.replace('&auml;','ae').replace('&Auml;','Ae').replace('&ouml;','oe').replace('&ouml;','Oe').replace('&uuml;','ue')
		text = text.replace('&Uuml;','Ue').replace('&szlig;','ss').replace('&amp;','&').replace('&quot;','\"').replace('&gt;','\'')
		text = text.replace('&#228;','ae').replace('&#246;','oe').replace('&#252;','ue').replace('&#223;','ss').replace('&#8230;','...')
		text = text.replace('\u00c4','Ae').replace('\u00e4;',"ae").replace('\u00d6',"Oe").replace('\u00f6','oe')
		text = text.replace('\u00dc','Ue').replace('\u00fc',"ue").replace('\u00df',"ss")
		text = text.replace('&#196;','Ae').replace('&#228;',"ae").replace('&#214;',"Oe").replace('&#246;',"oe").replace('&#220;',"Ue").replace('&#252;',"ue")
		text = text.replace('ö','oe').replace('ü','ue').replace('ä','ae').replace('Ã','ss')
		text = text.replace('Ö','Oe').replace('Ü','Ue').replace('Ä','Ae')
		text = text.replace('–','-')
		text = text.replace('/','-')
		text = text.replace(' ','-')
		# finally kill the rest
		text = re.sub("[^a-zA-Z0-9-]","",text)
		text = re.sub('-+',"-",text)
		return text
	
	
	def getListFor(self,searchStr,split=False,language="de"):
		if not searchStr or len(searchStr) < 1:
			return False
		
		if split:
			searchStr = searchStr.split("-")[0].strip()
			#searchStr = searchStr.split(":")[0].strip()
		
		searchstring = self.prepareSearchString(searchStr)
		url = "http://www.themoviedb.org/search/movie?query={0}&language={1}".format(searchstring,language)

		data = None
		socket.setdefaulttimeout(self.timeout)
		req = Request(url,None,self.headers1)
		ctx = ssl.create_default_context()
		ctx.check_hostname = False
		ctx.verify_mode = ssl.CERT_NONE
		try:
			response = urlopen(req, context=ctx)
			url = response.geturl()
			print url
			req = Request(url,None,self.headers1)
			response = urlopen(req, context=ctx)
		except URLError as e:
			if hasattr(e, 'reason'):
				print 'We failed to reach a server.'
				print 'Reason: ', e.reason
			elif hasattr(e, 'code'):
				print 'The server couldn\'t fulfill the request.'
				print 'Error code: ', e.code
			return False
		else:
			# everything is fine?
			try:
				if USE_GZIP:
					if response.info().get('Content-Encoding') == 'gzip':
					    buf = StringIO(response.read())
					    f = gzip.GzipFile(fileobj=buf)
					    data = f.read()
				else:
					data = response.read()
			except Exception:
				return False
		
		if not data or len(data) < 1:
			print "nothing found"
			return False
		
		# store our results
		resultList = None
		resultList = []
		
		m_base = re.findall('<div class="results">(.*?)<script>', data, re.I|re.S)
		try:
			#m_list_raw = str(m_base[0]).replace("</li>", "").split("<li>")
			m_list_raw = str(m_base[0]).split("<div class=\"item poster card\">")
		except Exception:
			return False
		
		for m_result in m_list_raw:
			
			res = re.findall('<div class="image_content">.*?<a .*? href=".*? title="(.*?)".*?>.*?<img.*?src="(.*?)".*?>.*?</a>.*?</div>', m_result, re.I|re.S)
			if not res:
				continue
			m_poster_url = str(res[0][1])
			
			m_title_org = str(res[0][0])
			
			res = re.findall('<div class="info">.*?<a.*? href="(.*?)\?.*?>(.*?)</a>.*?<span class="release_date">.\d+.\d+.(.*?)?<span class="glyphicons glyphicons-calendar x1">', m_result, re.I|re.S)
			if not res:
				continue
			
			m_movie_url = "http://www.themoviedb.org{0}".format(res[0][0])
			m_title = str(res[0][1])
			m_date = str(res[0][2])
			
			try:
				m_id_movie = re.search("/.*?/([0-9]+)",m_movie_url).group(1)
			except Exception:
				m_id_movie = 0
			
			resultList.append({
								"m_movie_url":m_movie_url,
								"m_title_org":m_title_org,
								"m_title":m_title,
								"m_poster_url":m_poster_url,
								"m_date":m_date,
								"m_id_movie":m_id_movie
							})
		# return resultlist
		return resultList
		
	
	def getInfoFor(self,movieURL="",movieTitle="",idMovie="",language="de",lastlang=-1):
		lang = ('de','en','es','fr')
		max_lang = len(lang) - 1
		if movieURL and len(movieURL) > 1:
			# default
			if lastlang and int(lastlang) > -1 and int(lastlang) in range(0,max_lang+1):
				language = lang[lastlang]
			if not language or language not in lang:
				language = "de"
			url = "{0}?language={1}".format(movieURL,language)
			
			lastlang = lang.index(language)
			print url
		else:
			return False
		
		data = None
		socket.setdefaulttimeout(self.timeout)
		req = Request(url,None,self.headers1)
		ctx = ssl.create_default_context()
		ctx.check_hostname = False
		ctx.verify_mode = ssl.CERT_NONE
		try:
			response = urlopen(req, context=ctx)
		except URLError as e:
			if hasattr(e, 'reason'):
				print 'We failed to reach a server.'
				print 'Reason: ', e.reason
			elif hasattr(e, 'code'):
				print 'The server couldn\'t fulfill the request.'
				print 'Error code: ', e.code
			return False
		else:
			# everything is fine?
			try:
				if USE_GZIP:
					if response.info().get('Content-Encoding') == 'gzip':
					    buf = StringIO(response.read())
					    f = gzip.GzipFile(fileobj=buf)
					    data = f.read()
				else:
					data = response.read()
			except Exception:
				return False
		
		if not data or len(data) < 1:
			print "nothing found"
			#lastlang += 1
			#if lastlang > max_lang:
			#	return False
			#else:
			#	print "next language {0}".format(lang[lastlang])
			#	self.getInfoFor(movieURL=movieURL,movieTitle="",idMovie="",language="de",lastlang=lastlang)
			return False
		
				
		resultList = None
		resultList = []
		
		#res = re.findall('<div id="mainCol">.*?<div class="title">.*?<h2 id="title">.*?<span itemprop="name">(.*?)</span></a></h2>.*?<h3 id="year">\((.*?)\)</h3>.*?</div>', data, re.I|re.S)
		res = re.findall('<h2.*?>.*?<a href="/movie/.*?">(.*?) <span class="release_date">\((.*?)\)</span></a>', data, re.I|re.S)
		if not res:
			return False
		
		m_name = str(res[0][0])			
		m_year = str(res[0][1])
		
		res = re.findall('<span class="rating">(.*?)</span>', data, re.I|re.S)
		#res = re.findall('<div.*?"rating">.*?<span.*?itemprop="ratingValue".*?>(.*?)</span>', data, re.I|re.S)
		if not res:
			m_rating = 0
		else:
			m_rating = str(res[0])
			
		res = re.findall('<div class="overview".*?>.*?<p>(.*?)</p>', data, re.I|re.S)
		#res = re.findall('<p id="overview" itemprop="description">(.*?)</p>', data, re.I|re.S)
		if not res:
			m_description = ""
		else:
			m_description = str(res[0])
		
		res = re.findall('<p class="wrap"><strong>Originaltitel</strong> (.*?)</p>', data, re.I|re.S)
		if not res:
			m_title_org = ""
		else:
			m_title_org = str(res[0])
		
		
		res = re.findall('<div class="image_content">.*?<img class="poster lazyload fade" data-sizes="auto" data-src="(.*?)"', data, re.I|re.S)
		#res = re.findall('<meta property="og:image" content="(.*?)" />', data, re.I)
		if not res:
			m_posters = []
		else:
			m_posters = list(res)
		
		if not idMovie or idMovie == "":
			try:
				m_id_movie = re.search("/.*?/([0-9]+)",movieURL).group(1)
			except Exception:
				m_id_movie = 0
		else:
			m_id_movie = idMovie
		
		m_genre = []
		res = re.findall('<section class="genres right_column">.*?<h4>.*?Genre.*?</h4>.*?<ul>(.*?)</ul>', data, re.I|re.S)
		#res = re.findall('<span id="genres">.*?<ul.*?>(.*?)<div.*?></div>.*?</ul>.*?</span>', data, re.I|re.S)
		if res:
			res_2 = re.findall('<li><a class="rounded".*?>(.*?)</a></li>', str(res), re.I)
			#res_2 = re.findall('<li><a href=".*?" alt=".*?"><span itemprop="genre">(.*?)</span></a></li>', str(res), re.I)
			for li_res in res_2:
				m_genre.append(str(li_res))
				
		resultList.append({
							"m_name":m_name,
							"m_year":m_year,
							"m_title_org":m_title_org,
							"m_rating":m_rating,
							"m_description":m_description,
							"m_posters":m_posters,
							"m_id_movie":m_id_movie,
							"m_genre":m_genre
						})
							
		# return result
		return resultList

	def RunAutoloadInfosTMDB(self):
		movies = sql.getEventsMainAutoCheck(order="ASC")
		if len(movies) > 0:
			for movie in movies:
				# get TMDB infos if no infos in database
				if int(movie[14]) == 0:
					id_events = int(movie[0])
					title = str(movie[1])

					self.getMovieInfoAutocheck(searchStr=title, id_events=id_events)
			
	def getMovieInfoAutocheck(self,searchStr,split=False,language="de",id_events=0):
		try:
			res = self.getListFor(searchStr=searchStr,split=False,language=language)
			if not res or len(res) < 1:
				res = self.getListFor(searchStr=searchStr.split("-")[0].strip(),split=False,language=language)
				if not res or len(res) < 1:
					res = self.getListFor(searchStr=searchStr.split(":")[0].strip(),split=False,language=language)
					if not res or len(res) < 1:
						res = self.getListFor(searchStr=searchStr.split("...")[0].strip(),split=False,language=language)
						if not res or len(res) < 1:
							# ok, we give up
							#self.session.open(MessageBox, "Keine Info gefunden für:\n{0}".format(title), MessageBox.TYPE_INFO, timeout=-1)
							#return
							res = []
		except Exception:
			sys.exc_clear()
			res = []
		# go through filmlist and get entry with newest date
		movieUrl = None
		posterUrl = None
		movieTitle = None
		movieDate = 0

		for t_row in res:
			if int(t_row["m_date"]) > movieDate:
				movieUrl = str(t_row["m_movie_url"])
				movieTitle = str(t_row["m_title"])
				movieDate = int(t_row["m_date"])
				posterUrl = str(t_row["m_poster_url"])

		self.getMovieInfoToDatabase(movieURL=movieUrl, movieTitle=movieTitle, posterUrl=posterUrl, id_events=id_events, sky_title=searchStr)

	def getMovieInfoToDatabase(self,movieURL=None,movieTitle="",posterUrl="",id_events=0,sky_title=""):
		if not movieURL:
			return
		movieinfo = None
		movieinfo = self.getInfoFor(movieURL=movieURL,movieTitle=movieTitle,idMovie="",language="de",lastlang=-1)
		if not movieinfo or len(movieinfo) < 1:
			# fallback language english
			movieinfo = self.getInfoFor(movieURL=movieURL,movieTitle=movieTitle,idMovie="",language="en",lastlang=-1)
			if not movieinfo or len(movieinfo) < 1:
				self.addLog("Keine Info für:\n{0}".format(str(movieURL)))
				return False
			
		if len(movieinfo[0]['m_name']) > 0:
			m_name = str(movieinfo[0]['m_name'])
		else:
			m_name = None
			
		if len(movieinfo[0]['m_id_movie']) > 0:
			m_id_movie = int(movieinfo[0]['m_id_movie'])
		else:
			m_id_movie = None
			
		if len(movieinfo[0]['m_title_org']) > 0:
			m_title_org = str(movieinfo[0]['m_title_org'])
		else:
			m_title_org = ""
		
		if len(movieinfo[0]['m_year']) > 0:
			m_year = str(movieinfo[0]['m_year'])
		else:
			m_year = ""
		
		if len(movieinfo[0]['m_description']) > 0:
			m_description = str(movieinfo[0]['m_description'])
		else:
			m_description = ""
			
		if len(movieinfo[0]['m_genre']) > 0:
			m_genre = movieinfo[0]['m_genre']
		else:
			m_genre = []
		
		if movieinfo[0]['m_rating']:
			m_rating = str(movieinfo[0]['m_rating'])
		else:
			m_rating = "0"
			
		# got movieinfo, store it
		res = sql.addNewMovieInfo(id_events, m_id_movie, m_name, m_year, m_title_org, m_rating, m_description, m_genre,sky_title)
		
		if not res:
			return
		
		# update cover in database
		if posterUrl and posterUrl != "":
			coverurl = posterUrl
		else:
			if len(movieinfo[0]['m_posters']) > 0:
				coverurl = movieinfo[0]['m_posters'][0]
		
		if coverurl and coverurl != "":
			data = None
			socket.setdefaulttimeout(10)
			req = Request(coverurl,None,self.headers2)
			ctx = ssl.create_default_context()
			ctx.check_hostname = False
			ctx.verify_mode = ssl.CERT_NONE
			response = urlopen(req, context=ctx)
			data = response.read()
			self.gotPoster(data,id_events, m_id_movie, coverurl)

		self.addLog("Info hinzugefügt für:\n{0}".format(str(movieTitle)))
		
	def gotPoster(self, data, id_events, m_id_movie, coverurl):
		if data:
			time.sleep(0.123)
			sql.addMovieInfoPoster(id_events, m_id_movie, coverurl, data)

	def addLog(self, text):
		if len(text) < 1:
			return
		# check the current file size truncate the file if size is greater than defined limit 200 KB (204800 Bytes)
		sizeb = os.path.getsize(self.sky_log_path)
		if sizeb > 204800:
			# truncate only the first 100 lines in file - delete the oldest ones
			with open(self.sky_log_path, "r+") as f:
				for x in xrange(100):
					f.readline()
					f.truncate()

		lt = time.localtime()
		datum = time.strftime("%d.%m.%Y - %H:%M:%S", lt)
		with open(self.sky_log_path , "a") as write_log:
			write_log.write('"%s - %s"\n' % (datum,text))
