#-*- coding: utf-8 -*-
def buildSkydb(target=None,rebuild=False,backup=True):
	
	import os
	import sys
	import sqlite3
	import datetime
	import time
	
	databaseName = 'skydb.db'
	debugprefix = '[SkyRecorder]'
	
	if not target:
		my_path = os.path.dirname(os.path.abspath(__file__)) + '/'
		my_anytime_path=os.path.dirname(os.path.abspath(my_path)) + '/skyrecorder/'
		my_db_path = my_anytime_path + 'skydb.db'
	else:
		if os.path.isdir(target):
			if target[-1:] != "/":
				target += "/"
			my_db_path = target + databaseName
		elif not os.path.isdir(target) and os.path.exists(target):
			my_path = os.path.dirname(os.path.abspath(target)) + '/'
			my_db_path = my_path + databaseName
		elif not os.path.exists(target) and not os.path.isdir(target):
			my_db_path = target
			
	print my_db_path


	if os.path.exists(my_db_path) and backup is True:
		now = datetime.datetime.now()
		now = int(time.mktime(now.timetuple()))
		skydb_backupfile = my_db_path + "_bak_" + str(now)
		
		print "{0} erstelle Backup in '{1}'".format(debugprefix,skydb_backupfile)
		
		# build backup file by renaming the old one
		try:
			os.rename(my_db_path, skydb_backupfile)
		except Exception:
			sys.exc_clear()
			print "{0} ERROR: could not create backup file '{1}'. Is the file in use?".format(debugprefix,skydb_backupfile)
			return False
	
	if os.path.exists(my_db_path) and rebuild is False:
		print "{0} Datenbankdatei '{1}' existiert schon".format(debugprefix,my_db_path)
		return False
	
	if os.path.exists(my_db_path) and rebuild is True:
		try:
			os.remove(my_db_path)
		except Exception:
			sys.exc_clear()
			return False
	
	print "{0} skydb databasefile '{1}'".format(debugprefix,my_db_path)
	print "{0} building database".format(debugprefix)
		
	connection=sqlite3.connect(my_db_path)
	connection.text_factory = str #we need to make use of utf-8 encoding for the database connection. Otherwise unicode would be the default
	curser=connection.cursor()

	print "{0} creating table: added".format(debugprefix)
	curser.execute("""CREATE TABLE [added] (
		[id_added] INTEGER  NOT NULL PRIMARY KEY,
		[title] TEXT  NULL,
		[description] TEXT  NULL,
		[id_channel] INTEGER  NULL,
		[id_genre] INTEGER  NULL,
		[begin] INTEGER  NULL,
		[end] INTEGER  NULL,
		[serviceref] TEXT  NULL,
		[location] TEXT  NULL,
		[recordedfile] TEXT  NULL,
		[eit] INTEGER NULL,
		[id_eventslist] INTEGER NULL
	)""")

	print "{0} creating table: channel".format(debugprefix)
	curser.execute("""CREATE TABLE [channel] (
		[id_channel] INTEGER  NULL PRIMARY KEY,
		[channel] TEXT  NULL,
		[channel_stb] TEXT  NULL,
		[status] TEXT  NULL,
		[position] INTEGER  NULL,
		[channel_id_sky] INTEGER  NULL
	)""")
	
	print "{0} creating table: skip".format(debugprefix)
	curser.execute("""CREATE TABLE [skip] (
		[id_skip] INTEGER  NULL PRIMARY KEY,
		[skipword] TEXT  NULL,
		[status] TEXT  NULL
	)""")
	
	print "{0} creating table: whitelist".format(debugprefix)
	curser.execute("""CREATE TABLE [whitelist] (
		[id_whitelist] INTEGER  NULL PRIMARY KEY,
		[id_channel] TEXT  NULL,
		[title] TEXT  NULL,
		[description] TEXT  NULL,
		[status] TEXT  NULL
	)""")

	print "{0} creating table: groups".format(debugprefix)
	curser.execute("""CREATE TABLE [groups] (
		[id_groups] INTEGER  PRIMARY KEY NOT NULL,
		[groupname] TEXT  NULL,
		[status] TEXT  NULL,
		[position] INTEGER  NULL
	)""")

	print "{0} creating table: genre".format(debugprefix)
	curser.execute("""CREATE TABLE [genre] (
		[id_genre] INTEGER  NOT NULL PRIMARY KEY,
		[genre] TEXT  NULL,
		[status] TEXT  NULL,
		[position] INTEGER  NULL
	)""")

	print "{0} creating table: genregroup".format(debugprefix)
	curser.execute("""CREATE TABLE [genregroup] (
		[id_genregroup] INTEGER  NOT NULL PRIMARY KEY,
		[id_genre] INTEGER  NULL,
		[id_groups] INTEGER  NULL,
		FOREIGN KEY(id_genre) REFERENCES genre(id_genre),
		FOREIGN KEY(id_groups) REFERENCES groups(id_groups)
	)""")

	print "{0} creating table: events".format(debugprefix)
	curser.execute("""CREATE TABLE [events] (
		[id_events] INTEGER  PRIMARY KEY NULL,
		[title] TEXT  NULL,
		[description] TEXT  NULL,
		[sky_id] TEXT  NULL,
		[image] TEXT  NULL,
		[id_channel] INTEGER  NULL,
		[id_genre] INTEGER  NULL,
		[status] TEXT  NULL,
		FOREIGN KEY(id_channel) REFERENCES channel(id_channel),
		FOREIGN KEY(id_genre) REFERENCES genre(id_genre)
	)""")

	print "{0} creating table: eventslist".format(debugprefix)
	curser.execute("""CREATE TABLE [eventslist] (
		[id_eventslist] INTEGER  NOT NULL PRIMARY KEY,
		[dayname] TEXT  NULL,
		[datum] TEXT  NULL,
		[starttime] INTEGER  NULL,
		[endtime] INTEGER  NULL,
		[status] TEXT  NULL,
		[id_events] INTEGER  NULL,
		FOREIGN KEY(id_events) REFERENCES events(id_events)
	)""")

	print "{0} creating table: eventdetails".format(debugprefix)
	curser.execute("""CREATE TABLE [eventdetails] (
		[id_eventdetails] INTEGER  PRIMARY KEY NOT NULL,
		[id_events] INTEGER  NULL,
		[handlung] TEXT  NULL,
		[is_hd] INTEGER NULL,
		[is_169] INTEGER NULL,
		[is_dolby] INTEGER NULL,
		[is_dualch] INTEGER NULL,
		[highlight] INTEGER NULL,
		[live] INTEGER NULL,
		[is_last] INTEGER NULL,
		[is_3d] INTEGER NULL,
		[is_ut] INTEGER NULL,
		[is_new] INTEGER NULL,
		[country] TEXT  NULL,
		[year] TEXT NULL,
		FOREIGN KEY(id_events) REFERENCES events(id_events)
	)""")
	
	print "{0} creating table: eventcover".format(debugprefix)
	curser.execute("""CREATE TABLE [eventcover] (
		[id_eventcover] INTEGER  PRIMARY KEY NOT NULL,
		[id_events] INTEGER  NULL,
		[cover] BLOB  NULL,
		FOREIGN KEY(id_events) REFERENCES events(id_events)
	)""")
	
	
	print "{0} creating table: themoviedb".format(debugprefix)
	curser.execute("""CREATE TABLE [themoviedb] (
		[id_themoviedb] INTEGER  PRIMARY KEY NOT NULL,
		[id_events] INTEGER  NULL,
		[m_id_movie] INTEGER  NULL,
		[m_name] TEXT  NULL,
		[m_year] TEXT  NULL,
		[m_title_org] TEXT  NULL,
		[m_rating] TEXT  NULL,
		[m_description] TEXT  NULL,
		[m_genre] TEXT  NULL,
		[sky_title] TEXT  NULL,
		[is_active] INTEGER  NULL
	)""")
	
	
	print "{0} creating table: posters".format(debugprefix)
	curser.execute("""CREATE TABLE [posters] (
		[id_posters] INTEGER  PRIMARY KEY NOT NULL,
		[id_events] INTEGER  NULL,
		[m_id_movie] INTEGER  NULL,
		[poster_url] TEXT  NULL,
		[poster] BLOB  NULL
	)""")
	
	
	### Tigger
	print "{0} creating trigger".format(debugprefix)
	curser.execute("""CREATE TRIGGER update_events_status AFTER UPDATE ON eventslist 
		BEGIN
			UPDATE events SET status = new.status WHERE id_events == new.id_events;
  		END""")

	
	print "{0} inserting default genrelist".format(debugprefix)
	genreset = (
		(1,'Anwaltsserie','True'),(2,'Serie','True'),(3,'Miniserie','True'),(4,'Mystery-Serie','True'),(5,'Real-Life-Show','False'),
		(6,'Agentenserie','True'),(7,'Dramaserie','True'),(8,'Drama','True'),(9,'Action','True'),(10,'Dokumentarserie','True'),
		(11,'Dokumentation','True'),(12,'Komödie','True'),(13,'Tierdokumentation','True'),(14,'Horrorfilm','True'),
		(15,'Horrorserie','True'),(16,'Actionfilm','True'),(17,'Mysteryfilm','True'),(18,'Mysterythriller','True'),
		(19,'Animation','True'),(20,'Thriller','True'),(21,'Western','True'),(22,'Kriminalfilm','True'),(23,'Krimiserie','True'),
		(24,'Abenteuerfilm','True'),(25,'Science-Fiction','True'),(26,'Liebesfilm','True'),(27,'Zeichentrick','True'),
		(28,'Zeichentrickserie','True'),(29,'Politthriller','True'),(30,'Jugendfilm','True'),(31,'Fantasy-Action','True'),
		(32,'Monumentalfilm','True'),(33,'Animationsfilm','True'),(34,'Psychothriller','True'),(35,'Fantasy','True'),
		(36,'Liebeskomödie','True'),(37,'Horrorkomödie','True'),(38,'Actionthriller','True'),(39,'Biografie','True'),
		(40,'Romantikkomödie','True'),(41,'Actionkomödie','True'),(42,'Kriegsfilm','True'),(43,'Literaturverfilmung','True'),
		(44,'Computeranimation','True'),(45,'Show','True'),(46,'Sportlerdrama','True'),(47,'Talk','False'),(48,'Talkshow','False'),
		(49,'-','True'),(50,'Comic','True'),(51,'Science-Fiction-Horror','True'),(52,'Sitcom','True'),
		(53,'Spielfilm','True'),(54,'Kinderfilm','True'),
		(55,'Magazin','False'),(56,'Zeichentrick/Animation','True'),
		(57,'Familienfilm','True'),(58,'Dokumentarfilm','True'),(59,'Milieustudie','True'),
		(60,'Romanze','True'),(61,'Wrestling','False'),(62,'Erotikfilm','True'),
		(63,'Zeichentrick/Puppen/Animation','True'),
		(64,'Melodram','True'),(65,'Kinder-/Jugendprogramm (allgemein)','True'),
		(66,'Heimatfilm','True'),(67,'Kinder 10-16','True'),
		(68,'Musik/Ballett/Tanz (allgemein)','True')
	)
	curser.executemany("INSERT INTO genre (id_genre,genre,status) values (?,?,?)", genreset)

	print "{0} inserting default groups".format(debugprefix)
	groupset = (
		(1,'Film','True',1),
		(2,'Serie','True',2),
		(3,'Dokumentation','True',3),
		(4,'Sport','True',4),
		(5,'Sonstige','True',5),
		(6,'Sky Select','False',6)
	)
	curser.executemany("INSERT INTO groups (id_groups,groupname,status,position) values (?,?,?,?)", groupset)
	
	print "{0} inserting default genre-group-list".format(debugprefix)
	genregroupset = (
		(1,2),(2,2),(3,2),(4,2),(5,5),(6,2),(7,2),(8,1),(9,1),(10,2),
		(11,3),(12,1),(13,3),(14,1),(15,2),(16,1),(17,1),(18,1),(19,5),(20,1),
		(21,1),(22,1),(23,2),(24,1),(25,1),(26,1),(27,5),(28,2),(29,1),(30,1),
		(31,1),(32,1),(33,1),(34,1),(35,1),(36,1),(37,1),(38,1),(39,5),(40,1),
		(41,1),(42,1),(43,1),(44,5),(45,5),(46,1),(47,5),(48,5),(49,5),(50,5),
		(51,1),(52,5),(53,1),(54,1),(55,5),(56,1),(57,1),(58,3),(59,1),(60,1),
		(61,4),(62,1),
		(63,1),(64,1),(65,5),
		(66,1),(67,5)
	)
	curser.executemany("INSERT OR IGNORE INTO genregroup (id_genre,id_groups) values (?,?)", genregroupset)
	
	try:
		connection.commit()
	except Exception:
		sys.exc_clear()
		print "{0} ERROR: could not commit changes".format(debugprefix)
		connection.close()
		return False
		
	connection.close()
	print "{0} done".format(debugprefix)
	return True

# start here
#buildSkydb(rebuild=True,backup=True)

