#-*- coding: utf-8 -*-
from StringIO import StringIO
import gzip
import sys, urllib, re, shutil
import socket
from urllib2 import Request, urlopen, URLError

class SkyFernsehserien_de(object):
	
	def __init__(self,timeout=10):
		self.alternate_lang = "en"
		self.timeout = timeout
		self.headers1 = {
		'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:19.0) Gecko/20100101 Firefox/19.0',
		'Accept-Charset': 'ISO-8859-1,utf-8;q=0.7,*;q=0.7',
		'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
		'Cache-Control': 'max-age=3',
		'Accept-Encoding': 'gzip, deflate',
		'Accept-Language': 'de-de,de;q=0.8,en-us;q=0.5,en;q=0.3'}
	
	def cleanName(self,text):
		#text1 = text.decode("iso-8859-1")
		#text = text1.encode("utf-8")
		text = text.replace('&amp;','&')
		text = text.replace('/','')
		text = text.replace(':','-')
		text = text.replace('–','-')
		# finally kill the rest
		text = re.sub('-+',"-",text)
		return text
	
	def prepareSearchString(self,text):
		#text1 = text.decode("iso-8859-1")
		#text = text1.encode("utf-8")
		text = text.replace('&auml;','ae').replace('&Auml;','Ae').replace('&ouml;','oe').replace('&ouml;','Oe').replace('&uuml;','ue')
		text = text.replace('&Uuml;','Ue').replace('&szlig;','ss').replace('&amp;','&').replace('&quot;','\"').replace('&gt;','\'')
		text = text.replace('&#228;','ae').replace('&#246;','oe').replace('&#252;','ue').replace('&#223;','ss').replace('&#8230;','...')
		text = text.replace('\u00c4','Ae').replace('\u00e4;',"ae").replace('\u00d6',"Oe").replace('\u00f6','oe')
		text = text.replace('\u00dc','Ue').replace('\u00fc',"ue").replace('\u00df',"ss")
		text = text.replace('&#196;','Ae').replace('&#228;',"ae").replace('&#214;',"Oe").replace('&#246;',"oe").replace('&#220;',"Ue").replace('&#252;',"ue")
		text = text.replace('ö','oe').replace('ü','ue').replace('ä','ae').replace('Ã','ss')
		text = text.replace('Ö','Oe').replace('Ü','Ue').replace('Ä','Ae')
		text = text.replace('–','-')
		text = text.replace('/','-')
		text = text.replace(' ','-')
		# finally kill the rest
		text = re.sub("[^a-zA-Z0-9-]","",text)
		text = re.sub('-+',"-",text)
		return text
	
	
	def getListFor(self,searchStr):
		if not searchStr or len(searchStr) < 1:
			return False
		
		searchstring = self.prepareSearchString(searchStr)
		url = "http://www.fernsehserien.de/suche/{0}".format(searchstring)
		print url
		data = None
		socket.setdefaulttimeout(self.timeout)
		req = Request(url,None,self.headers1)
		try:
			response = urlopen(req)
			url = response.geturl()
			print url
			req = Request(url,None,self.headers1)
			response = urlopen(req)
		except URLError as e:
			if hasattr(e, 'reason'):
				print 'We failed to reach a server.'
				print 'Reason: ', e.reason
			elif hasattr(e, 'code'):
				print 'The server couldn\'t fulfill the request.'
				print 'Error code: ', e.code
			return False
		else:
			# everything is fine?
			try:
				if response.info().get('Content-Encoding') == 'gzip':
				    buf = StringIO( response.read())
				    f = gzip.GzipFile(fileobj=buf)
				    data = f.read()
			except Exception:
				return False
		
		if not data or len(data) < 1:
			print "nothing found"
			return False
		print "ooooook"
		# store our results
		resultList = None
		resultList = []
		
		single_match = False
		s_list_raw = re.findall('<meta name="title" content="(.*?)">', data, re.I)
		s_title = searchStr
		if s_list_raw and len(s_list_raw) > 0:
			s_title = str(s_list_raw[0])
		
		try:
			s_list_raw = re.findall('<div.*?class="fs-btn-container"><a class="fs-btn" href="(.*?)/episodenguide">.*?mit allen Folgen</a></div>', data, re.I|re.S)
		except Exception:
			return False
		#return s_list_raw
		
		if s_list_raw and len(s_list_raw) > 0:
			s_url_name = str(s_list_raw[0])
			s_url = "http://www.fernsehserien.de/{0}/episodenguide".format(s_url_name).lower()
			single_match = True
		
		# return here, if we have a single-match
		if single_match:
			resultList.append({"s_url":s_url,"s_url_name":s_url_name,"s_title":s_title,"s_subtitle":"","s_date":"","s_org":""})
			return resultList
		
		# problem: wannwo
		try:
			s_list_raw = re.findall('<li class="suchergebnis.*?>(.*?)</li>', data, re.I)
		except Exception:
			return False
		
		#s_url_name,s_title,s_date_org
		for s_result in s_list_raw:
			#print s_result
			#return
			s_url_name = re.findall('<a class=".*?" href="(.*?)"', s_result, re.I)
			if not s_url_name:
				continue
			s_url_name = str(s_url_name[0])
			if re.match('.*\/.*', s_url_name, re.I):
				continue
			s_url = "http://www.fernsehserien.de/{0}/episodenguide".format(s_url_name).lower()
			
			#<span class="suchergebnis-wannwo">GB 1973 (<span lang="en">Thursday’s Child</span>)</span>
			s_date = re.findall('<span class="suchergebnis-wannwo">(.*?)[\s]\(.*?\)</span>', s_result, re.I)
			if not s_date:
				s_date = re.findall('<span class="suchergebnis-wannwo">(.*?)</span>', s_result, re.I)
				if not s_date:
					s_date = ""
				else:
					s_date = str(s_date[0])
			else:
				s_date = str(s_date[0])
			
			s_org = re.findall('<span class="suchergebnis-wannwo">.*?\(<span lang=".*?">(.*?)</span>\)</span>', s_result, re.I)
			if not s_org:
				s_org = ""
			else:
				s_org = str(s_org[0])
			
			
			s_title = re.findall('<span class="suchergebnis-titel">(.*?)</span>', s_result, re.I)
			if not s_title:
				continue
			s_title = str(s_title[0])
				
			s_subtitle = re.findall('<span class="suchergebnis-untertitel">(.*?)</span>', s_result, re.I)
			if not s_subtitle:
				s_subtitle = ""
			else:
				s_subtitle = str(s_subtitle[0])
			
			resultList.append({
								"s_url":s_url,
								"s_url_name":s_url_name,
								"s_title":self.cleanName(s_title),
								"s_subtitle":self.cleanName(s_subtitle),
								"s_date":s_date,
								"s_org":s_org
							})
		# return resultlist
		return resultList
	
	def getInfoFor(self,serienURL="",serienTitle=""):
		if serienURL and len(serienURL) > 1:
			url = serienURL
			print url
		else:
			if serienTitle and len(serienTitle) > 1:
				query = serienTitle
			else:
				query = "Hör mal, wer da hämmert!"
		
			searchstring = self.prepareSearchString(query)
			print searchstring
		
			url = "http://www.fernsehserien.de/{0}/episodenguide".format(searchstring).lower()
			print url
		
		data = None
		socket.setdefaulttimeout(self.timeout)
		req = Request(url,None,self.headers1)
		try:
			response = urlopen(req)
		except URLError as e:
			if hasattr(e, 'reason'):
				print 'We failed to reach a server.'
				print 'Reason: ', e.reason
			elif hasattr(e, 'code'):
				print 'The server couldn\'t fulfill the request.'
				print 'Error code: ', e.code
			return False
		else:
			# everything is fine?
			try:
				data = response.read()
			except Exception:
				return False
		
		if not data or len(data) < 1:
			print "nothing found"
			return False
		
		try:
			s_title_raw = re.findall('<meta name="title" content="(.*?): Episodenguide">', data, re.I)
		except Exception:
			return False
		if s_title_raw and len(s_title_raw) > 0:
			s_title = str(s_title_raw[0])
		else:
			return False
		
		s_title = self.cleanName(s_title)
		print "Titel: '{0}'".format(s_title)
		
		# cover link
		s_cover_raw = re.findall('<head>.*?<meta property="og:image" content="(.*?)">', data, re.I)
		if s_cover_raw and len(s_cover_raw) > 0:
			s_cover = str(s_cover_raw[0])
		else:
			s_cover = "None"
		
		print "Cover: '{0}'".format(s_cover)
				
		s_info_list = re.findall('<tr class="ep-hover.*?>.*?class="episodenliste-ansehen".*?>(.*?)</tr>', data, re.I|re.S)
		s_info = "\n".join(s_info_list)
		
		if not s_info or len(s_info) < 1:
			return False
		
		resultList = None
		resultList = []
		
		e_termine = re.findall('class="episodenliste-episodennummer".*?>(.*?)<.*?class="episodenliste-episodennummer".*?<span.*?>(.*?)<.*?class="episodenliste-episodennummer".*?<span.*?>(.*?)<.*?class="episodenliste-titel".*?">(.*?)<span.*?<td.*?class="episodenliste-originaltitel".*?>(.*?)</td>', s_info, re.I)
		
		for e_l_number,e_s_number,e_e_number,e_name,org_e_name in e_termine:
		
			if not int(e_l_number) > 0 and not str(e_l_number) != "":
				continue
			
			if not re.match('.*[a-z]', e_name, re.I):
				if re.match('.*[a-z]', org_e_name, re.I):
					e_name = org_e_name
				else:
					# no title, skip here
					continue
			e_name = e_name.strip()
			#e_name = e_name.replace("`","'").replace("´","'")
			#e_name = e_name.replace("(","").replace(")","")
			
			if re.match('.*\[TBA\].*', e_name, re.I):
				continue
				
			e_s_number = e_s_number.strip().replace(".","")
			if int(e_s_number) < 10:
				e_s_number = "S0" + e_s_number
			else:
				e_s_number = "S" + e_s_number
				
			e_e_number = e_e_number.strip().replace(".","")
			e_e_number = "E" + e_e_number
			
			new_file_name = e_s_number + e_e_number + " - " + s_title + " - " + e_name
			#new_file_name = s_title + " - " + e_name + " - " + e_s_number + e_e_number 
			new_file_name.strip()
			
			#print new_file_name
			
			resultList.append({
								"e_s_number":e_s_number,
								"e_e_number":e_e_number,
								"s_title":s_title,
								"e_name":self.cleanName(e_name),
								"s_cover":s_cover
							})
							
		# return result
		return resultList
			
