#-*- coding: utf-8 -*-
from Components.config import config, configfile
import urllib, re, datetime, time
import os
import sys
from enigma import eEPGCache

# for standby
import Screens.Standby
from Tools import Notifications
from Tools import Directories
from Screens.MessageBox import MessageBox

# our custom classes
from SkyTimerRec import SkyTimerRec
from SkyMainFunctions import nonHDeventList, buildSkyChannellist, decodeHtml, getHttpHeader, getUserAgent, getEventAllowedRange, getDayOfTheWeek, getTimeFromTimestamp, getCurrentTimestamp, getRecordFilename, getRecordFilenameBase
from SkySql import *


class SkyRunAutocheck():

	def __init__(self, session, no_after_event=None):

		if not config.plugins.skyrecorder.auto_recordtimer_entries:
			return

		self.session = session
		self.no_after_event = no_after_event

		self.sky_chlist = buildSkyChannellist()

		self.ck = {}
		self.sky_log_path = "/usr/lib/enigma2/python/Plugins/Extensions/skyrecorder/sky_log"

		msg_log = "[skyrecorder] starte AutotimerCheck..."
		print msg_log
		self.addLog(msg_log)
		self.my_day_range = None

		try:
			self.my_day_range = config.plugins.skyrecorder.timerdays_allowed.value
		except Exception:
			sys.exc_clear()
			self.my_day_range = ["all"]
		
		dirname = None
		dirname3d = None
		recordings_base_folder = None
		try:
			if config.plugins.skyrecorder.anytimefolder.value:
				recordings_base_folder = config.plugins.skyrecorder.anytimefolder.value
		except Exception:
			sys.exc_clear()
			recordings_base_folder = None
			
		recordings_base_folder_3d = recordings_base_folder
		try:
			if config.plugins.skyrecorder.anytimefolder3d.value:
				recordings_base_folder_3d = config.plugins.skyrecorder.anytimefolder3d.value
		except Exception:
			sys.exc_clear()
			recordings_base_folder_3d = recordings_base_folder
		
		self.pluginName = config.plugins.skyrecorder.pluginname.value
		fromtime = config.plugins.skyrecorder.fromtime.value
		totime = config.plugins.skyrecorder.totime.value
		range_allowed = None
		range_allowed = getEventAllowedRange(int(fromtime),int(totime), self.my_day_range)

		justplay = False
		if config.plugins.skyrecorder.timer_mode.value == "1":
			justplay = True

		filmliste = None
		filmliste = []

		try:
			skipset = sql.getSkipSelect()
		except Exception:
			sys.exc_clear()
			sql.connect()
			skipset = sql.getSkipSelect()
		
		maxParallelTimerLimit = 1000
		if config.plugins.skyrecorder.max_parallel_timers and config.plugins.skyrecorder.max_parallel_timers.value:
			maxParallelTimerLimit = int(config.plugins.skyrecorder.max_parallel_timers.value)
		
		
		# events.id_events, events.title, events.description, events.id_channel,
		# genre.genre, genre.id_genre, eventslist.status, channel.channel,events.image, events.sky_id
		# eventdetails.is_new, genre.status
		
		# excecute modified sql-function which excludes hidden files
		rows = sql.getEventsMainAutoCheck(order="ASC")
		resultCount = len(rows)
		if resultCount > 0:
			for row in rows:
				filmliste.append(row)
			
			# result sorted by channelname only?
			#filmliste = sorted(filmliste, key=lambda sfield: sfield[7])
			#with open("/tmp/sky_debuglog.txt","a") as debuglog:
			#	for a in filmliste:
			#		debuglog.write(str(a) + "\n")
		
		whitelist = sql.readWhitelist(status="True")
		
		canskip = False
		min_starttime_timer = getCurrentTimestamp() + 60 # plus 60 seconds buffer
		
		for event in filmliste:
			
			# only events which are marked as is_new should be added
			# or the event-name is added to our whitelist
			whitelist_event = None
			#whitelist_event = sql.checkWhitelist(int(event[3]),str(event[1]),None,"True")
			# Todo: whitelist word should match greedy
			#whitelist_event = sql.checkWhitelist(None,str(event[1]).lower(),None,status="True",exact="False") # title starts with w-word
			sky_title = str(event[1])
			is_whitelist_event = None
			for whitelist_event in whitelist:
				escaped1 = str(whitelist_event[2]).lower().replace("[","\[").replace("]","\]").replace("(","\(").replace(")","\)")
				escaped2 = sky_title.lower().replace("[","\[").replace("]","\]").replace("(","\(").replace(")","\)")
				if re.match(escaped1 + '.*?', escaped2, re.I):
					is_whitelist_event = True
					break
			
			if not is_whitelist_event:
				if int(event[12]) != 1:
					continue
				if str(event[13]) != "True":
					continue
			
				# whitelist should overwrite skipwords
				for skip in skipset:
					if re.match('.*?' + skip.replace("[","\[").replace("]","\]") + '.*?', event[1], re.I):
						print "skip word matched"
						canskip = True
						break
			if canskip:
				canskip = False
				continue

			id_events = None
			id_events = event[0]
			id_genre = None
			id_genre = event[5]
			id_channel = None
			id_channel = event[3]
			myList = None
			myList = []
				
			rows = sql.getEventsTimer(id_events,order="ASC",min_date=min_starttime_timer)
			resultCount = len(rows)
			if resultCount < 1:
				continue

			for row in rows:
				myList.append(row)

			myList = sorted(myList, key=lambda stime: stime[2])
			
			# build id-tags
			tags = None
			tags = []
			m_id_movie = sql.getMovieInfoMovieId(None, None, m_name="",sky_title=sky_title)
			if m_id_movie and int(m_id_movie) > 0:
				tags.append("tmdb_id:{0}".format(m_id_movie))
						
			if recordings_base_folder:
				if not config.plugins.skyrecorder.create_dirtree.value:
					dirname = recordings_base_folder
				else:
					# get our groupfoldername
					a_dir = sql.getGenregroupByGenreId(id_genre)
					if a_dir:
						group_dir = os.path.join(recordings_base_folder, a_dir + "/")
						if not os.path.exists(group_dir):
							try:
								os.makedirs(group_dir, mode=0777)
								dirname = group_dir
							except Exception:
								sys.exc_clear()
						else:
							dirname = group_dir
			
			if recordings_base_folder_3d:
				if not config.plugins.skyrecorder.create_dirtree.value:
					dirname3d = recordings_base_folder_3d
				else:
					# get our groupfoldername
					a_dir = sql.getGenregroupByGenreId(id_genre)
					if a_dir:
						group_dir = os.path.join(recordings_base_folder_3d, a_dir + "/")
						if not os.path.exists(group_dir):
							try:
								os.makedirs(group_dir, mode=0777)
								dirname3d = group_dir
							except Exception:
								sys.exc_clear()
						else:
							dirname3d = group_dir
								
						
			for timerevent in myList:
				datum = timerevent[1]
				starttime = timerevent[2]
				endtime = timerevent[3]
				channel = timerevent[4]
				title = timerevent[6]
				desc = timerevent[7]
				id_eventslist = timerevent[8]
				#if getCurrentTimestamp() > starttime:
				#	continue

				# FIXME
				
				#record path depending on sky 3d or not
				if channel == "Sky 3D":
					dirnamerec = dirname3d
				else:
					dirnamerec = dirname
				
				hourmin = None
				hourmin = getTimeFromTimestamp(starttime)
				(std,min) = hourmin.split(':')
				event_day = getDayOfTheWeek(starttime, True)
				#self.addLog("std:" + std + " min:" + min)
				#self.addLog(str(range_allowed[0]) + " " + str(range_allowed[1]))


				if int(std) not in range_allowed[0] or str(event_day) not in range_allowed[1]:
					logtext = "[skyrecorder] skipped, day %s and hour %s is not in range_allowed" % (event_day, int(std))
					self.addLog(logtext)
					print logtext
					continue
				
				#if sql.checkAdded(title.lower(), desc.lower(), id_channel, id_genre):
				if sql.checkAdded(title.lower(), desc.lower(), id_channel, None):
				#if sql.checkAdded(title.lower(), desc.lower(), None, None):
					msg_log = "[skyrecorder] already added: %s - %s (%s)" % (title, desc, id_channel)
					print msg_log
					self.addLog(msg_log)
					break

				stb_channel = sql.getChannelFromChannel(channel,stb=True)
				channelref = self.getChannelref(stb_channel)
				if not channelref:
					break
					
				# use settings "margin_before" and "margin_after"
				# for the timers starttime and endtime adjustment
				timer_starttime = starttime - config.plugins.skyrecorder.margin_before.value * 60;
				timer_endtime = endtime + config.plugins.skyrecorder.margin_after.value * 60;
				
				# try to limit recordtimer-entries
				# reload timerlist for every broadcast event/date - needs to be up-to-date
				self.timerList = SkyTimerRec.getTimersList()
				if self.timerList and len(self.timerList) > 0 and maxParallelTimerLimit < 1000:
					timercounter = 0					
					for t_record in self.timerList:
						if (str(channelref) == str(t_record['serviceref'])) and maxParallelTimerLimit >= 1:
							#msg_log = "[skyrecorder] check same channel overlap: %s - %s (%s)" % (title, desc, id_channel)
							#self.addLog(msg_log)
							if (timer_endtime - 60) > int(t_record['begin']): # on same channel, events can overlap 1 minute
								if (timer_starttime + 60) < int(t_record['end']): 
									timercounter += 1
						else:
							# 1 min buffer for events on different channels
							#msg_log = "[skyrecorder] check timer overlap: %s - %s (%s)" % (title, desc, id_channel)
							#self.addLog(msg_log)
							if (timer_endtime + 60) > int(t_record['begin']):
								if (timer_starttime - 60) < int(t_record['end']):
									timercounter += 1
								
					if timercounter >= maxParallelTimerLimit:
						#msg_log = "[skyrecorder] max timer limit reached"
						#self.addLog(msg_log)
						continue
				
				if not config.plugins.skyrecorder.short_record_filenames or not config.plugins.skyrecorder.short_record_filenames.value:
					file = getRecordFilename(title,desc,timer_starttime,stb_channel) # "%s - %s - %s.ts" % (begin_date,channel,title)
				else:
					# for short filenames only need the description field for group "serie" or "series" or "tv shows"
					group = sql.getGenregroupByGenreId(id_genre)
					if group.lower() == "serie" or group.lower() == "series" or group.lower() == "tv shows":
						file_base = getRecordFilenameBase(title,desc,timer_starttime,stb_channel)
					else:
						file_base = getRecordFilenameBase(title,"",timer_starttime,stb_channel)
					
					file = file_base
					ccn = 2
					while 1:
						if not os.path.exists(dirnamerec + file + ".ts"):
							break
						file = file_base + " (" +  str(ccn) +")"
						ccn += 1			
					
				# the suffix ".ts" will be added by the system Timerfunction
				recordfile = Directories.getRecordingFilename(file, dirnamerec)
				#recordfile += ".ts"
				
				# try to get eventID (eit) from epgCache
				eit = 0
				event_matches = self.getEPGevent(['RITBDSE',(channelref,0, starttime, -1)],channelref,title,starttime)
				if event_matches and len(event_matches) > 0:
					for event_entry in event_matches:
						eit = int(event_entry[1])
						break
				
				# finally try to add record-timer
				# timer-sanitycheck is handled by system-timer itself.				
				result = SkyTimerRec.addTimer(self.session, channelref, timer_starttime, timer_endtime, title, desc, 0, justplay, 3, dirnamerec, tags, 0, None, eit=eit,recordfile=recordfile)
				if result["result"]:

					# id_added,title,description,id_channel,id_genre,begin,end,serviceref,location,recordedfile
					if not sql.addAdded(title, desc, id_channel, id_genre, timer_starttime, timer_endtime, channelref, dirnamerec, file, result["eit"], id_eventslist): 
						logtext = "[skyrecorder] could not add %s %s %s to added table" % (title, desc, stb_channel)
						self.addLog(logtext)
						print logtext

					sql.updateEventListStatus(id_events,starttime,status="True")

					print "[skyrecorder] time config:", fromtime,totime,std
					print "[skyrecorder] added:", datum,starttime,endtime,stb_channel,title
					logtext = "Timer Added: %s %s %s %s %s" % (datum, timer_starttime, timer_endtime, stb_channel, title)
					self.addLog(logtext)
					break
				else:
					print "[skyrecorder] timer error: {0}".format(result["message"])
					self.addLog("[skyrecorder] timer error: {0}".format(result["message"]))
	
		# Done
		self.addLog("[skyrecorder] add timer done")
		
		# try to sleep again
		if not self.no_after_event:
			try:
				# go on only if kill deep standby is set
				if config.plugins.skyrecorder.wakeup and config.plugins.skyrecorder.wakeup.value:
					if config.plugins.skyrecorder.autoupdate_database.value: #not Screens.Standby.inStandby and 
						if str(config.plugins.skyrecorder.after_update.value) == "deepstandby":
							mymsg = "{0}\nDie STB wird jetzt ausgeschaltet.".format(self.pluginName)
							self.session.openWithCallback(self.sleepWell,  MessageBox, _(mymsg), MessageBox.TYPE_YESNO, timeout=30, default=True)
						
						elif str(config.plugins.skyrecorder.after_update.value) == "standby":
							mymsg = "{0}\nDie STB geht jetzt in den Standby-Modus.".format(self.pluginName)
							self.session.openWithCallback(self.sendStandbyNotification,  MessageBox, _(mymsg), MessageBox.TYPE_YESNO, timeout=30, default=True)
			except Exception, e:
				print "[skyrecorder] {0}".format(e)
				self.addLog("[skyrecorder] timer error: {0}".format(e))
	

	def sendStandbyNotification(self, answer):
		if answer:
			Notifications.AddNotification(Screens.Standby.Standby)
	
	def sleepWell(self, answer):
		if answer:
			if not Screens.Standby.inTryQuitMainloop:
				self.session.open(
					Screens.Standby.TryQuitMainloop,
					retvalue=1,
					timeout=5,
					default_yes = True
				)


	def getChannelref(self, channel):
		for (channelname,channelref) in self.sky_chlist:
			if channelname.lower() == channel.lower():
				return channelref


	def getEPGevent(self,query,channeref,title,starttime):
		if not query or len(query) != 2:
			return
		epgmatches = []
		epgcache = eEPGCache.getInstance()
		#serviceHandler = eServiceCenter.getInstance()
		allevents = epgcache.lookupEvent(query) or []
		
		for serviceref, eit, name, begin, duration, shortdesc, extdesc in allevents:
			if channeref == serviceref and name.lower() == title.lower() and begin == starttime:
				epgmatches.append( (serviceref, eit, name, begin, duration, shortdesc, extdesc) )
		return epgmatches
		
	def addLog(self, text):
		# check the current file size truncate the file if size is greater than defined limit 100 KB (102400 Bytes)
		sizeb = os.path.getsize(self.sky_log_path)
		if sizeb > 102400:
			# truncate only the first 100 lines in file - delete the oldest ones
			with open(self.sky_log_path, "r+") as f:
				for x in xrange(100):
					f.readline()
					f.truncate()

		lt = time.localtime()
		datum = time.strftime("%d.%m.%Y - %H:%M:%S", lt)
		with open(self.sky_log_path , "a") as write_log:
			write_log.write('"%s - %s"\n' % (datum,text))

