#-*- coding: utf-8 -*-
import sys, urllib, re, shutil, os, datetime, time
import socket
import json
from Components.config import config, configfile
from urllib2 import Request, urlopen, URLError
from SkySql import *
from SkyMainFunctions import *

from StringIO import StringIO
USE_GZIP = True
try:
	import gzip
except Exception:
	sys.exc_clear()
	USE_GZIP = False

class SkyTheMovieDB(object):
	
	def __init__(self,timeout=10):
		self.alternate_lang = "en"
		self.timeout = timeout
		self.sky_log_path = "/usr/lib/enigma2/python/Plugins/Extensions/skyrecorder/sky_log"
		if USE_GZIP:
			self.headers1 = {
			'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:19.0) Gecko/20100101 Firefox/19.0',
			'Accept-Charset': 'ISO-8859-1,utf-8;q=0.7,*;q=0.7',
			'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
			'Cache-Control': 'max-age=3',
			'Accept-Encoding': 'gzip, deflate',
			'Accept-Language': 'de-de,de;q=0.8,en-us;q=0.5,en;q=0.3'}
		else:
			self.headers1 = {
			'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:19.0) Gecko/20100101 Firefox/19.0',
			'Accept-Charset': 'ISO-8859-1,utf-8;q=0.7,*;q=0.7',
			'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
			'Cache-Control': 'max-age=3',
			'Accept-Language': 'de-de,de;q=0.8,en-us;q=0.5,en;q=0.3'}
		self.headers2 = getHttpHeader2()
	
	def cleanName(self,text):
		#text1 = text.decode("iso-8859-1")
		#text = text1.encode("utf-8")
		text = text.replace('&amp;','&')
		text = text.replace('/','')
		text = text.replace(':','_') # for enigma2 getRecordingFilename
		text = text.replace('–','-')
		# finally kill the rest
		text = re.sub('-+',"-",text)
		return text
	
	def prepareSearchString(self,text):
		#text1 = text.decode("iso-8859-1")
		#text = text1.encode("utf-8")
		
		# FIXME: some hacks
		text = re.sub("[Mm]arvel's ","",text)
		text = re.sub("[?]","",text)
		text = urllib.quote_plus(text)
		return text
		
		text = text.replace('&auml;','ae').replace('&Auml;','Ae').replace('&ouml;','oe').replace('&ouml;','Oe').replace('&uuml;','ue')
		text = text.replace('&Uuml;','Ue').replace('&szlig;','ss').replace('&amp;','&').replace('&quot;','\"').replace('&gt;','\'')
		text = text.replace('&#228;','ae').replace('&#246;','oe').replace('&#252;','ue').replace('&#223;','ss').replace('&#8230;','...')
		text = text.replace('\u00c4','Ae').replace('\u00e4;',"ae").replace('\u00d6',"Oe").replace('\u00f6','oe')
		text = text.replace('\u00dc','Ue').replace('\u00fc',"ue").replace('\u00df',"ss")
		text = text.replace('&#196;','Ae').replace('&#228;',"ae").replace('&#214;',"Oe").replace('&#246;',"oe").replace('&#220;',"Ue").replace('&#252;',"ue")
		text = text.replace('ö','oe').replace('ü','ue').replace('ä','ae').replace('Ã','ss')
		text = text.replace('Ö','Oe').replace('Ü','Ue').replace('Ä','Ae')
		text = text.replace('–','-')
		text = text.replace('/','-')
		text = text.replace(' ','-')
		# finally kill the rest
		text = re.sub("[^a-zA-Z0-9-]","",text)
		text = re.sub('-+',"-",text)
		return text
	
	
	def getListFor(self,searchStr,split=False,language="de"):
		if not searchStr or len(searchStr) < 1:
			return False
		
		if split:
			searchStr = searchStr.split("-")[0].strip()
			#searchStr = searchStr.split(":")[0].strip()
		
		searchstring = self.prepareSearchString(searchStr)
		url = "http://api.themoviedb.org/3/search/movie?api_key={0}&query={1}&language={2}".format(config.plugins.skyrecorder.apikey.value,searchstring,language)
		self.addLog("Durchsuche TMDB nach: {0}".format(url))
		data = None
		socket.setdefaulttimeout(self.timeout)
		req = Request(url,None,self.headers1)
		try:
			response = urlopen(req)
			url = response.geturl()
			print url
			req = Request(url,None,self.headers1)
			response = urlopen(req)
		except URLError as e:
			if hasattr(e, 'reason'):
				print 'We failed to reach a server.'
				print 'Reason: ', e.reason
			elif hasattr(e, 'code'):
				print 'The server couldn\'t fulfill the request.'
				print 'Error code: ', e.code
			return False
		else:
			# everything is fine?
			try:
				if USE_GZIP:
					if response.info().get('Content-Encoding') == 'gzip':
					    buf = StringIO(response.read())
					    f = gzip.GzipFile(fileobj=buf)
					    data = f.read()
				else:
					data = response.read()
			except Exception:
				return False
	
		if not data or len(data) < 1:
			data = response.read()
			if not data or len(data) < 1:
				print "nothing found"
				self.addLog('Kein Response der TMDB Webseite')
				return False
		
		# store our results
		resultList = None
		resultList = []
		
		parsed_json = json.loads(data)
		self.addLog("Ergebnis: {0}".format(data))
		
		for m_results in parsed_json["results"]:

			treffer = json.loads(json.dumps(m_results))
			m_movie_url = "http://api.themoviedb.org/3/movie/{0}?api_key={1}".format(treffer["id"],config.plugins.skyrecorder.apikey.value)
			m_poster_url = "http://image.tmdb.org/t/p/w185_and_h278_bestv2{0}".format(treffer["poster_path"])
			m_title_org = str(treffer["original_title"])
			m_title = str(treffer["title"])
			m_date = str(treffer["release_date"][0:4])
			m_id_movie = str(treffer["id"])
			
			resultList.append({
								"m_movie_url":m_movie_url,
								"m_title_org":m_title_org,
								"m_title":m_title,
								"m_poster_url":m_poster_url,
								"m_date":m_date,
								"m_id_movie":m_id_movie
							})
		# return resultlist
		return resultList
		
	
	def getInfoFor(self,movieURL="",movieTitle="",idMovie="",language="de",lastlang=-1):
		lang = ('de','en','es','fr')
		max_lang = len(lang) - 1
		if movieURL and len(movieURL) > 1:
			# default
			if lastlang and int(lastlang) > -1 and int(lastlang) in range(0,max_lang+1):
				language = lang[lastlang]
			if not language or language not in lang:
				language = "de"
			url = "{0}&language={1}".format(movieURL,language)
			
			lastlang = lang.index(language)
			print url
			self.addLog("Abfrage Detailinfos TMDB: {0}".format(url))
		else:
			return False
		
		data = None
		socket.setdefaulttimeout(self.timeout)
		req = Request(url,None,self.headers1)
		try:
			response = urlopen(req)
		except URLError as e:
			if hasattr(e, 'reason'):
				print 'We failed to reach a server.'
				print 'Reason: ', e.reason
			elif hasattr(e, 'code'):
				print 'The server couldn\'t fulfill the request.'
				print 'Error code: ', e.code
			return False
		else:
			# everything is fine?
			try:
				if USE_GZIP:
					if response.info().get('Content-Encoding') == 'gzip':
					    buf = StringIO(response.read())
					    f = gzip.GzipFile(fileobj=buf)
					    data = f.read()
				else:
					data = response.read()
			except Exception:
				return False
		
		if not data or len(data) < 1:
			data = response.read()
			if not data or len(data) < 1:
				print "nothing found"
				#lastlang += 1
				#if lastlang > max_lang:
				#	return False
				#else:
				#	print "next language {0}".format(lang[lastlang])
				#	self.getInfoFor(movieURL=movieURL,movieTitle="",idMovie="",language="de",lastlang=lastlang)
				return False
		
				
		resultList = None
		resultList = []
				
		parsed_json = json.loads(data)

		m_name = str(parsed_json["title"])			
		m_year = str(parsed_json["release_date"][0:4])
		m_rating = str(parsed_json["vote_average"])
		m_description = str(parsed_json["overview"])
		m_title_org = str(parsed_json["original_title"])
		m_posters = str("http://image.tmdb.org/t/p/w300_and_h450_bestv2{0}".format(parsed_json["poster_path"]))
		m_id_movie = str(parsed_json["id"])
		m_genre = []
		for m_results2 in parsed_json["genres"]:
			treffer = json.loads(json.dumps(m_results2))
			m_genre.append(str(treffer["name"]))
				
		resultList.append({
							"m_name":m_name,
							"m_year":m_year,
							"m_title_org":m_title_org,
							"m_rating":m_rating,
							"m_description":m_description,
							"m_posters":m_posters,
							"m_id_movie":m_id_movie,
							"m_genre":m_genre
						})
							
		# return result
		return resultList

	def RunAutoloadInfosTMDB(self):
		self.addLog("RunAutoloadInfos")
		movies = sql.getEventsMainAutoCheck(order="ASC")
		if len(movies) > 0:
			self.addLog("Movie-Eintraege gefunden")
			for movie in movies:
				# get TMDB infos if no infos in database
				if int(movie[14]) == 0:
					self.addLog("Keine DB-Eintraege fr Event {0} gefunden".format(movie[0]))
					id_events = int(movie[0])
					title = str(movie[1])

					self.getMovieInfoAutocheck(searchStr=title, id_events=id_events)
			
	def getMovieInfoAutocheck(self,searchStr,split=False,language="de",id_events=0):
		self.addLog("getMovieInfoAutocheck started")
		try:
			res = self.getListFor(searchStr=searchStr,split=False,language=language)
			if not res or len(res) < 1:
				res = self.getListFor(searchStr=searchStr.split("-")[0].strip(),split=False,language=language)
				if not res or len(res) < 1:
					res = self.getListFor(searchStr=searchStr.split(":")[0].strip(),split=False,language=language)
					if not res or len(res) < 1:
						res = self.getListFor(searchStr=searchStr.split("...")[0].strip(),split=False,language=language)
						if not res or len(res) < 1:
							# ok, we give up
							#self.session.open(MessageBox, "Keine Info gefunden für:\n{0}".format(title), MessageBox.TYPE_INFO, timeout=-1)
							#return
							res = []
		except Exception:
			sys.exc_clear()
			res = []
		# go through filmlist and get entry with newest date
		movieUrl = None
		posterUrl = None
		movieTitle = None
		movieDate = 0

		for t_row in res:
			if int(t_row["m_date"]) > movieDate:
				movieUrl = str(t_row["m_movie_url"])
				movieTitle = str(t_row["m_title"])
				movieDate = int(t_row["m_date"])
				posterUrl = str(t_row["m_poster_url"])

		self.getMovieInfoToDatabase(movieURL=movieUrl, movieTitle=movieTitle, posterUrl=posterUrl, id_events=id_events, sky_title=searchStr)

	def getMovieInfoToDatabase(self,movieURL=None,movieTitle="",posterUrl="",id_events=0,sky_title=""):
		if not movieURL:
			return
		movieinfo = None
		movieinfo = self.getInfoFor(movieURL=movieURL,movieTitle=movieTitle,idMovie="",language="de",lastlang=-1)
		if not movieinfo or len(movieinfo) < 1:
			# fallback language english
			movieinfo = self.getInfoFor(movieURL=movieURL,movieTitle=movieTitle,idMovie="",language="en",lastlang=-1)
			if not movieinfo or len(movieinfo) < 1:
				self.addLog("Keine Info für:\n{0}".format(str(movieURL)))
				return False
			
		if len(movieinfo[0]['m_name']) > 0:
			m_name = str(movieinfo[0]['m_name'])
		else:
			m_name = None
			
		if len(movieinfo[0]['m_id_movie']) > 0:
			m_id_movie = int(movieinfo[0]['m_id_movie'])
		else:
			m_id_movie = None
			
		if len(movieinfo[0]['m_title_org']) > 0:
			m_title_org = str(movieinfo[0]['m_title_org'])
		else:
			m_title_org = ""
		
		if len(movieinfo[0]['m_year']) > 0:
			m_year = str(movieinfo[0]['m_year'])
		else:
			m_year = ""
		
		if len(movieinfo[0]['m_description']) > 0:
			m_description = str(movieinfo[0]['m_description'])
		else:
			m_description = ""
			
		if len(movieinfo[0]['m_genre']) > 0:
			m_genre = movieinfo[0]['m_genre']
		else:
			m_genre = []
		
		if movieinfo[0]['m_rating']:
			m_rating = str(movieinfo[0]['m_rating'])
		else:
			m_rating = "0"
			
		# got movieinfo, store it
		id_themoviedb = sql.existsInMovieInfo(id_events, m_id_movie, m_name,sky_title)
		if not id_themoviedb or id_themoviedb < 1:
			res = sql.addNewMovieInfo(0, m_id_movie, m_name, m_year, m_title_org, m_rating, m_description, m_genre,sky_title)
		
			if not res:
				return
		
		# update cover in database
		if posterUrl and posterUrl != "":
			coverurl = posterUrl
		else:
			if len(movieinfo[0]['m_posters']) > 0:
				coverurl = movieinfo[0]['m_posters'][0]
		
		if coverurl and coverurl != "" and coverurl !="http://image.tmdb.org/t/p/w185_and_h278_bestv2None":
			self.addLog("Coverurl: {0}".format(coverurl))
			data = None
			socket.setdefaulttimeout(10)
			req = Request(coverurl,None,self.headers2)
			response = urlopen(req)
			data = response.read()
			self.gotPoster(data,id_events, m_id_movie, coverurl)

		self.addLog("Info hinzugefügt für:\n{0}".format(str(movieTitle)))
		
	def gotPoster(self, data, id_events, m_id_movie, coverurl):
		if data:
			time.sleep(0.123)
			sql.addMovieInfoPoster(id_events, m_id_movie, coverurl, data)

	def addLog(self, text):
		if len(text) < 1:
			return
		# check the current file size truncate the file if size is greater than defined limit 200 KB (204800 Bytes)
		sizeb = os.path.getsize(self.sky_log_path)
		if sizeb > 204800:
			# truncate only the first 100 lines in file - delete the oldest ones
			with open(self.sky_log_path, "r+") as f:
				for x in xrange(100):
					f.readline()
					f.truncate()

		lt = time.localtime()
		datum = time.strftime("%d.%m.%Y - %H:%M:%S", lt)
		with open(self.sky_log_path , "a") as write_log:
			write_log.write('"%s - %s"\n' % (datum,text))
