#-*- coding: utf-8 -*-
import sys, urllib, re, shutil
import socket
from urllib2 import Request, urlopen, URLError

from StringIO import StringIO
USE_GZIP = True
try:
	import gzip
except Exception:
	sys.exc_clear()
	USE_GZIP = False

class SkyTheTVDB(object):
	
	def __init__(self,timeout=10):
		self.alternate_lang = "en"
		self.timeout = timeout
		if USE_GZIP:
			self.headers1 = {
			'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:19.0) Gecko/20100101 Firefox/19.0',
			'Accept-Charset': 'ISO-8859-1,utf-8;q=0.7,*;q=0.7',
			'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
			'Cache-Control': 'max-age=3',
			'Accept-Encoding': 'gzip, deflate',
			'Accept-Language': 'de-de,de;q=0.8,en-us;q=0.5,en;q=0.3'}
		else:
			self.headers1 = {
			'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:19.0) Gecko/20100101 Firefox/19.0',
			'Accept-Charset': 'ISO-8859-1,utf-8;q=0.7,*;q=0.7',
			'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
			'Cache-Control': 'max-age=3',
			'Accept-Language': 'de-de,de;q=0.8,en-us;q=0.5,en;q=0.3'}
	
	def cleanName(self,text):
		#text1 = text.decode("iso-8859-1")
		#text = text1.encode("utf-8")
		text = text.replace('&amp;','&')
		text = text.replace('/','')
		text = text.replace(':','_') # for enigma2 getRecordingFilename
		text = text.replace('–','-')
		# finally kill the rest
		text = re.sub('-+',"-",text)
		return text
	
	def prepareSearchString(self,text):
		#text1 = text.decode("iso-8859-1")
		#text = text1.encode("utf-8")
		text = urllib.quote_plus(text)
		return text
		text = text.replace('&auml;','ae').replace('&Auml;','Ae').replace('&ouml;','oe').replace('&ouml;','Oe').replace('&uuml;','ue')
		text = text.replace('&Uuml;','Ue').replace('&szlig;','ss').replace('&amp;','&').replace('&quot;','\"').replace('&gt;','\'')
		text = text.replace('&#228;','ae').replace('&#246;','oe').replace('&#252;','ue').replace('&#223;','ss').replace('&#8230;','...')
		text = text.replace('\u00c4','Ae').replace('\u00e4;',"ae").replace('\u00d6',"Oe").replace('\u00f6','oe')
		text = text.replace('\u00dc','Ue').replace('\u00fc',"ue").replace('\u00df',"ss")
		text = text.replace('&#196;','Ae').replace('&#228;',"ae").replace('&#214;',"Oe").replace('&#246;',"oe").replace('&#220;',"Ue").replace('&#252;',"ue")
		text = text.replace('ö','oe').replace('ü','ue').replace('ä','ae').replace('Ã','ss')
		text = text.replace('Ö','Oe').replace('Ü','Ue').replace('Ä','Ae')
		text = text.replace('–','-')
		text = text.replace('/','-')
		text = text.replace(' ','-')
		# finally kill the rest
		text = re.sub("[^a-zA-Z0-9-]","",text)
		text = re.sub('-+',"-",text)
		return text
	
	
	def getListFor(self,searchStr,split=True):
		if not searchStr or len(searchStr) < 1:
			return False
		
		if split:
			searchStr = searchStr.split("-")[0].strip()
			#searchStr = searchStr.split(":")[0].strip()
		
		searchstring = self.prepareSearchString(searchStr)
		url = "http://thetvdb.com/index.php?seriesname={0}&fieldlocation=2&language=14&genre=&year=&network=&zap2it_id=&tvcom_id=&imdb_id=&order=translation&addedBy=&searching=Search&tab=advancedsearch".format(searchstring)

		data = None
		socket.setdefaulttimeout(self.timeout)
		req = Request(url,None,self.headers1)
		try:
			response = urlopen(req)
			url = response.geturl()
			print url
			req = Request(url,None,self.headers1)
			response = urlopen(req)
		except URLError as e:
			if hasattr(e, 'reason'):
				print 'We failed to reach a server.'
				print 'Reason: ', e.reason
			elif hasattr(e, 'code'):
				print 'The server couldn\'t fulfill the request.'
				print 'Error code: ', e.code
			return False
		else:
			# everything is fine?
			try:
				if USE_GZIP:
					if response.info().get('Content-Encoding') == 'gzip':
					    buf = StringIO(response.read())
					    f = gzip.GzipFile(fileobj=buf)
					    data = f.read()
				else:
					data = response.read()
			except Exception:
				return False
		
		if not data or len(data) < 1:
			print "nothing found"
			return False
		
		# store our results
		resultList = None
		resultList = []
		
		s_base = re.findall('<table.*?id="listtable">(.*?)</table>', data, re.I|re.S)
		try:
			s_list_raw = str(s_base[0]).replace("</tr>", "").split("<tr>")
		except Exception:
			return False
		
		for s_result in s_list_raw:
		
			res = re.findall('<td class=".*?"><a href="/index\.php\?tab=series&amp;id=(.*?)&amp;lid=.*?">(.*?)</a></td>', s_result, re.I)
			if not res:
				continue
			s_url_id = str(res[0][0])			
			s_url_name = s_url_id
			s_url = "http://thetvdb.com/?tab=seasonall&id={0}&lid=14".format(s_url_id)
			s_title = str(res[0][1])
			
			s_date = ""
			s_org = ""
			s_subtitle = ""
			
			resultList.append({
								"s_url":s_url,
								"s_url_name":s_url_name,
								"s_title":self.cleanName(s_title),
								"s_subtitle":self.cleanName(s_subtitle),
								"s_date":s_date,
								"s_org":s_org
							})
		# return resultlist
		return resultList
		
	
	def getInfoFor(self,serienURL="",serienTitle="",seriesid=""):
		if serienURL and len(serienURL) > 1:
			url = serienURL
			print url
		else:
			return False
		
		data = None
		socket.setdefaulttimeout(self.timeout)
		req = Request(url,None,self.headers1)
		try:
			response = urlopen(req)
		except URLError as e:
			if hasattr(e, 'reason'):
				print 'We failed to reach a server.'
				print 'Reason: ', e.reason
			elif hasattr(e, 'code'):
				print 'The server couldn\'t fulfill the request.'
				print 'Error code: ', e.code
			return False
		else:
			# everything is fine?
			try:
				if USE_GZIP:
					if response.info().get('Content-Encoding') == 'gzip':
					    buf = StringIO(response.read())
					    f = gzip.GzipFile(fileobj=buf)
					    data = f.read()
				else:
					data = response.read()
			except Exception:
				return False
		
		if not data or len(data) < 1:
			print "nothing found"
			return False
		
		s_title = serienTitle
		s_cover = "None"
		
		e_termine = re.findall('<tr><td class=".*?"><a href="/\?tab=episode&seriesid=.*?&seasonid=.*?&id=.*?&amp;lid=.*?">(.*?) x (.*?)</a></td><td class=".*?"><a href="/\?tab=episode&seriesid=.*?&seasonid=.*?&id=.*?&amp;lid=.*?">(.*?)</a></td><td class=".*?">.*?</td><td class=".*?"><img src=".*?".*?</td></tr>', data, re.I)
		
		resultList = None
		resultList = []
		for e_s_number,e_e_number,e_name in e_termine:

			e_name = e_name.strip()
			#e_name = e_name.replace("`","'").replace("´","'")
			#e_name = e_name.replace("(","").replace(")","")
				
			e_s_number = e_s_number.strip()
			if int(e_s_number) < 10:
				e_s_number = "S0" + e_s_number
			else:
				e_s_number = "S" + e_s_number
			
			e_e_number = e_e_number.strip()
			if int(e_e_number) < 10:
				e_e_number = "E0" + e_e_number
			else:
				e_e_number = "E" + e_e_number
			
			resultList.append({
								"e_s_number":e_s_number,
								"e_e_number":e_e_number,
								"s_title":s_title,
								"e_name":self.cleanName(e_name),
								"s_cover":s_cover
							})
							
		# return result
		return resultList
			
