from Components.Converter.Converter import Converter
from Components.Element import cached
from Poll import Poll
from Tools.Directories import fileExists

class MetrixStyleCIPlusDisplay(Poll, Converter, object):
	SUMMARY = 0
	SINGLE = 1

	def __init__(self, argstr):
		Poll.__init__(self)
		Converter.__init__(self, argstr)
		
		args = argstr.split(',')
		
		type = args[0]
		
		if type == "Summary":
			self.type = self.SUMMARY
		elif type == "Single":
			self.type = self.SINGLE
			self.slot = None
			if len(args) > 1:
				self.slot = args[1]
			
		self.poll_interval = 5000
		self.poll_enabled = True
		
	@cached
	def getBool(self):
		if self.type == self.SINGLE:
			if fileExists("/run/ca/ci%s.service" %self.slot):
				return True
			else:
				return False
		elif self.type == self.SUMMARY:
			slot0 = slot1 = False
			if fileExists("/run/ca/ci0.service"):
				slot0 = True
			if fileExists("/run/ca/ci1.service"):
				slot1 = True
			if slot0 and slot1:
				return True
			else:
				return False

	@cached			
	def getValue(self):
		assert self.type != self.SINGLE, "the value/range ountput of CiPlusDisplay cannot be used for summary"
		
		
	def changed(self, what):
		if what[0] == self.CHANGED_POLL:
			Converter.changed(self, what)
			
	boolean = property(getBool)
	value = property(getValue)