#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
#######################################################################
#
#    MyMetrix
#    Coded by iMaxxx (c) 2013
#    Mod MetrixStyle for DreamOS by arki
#
#  This plugin is licensed under the Creative Commons
#  Attribution-NonCommercial-ShareAlike 3.0 Unported License.
#  To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/3.0/
#  or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
#
#  Alternatively, this plugin may be distributed and executed on hardware which
#  is licensed by Dream Multimedia GmbH.
#
#  This plugin is NOT free software. It is open source, you are allowed to
#  modify it (if you keep the license), but it may not be commercially
#  distributed other than under the conditions noted above.
#
#######################################################################

from Plugins.Plugin import PluginDescriptor
from Screens.Screen import Screen
from Screens.MessageBox import MessageBox
from Screens.ChoiceBox import ChoiceBox
from Screens.Console import Console
from Screens.Standby import TryQuitMainloop
from Components.ActionMap import ActionMap
from Components.AVSwitch import AVSwitch
from Components.config import config, configfile, ConfigYesNo, ConfigSubsection, getConfigListEntry, ConfigSelection, ConfigNumber, ConfigText, ConfigInteger
from Components.ConfigList import ConfigListScreen
from Components.Label import Label
from Components.Language import language
from os import environ, listdir, remove, rename, system
from skin import parseColor
from Components.Pixmap import Pixmap
from Components.Label import Label
import urllib
import gettext
from enigma import ePicLoad
from Tools.Directories import fileExists, resolveFilename, SCOPE_LANGUAGE, SCOPE_PLUGINS

#############################################################

lang = language.getLanguage()
environ["LANGUAGE"] = lang[:2]
gettext.bindtextdomain("enigma2", resolveFilename(SCOPE_LANGUAGE))
gettext.textdomain("enigma2")
gettext.bindtextdomain("MetrixStyleFHD", "%s%s" % (resolveFilename(SCOPE_PLUGINS), "Extensions/MetrixStyleFHD/locale/"))

def _(txt):
	t = gettext.dgettext("MetrixStyleFHD", txt)
	if t == txt:
		t = gettext.gettext(txt)
	return t

def translateBlock(block):
	for x in TranslationHelper:
		if block.__contains__(x[0]):
			block = block.replace(x[0], x[1])
	return block

#############################################################

config.plugins.MetrixStyleFHD = ConfigSubsection()

#General
config.plugins.MetrixStyleFHD.SkinSelectedBackgroundColor = ConfigSelection(default="#001677d1", choices = [
				("#00F0A30A", _("amber")),
				("#00825A2C", _("brown")),
				("#000050EF", _("cobalt")),
				("#001677d1", _("blueberry")),				
				("#00911d10", _("crimson")),
				("#001BA1E2", _("cyan")),
				("#00a61d4d", _("magenta")),
				("#00A4C400", _("lime green")),
				("#006A00FF", _("indigo")),
				("#0070ad11", _("green")),
				("#00008A00", _("emerald")),
				("#0076608A", _("mauve")),
				("#006D8764", _("oliv")),
				("#00c3461b", _("orange")),
				("#00F472D0", _("pink")),
				("#00E51400", _("blood red")),
				("#007A3B3F", _("siena")),
				("#00647687", _("steel")),
				("#00149baf", _("teal")),
				("#006c0aab", _("violett")),
				("#00bf9217", _("gold")),
				("#00ffcc00", _("yellow")),
				("#00cea66b", _("beige")),				
				("#00000000", _("black")),
				("#07000000", _("Metrix 7")),					
				("#15000000", _("Metrix 15")),
				("#30000000", _("Metrix 30")),				
				("#40000001", _("Metrix 40")),
				("#00111010", _("Anthrazit")),
				("#07111010", _("Anthrazit 7")),				
				("#15111010", _("Anthrazit 15")),																
				("#30111010", _("Anthrazit 30")),
				("#40111010", _("Anthrazit 40")),
				("#00353535", _("dark")),
				("#07353535", _("dark 7")),				
				("#15353535", _("dark 15")),
				("#30353535", _("dark 30")),
				("#40353535", _("dark 40")),				
				("#05000080", _("blue")),
				("#15003c51", _("turquoise")),				
				("#05770000", _("red")),
				("#05002900", _("pine green"))				
				])
config.plugins.MetrixStyleFHD.SkinSelectedLine = ConfigSelection(default="line-no", choices = [
				("p_bar", _("white")),
				("p_bar_amber", _("amber")),				
				("p_bar_brown", _("brown")),				
				("p_bar_cobalt", _("cobalt")),
				("p_bar_blue", _("blueberry")),
				("p_bar_crimson", _("crimson")),				
				("p_bar_cyan", _("cyan")),
				("p_bar_magenta", _("magenta")),
				("p_bar_lime", _("lime green")),
				("p_bar_indigo", _("indigo")),
				("p_bar_green", _("green")),				
				("p_bar_emerald", _("emerald")),
				("p_bar_mauve", _("mauve")),
				("p_bar_olive", _("oliv")),
				("p_bar_orange", _("orange")),
				("p_bar_pink", _("pink")),				
				("p_bar_red", _("blood red")),
				("p_bar_sienna", _("siena")),
				("p_bar_steel", _("steel")),
				("p_bar_teal", _("teal")),
				("p_bar_violet", _("violett")),				
				("p_bar_gold", _("gold")),
				("p_bar_yellow", _("yellow")),
				("p_bar_beige",_("beige")),				
				("line-no", _("no"))
				])				
config.plugins.MetrixStyleFHD.SkinSelectedForegroundColor = ConfigSelection(default="#00fffffd", choices = [
				("#00fffffd", _("white")),
				("#00F0A30A", _("amber")),
				("#00825A2C", _("brown")),
				("#000050EF", _("cobalt")),
				("#001677d2", _("blueberry")),				
				("#00911d10", _("crimson")),
				("#001BA1E2", _("cyan")),
				("#00a61d4d", _("magenta")),
				("#00A4C400", _("lime green")),
				("#006A00FF", _("indigo")),
				("#0070ad11", _("green")),
				("#00008A00", _("emerald")),
				("#0076608A", _("mauve")),
				("#006D8764", _("oliv")),
				("#00c3461b", _("orange")),
				("#00F472D0", _("pink")),
				("#00E51400", _("blood red")),
				("#007A3B3F", _("siena")),
				("#00647687", _("steel")),
				("#00149baf", _("teal")),
				("#006c0aab", _("violett")),
				("#00bf9217", _("gold")),
				("#00ffcc00", _("yellow")),
				("#00cea66b", _("beige")),				
				("#00000000", _("black"))
				])								
config.plugins.MetrixStyleFHD.SkinBackgroundColor = ConfigSelection(default="#40000000", choices = [
				("#00000000", _("black")),
				("#07000000", _("Metrix 7")),					
				("#15000000", _("Metrix 15")),
				("#30000000", _("Metrix 30")),				
				("#40000000", _("Metrix 40")),
				("#00111010", _("Anthrazit")),
				("#07111010", _("Anthrazit 7")),				
				("#15111010", _("Anthrazit 15")),																
				("#30111010", _("Anthrazit 30")),
				("#40111010", _("Anthrazit 40")),				
				("#00353535", _("dark")),
				("#07353535", _("dark 7")),				
				("#15353535", _("dark 15")),
				("#30353535", _("dark 30")),
				("#40353535", _("dark 40")),				
				("#05000080", _("blue")),
				("#000050EF", _("cobalt")),
				("#00008A00", _("emerald")),
				("#006A00FF", _("indigo")),
				("#006c0aab", _("violett")),				
				("#15003c51", _("turquoise")),				
				("#05770000", _("red")),				
				("#05002900", _("pine green")),
				("#00cea66b", _("beige"))				
				])
config.plugins.MetrixStyleFHD.SkinForegroundColor = ConfigSelection(default="#00fffffe", choices = [
				("#00fffffe", _("white")),				
				("#00bf9217", _("gold")),				
				("#00cea66b", _("beige")),
				("#00F0A30A", _("amber")),
				("#00825A2C", _("brown"))				
				])				
config.plugins.MetrixStyleFHD.SkinClockColor = ConfigSelection(default="#00dddddd", choices = [
				("#00dddddd", _("white")),
				("#00F0A30A", _("amber")),
				("#00825A2C", _("brown")),
				("#000050EF", _("cobalt")),
				("#001677d2", _("blueberry")),				
				("#00911d10", _("crimson")),
				("#001BA1E2", _("cyan")),
				("#00a61d4d", _("magenta")),
				("#00A4C400", _("lime green")),
				("#006A00FF", _("indigo")),
				("#0070ad11", _("green")),
				("#00008A00", _("emerald")),
				("#0076608A", _("mauve")),
				("#006D8764", _("oliv")),
				("#00c3461b", _("orange")),
				("#00F472D0", _("pink")),
				("#00E51400", _("blood red")),
				("#007A3B3F", _("siena")),
				("#00647687", _("steel")),
				("#00149baf", _("teal")),
				("#006c0aab", _("violett")),
				("#00bf9217", _("gold")),
				("#00ffcc00", _("yellow")),
				("#00cea66b", _("beige"))
				])
config.plugins.MetrixStyleFHD.SkinSelectedHelpTextColor = ConfigSelection(default="#00fffffc", choices = [
				("#00fffffc", _("white")),
				("#00F0A30A", _("amber")),
				("#00825A2C", _("brown")),
				("#000050EF", _("cobalt")),
				("#001677d2", _("blueberry")),				
				("#00911d10", _("crimson")),
				("#001BA1E2", _("cyan")),
				("#00a61d4d", _("magenta")),
				("#00A4C400", _("lime green")),
				("#006A00FF", _("indigo")),
				("#0070ad11", _("green")),
				("#00008A00", _("emerald")),
				("#0076608A", _("mauve")),
				("#006D8764", _("oliv")),
				("#00c3461b", _("orange")),
				("#00F472D0", _("pink")),
				("#00E51400", _("blood red")),
				("#007A3B3F", _("siena")),
				("#00647687", _("steel")),
				("#00149baf", _("teal")),
				("#006c0aab", _("violett")),
				("#00bf9217", _("gold")),
				("#00ffcc00", _("yellow")),
				("#00cea66b", _("beige"))				
				])
config.plugins.MetrixStyleFHD.SkinCaidInfoColor = ConfigSelection(default="#00008A01", choices = [
				("#00F0A30A", _("amber")),
				("#00825A2C", _("brown")),
				("#000050EF", _("cobalt")),
				("#001677d2", _("blueberry")),				
				("#00911d10", _("crimson")),
				("#001BA1E2", _("cyan")),
				("#00a61d4d", _("magenta")),
				("#00A4C400", _("lime green")),
				("#006A00FF", _("indigo")),
				("#0070ad11", _("green")),
				("#00008A01", _("emerald")),
				("#0076608A", _("mauve")),
				("#006D8764", _("oliv")),
				("#00c3461b", _("orange")),
				("#00F472D0", _("pink")),
				("#00E51400", _("blood red")),
				("#007A3B3F", _("siena")),
				("#00647687", _("steel")),
				("#00149baf", _("teal")),
				("#006c0aab", _("violett")),
				("#00bf9217", _("gold")),
				("#00ffcc00", _("yellow")),
				("#00cea66b", _("beige"))				
				])				
config.plugins.MetrixStyleFHD.SkinTunerInfoColor = ConfigSelection(default="#0070ad10", choices = [
				("#00ddddde", _("white")),
				("#00F0A30A", _("amber")),
				("#00825A2C", _("brown")),
				("#000050EF", _("cobalt")),
				("#001677d2", _("blueberry")),				
				("#00911d10", _("crimson")),
				("#001BA1E2", _("cyan")),
				("#00a61d4d", _("magenta")),
				("#00A4C400", _("lime green")),
				("#006A00FF", _("indigo")),
				("#0070ad10", _("green")),
				("#00008A00", _("emerald")),
				("#0076608A", _("mauve")),
				("#006D8764", _("oliv")),
				("#00c3461b", _("orange")),
				("#00F472D0", _("pink")),
				("#00E51400", _("blood red")),
				("#007A3B3F", _("siena")),
				("#00647687", _("steel")),
				("#00149baf", _("teal")),
				("#006c0aab", _("violett")),
				("#00bf9217", _("gold")),
				("#00ffcc00", _("yellow")),
				("#00cea66b", _("beige"))
				])				
config.plugins.MetrixStyleFHD.SkinProgressbarColor = ConfigSelection(default="p_bar", choices = [
				("p_bar", _("= font color")),
				("p_bar_amber", _("amber")),
				("p_bar_brown", _("brown")),
				("p_bar_cobalt", _("cobalt")),
				("p_bar_blue", _("blueberry")),
				("p_bar_crimson", _("crimson")),
				("p_bar_cyan", _("cyan")),
				("p_bar_magenta", _("magenta")),
				("p_bar_lime", _("lime green")),
				("p_bar_indigo", _("indigo")),
				("p_bar_green", _("green")),
				("p_bar_emerald", _("emerald")),
				("p_bar_mauve", _("mauve")),
				("p_bar_olive", _("oliv")),
				("p_bar_orange", _("orange")),
				("p_bar_pink", _("pink")),
				("p_bar_red", _("blood red")),
				("p_bar_sienna", _("siena")),
				("p_bar_steel", _("steel")),
				("p_bar_teal", _("teal")),
				("p_bar_violet", _("violett")),
				("p_bar_gold", _("gold")),
				("p_bar_yellow", _("yellow")),
				("p_bar_beige",_("beige"))
				])
config.plugins.MetrixStyleFHD.SkinLCDbackgroundColor = ConfigSelection(default="#000001", choices = [
				("#000001", _("black")),				
				("#00007f", _("blue")),
				("#7f007f", _("violett")),				
				("#007f00", _("green")),			
				("#ff0000", _("red")),
				("#7f0000", _("crimson"))				
				])
config.plugins.MetrixStyleFHD.DisplayStyle = ConfigSelection(default="display-default", choices = [
				("display-default", _("enigma2")),
				("display-picon", _("Picon .../picon_oled")),
				("display-clock", _("Clock")),
				("display-remaining", _("Clock/Remaining"))				
				])					
config.plugins.MetrixStyleFHD.VolumeStyle = ConfigSelection(default="volume-classic", choices = [
				("volume-classic", _("top left")),
				("volume-classic-center", _("top center")),
				("volume-classic-right", _("top right")),				
				("volume-new", _("big"))
				])				
config.plugins.MetrixStyleFHD.SubtitleStyle = ConfigSelection(default="subtitle-default", choices = [
				("subtitle-small", _("small")),
				("subtitle-default", _("default")),
				("subtitle-big", _("big")),				
				("subtitle-very_large", _("very large"))
				])				
config.plugins.MetrixStyleFHD.TeamImageStyle = ConfigSelection(default="no-widget", choices = [
				("no-widget", _("no")),
				("nn2-metrix", _("Newnigma2")),				
				("merlinepgcenter", _("Merlin"))
				])									
config.plugins.MetrixStyleFHD.MenuStyle = ConfigSelection(default="menu-center", choices = [
				("menu-center", _("Metrix centered")),
				("menu-left", _("Metrix left justified")),				
				("menu-center-untitled", _("MetrixStyle centered")),				
				("menu-left-untitled", _("MetrixStyle left justified")),				
				("menu-big", _("big centered")),
				("menu-big-left", _("big left justified"))				
				])
config.plugins.MetrixStyleFHD.MenuIconBackColor = ConfigSelection(default="menu-icon-backcolor", choices = [
				("menu-icon-backcolor", _("Selection backgroundcolor")),
				("menu-icon", _("Backgroundcolor"))			
				])									
config.plugins.MetrixStyleFHD.AMSStyle = ConfigSelection(default="no-widget", choices = [
				("no-widget", _("no")),
				("ams-metrix", _("yes"))
				])								
config.plugins.MetrixStyleFHD.EMCStyle = ConfigSelection(default="emc-metrix", choices = [
				("emc-metrix", _("Metrix")),
				("emc-metrix-pic", _("Metrix PIG"))				
				])	
config.plugins.MetrixStyleFHD.VideoDBStyle = ConfigSelection(default="no-widget", choices = [
				("no-widget", _("no")),
				("videodb", _("yes"))				
				])
config.plugins.MetrixStyleFHD.MediaPortalStyle = ConfigSelection(default="no-widget", choices = [
				("no-widget", _("no")),
				("mediaportal", _("yes"))				
				])				
#Channelselection
config.plugins.MetrixStyleFHD.ChannelselectionStyle = ConfigSelection(default="channelselection-classic", choices = [
				("channelselection-senior", _("10 lines")),								
				("channelselection-me12", _("12 lines")),
				("channelselection-classic", _("15 lines")),				
				("channelselection-me16", _("16 lines")),
				("channelselection-20z", _("20 lines")),				
				("channelselection-simple", _("12 lines, complete width"))				
				])
config.plugins.MetrixStyleFHD.ChannelselectionInfo = ConfigSelection(default="channelselection-style1a", choices = [
				("channelselection-style1a", _("Style 1a")),
				("channelselection-style1b", _("Style 1b")),
				("channelselection-style1c", _("Style 1c")),				
				("channelselection-style2a", _("Style 2a")),
				("channelselection-style2b", _("Style 2b")),				
				("channelselection-me3ev", _("Style 2c")),				
				("channelselection-me1ev", _("Style 3a")),
				("channelselection-style6", _("Style 3b")),
				("channelselection-style8", _("Style 3c")),				
				("channelselection-pic-left", _("Style 4a")),
				("channelselection-pic-right", _("Style 4b")),				
				("channelselection-style5", _("Style 5a")),
				("channelselection-style5b", _("Style 5b")),
				("channelselection-style5c", _("Style 5c")),
				("channelselection-style9", _("Style 6a")),
				("channelselection-style10", _("Style 6b")),				
				("channelselection-style7", _("Style 7a")),
				("channelselection-style7b", _("Style 7b")),
				("channelselection-style7c", _("Style 7c")),				
				("channelselection-style11", _("Style 11a")),
				("channelselection-style11b", _("Style 11b")),
				("channelselection-style11c", _("Style 11c")),
				("channelselection-style11d", _("Style 11d")),				
				("no-widget", _("blank"))				
				])
config.plugins.MetrixStyleFHD.ChannelselectionPicon = ConfigSelection(default="channelselection-picon-no", choices = [
				("channelselection-picon", _("yes")),																
				("channelselection-picon-no", _("no"))				
				])				
config.plugins.MetrixStyleFHD.Channeldescription = ConfigSelection(default="#00999998", choices = [
				("#00999998", _("grey")),
				("#00ddddde", _("white")),
				("#00F0A30A", _("amber")),
				("#00825A2C", _("brown")),
				("#000050EF", _("cobalt")),
				("#001677d2", _("blueberry")),				
				("#00911d10", _("crimson")),
				("#001BA1E2", _("cyan")),
				("#00a61d4d", _("magenta")),
				("#00A4C400", _("lime green")),
				("#006A00FF", _("indigo")),
				("#0070ad11", _("green")),
				("#00008A00", _("emerald")),
				("#0076608A", _("mauve")),
				("#006D8764", _("oliv")),
				("#00c3461b", _("orange")),
				("#00F472D0", _("pink")),
				("#00E51400", _("blood red")),
				("#007A3B3F", _("siena")),
				("#00647687", _("steel")),
				("#00149baf", _("teal")),
				("#006c0aab", _("violett")),
				("#00bf9217", _("gold")),
				("#00ffcc00", _("yellow")),
				("#00cea66b", _("beige"))				
				])					
#InfoBar
config.plugins.MetrixStyleFHD.InfobarStyle = ConfigSelection(default="infobar-style-classic", choices = [
				("infobar-style-classic", _("Metrix")),
				("infobar-style-metrix1", _("MetrixStyle I")),				
				("infobar-style-metrix2", _("MetrixStyle I (Ticker) ")),
				("infobar-style-metrix3", _("MetrixStyle II")),
				("infobar-style-metrix4", _("MetrixStyle II (Ticker)")),				
				("infobar-style-hc", _("HC")),				
				("infobar-style-hct", _("HC (Ticker) "))							
				])
config.plugins.MetrixStyleFHD.InfobarShowChannelname = ConfigSelection(default="infobar-channelname-number", choices = [
				("no-widget", _("no")),				
				("infobar-channelname-number", _("yes")),
				("infobar-channelname-number-white", _("white")),				
				("infobar-channelname", _("Channelename only")),
				("infobar-channelname-white", _("Channelename only, white")),				
				("infobar-channelname-number-left", _("left justified")),
				("infobar-channelname-number-left-white", _("left justified, white"))				
				])
config.plugins.MetrixStyleFHD.InfobarPiconPath = ConfigSelection(default="infobar-picon", choices = [			
				("infobar-picon", _(" .../picon")),
				("infobar-picon-220x132", _(".../picon_220x132")),
				("infobar-picon-500x300", _(".../picon_500x300")),				
				("infobar-picon-channelnumber", _("Show service numbers")),
				("no-widget", _("blank"))				
				])				
config.plugins.MetrixStyleFHD.InfobarTopLeft = ConfigSelection(default="no-widget", choices = [
				("no-widget", _("off")),
				("infobar-top-left-clockdate", _("Clock/Date")),
				("infobar-top-left-clockdateextended", _("Clock/Date extended")),				
				("infobar-top-left-msnweather", _("Weather"))				
				])
config.plugins.MetrixStyleFHD.InfobarTopCenter = ConfigSelection(default="no-widget", choices = [
				("no-widget", _("off")),
				("infobar-top-center-cryptinfo", _("Show CAID/ECM Info")),
				("infobar-top-center-serviceinfo", _("Serviceinfo")),
				("infobar-top-center-satinfo", _("Serviceinfo")),				
				("infobar-top-center-syteminfo", _("Show System Info")),
				("infobar-top-center-weather-clockdate", _("Weather/Clock/Date full size"))				
				])				
config.plugins.MetrixStyleFHD.InfobarTopRight = ConfigSelection(default="infobar-top-right-clockdate", choices = [
				("no-widget", _("off")),				
				("infobar-top-right-clockdate", _("Clock/Date")),				
				("infobar-top-right-clockdateextended", _("Clock/Date extended")),				
				("infobar-top-right-msnweather", _("Weather"))				
				])				
config.plugins.MetrixStyleFHD.InfobarHead = ConfigSelection(default="no-widget", choices = [
				("no-widget", _("off")),
				("infobar-head-cryptinfo", _("Show CAID/ECM Info")),
				("infobar-head-serviceinfo", _("Serviceinfo")),				
				("infobar-head-colorbuttonts", _("Show Colorbuttonts"))				
				])								
config.plugins.MetrixStyleFHD.InfobarBottomLeft = ConfigSelection(default="infobar-bottom-left-resolutionhealth", choices = [
				("no-widget", _("off")),
				("infobar-bottom-left-caidsoftcam", _("Show CAID")),				
				("infobar-bottom-left-resolutionhealthpg", _("Show Resulotion/Health progress")),				
				("infobar-bottom-left-resolutionhealth", _("Show Resulotion/Health")),
				("infobar-bottom-left-resolution-ciplus-health", _("Show Resulotion/CiPlus/SNR dB")),				
				("infobar-bottom-left-resolution-temp-health", _("Show Resulotion/Fan/SNR dB")),				
				("infobar-bottom-left-resolution-provider", _("Show Resulotion/Provider")),
				("infobar-bottom-left-tuner-signal", _("Show Tunerinfo/SNR dB"))				
				])
config.plugins.MetrixStyleFHD.InfobarBottomCenter = ConfigSelection(default="infobar-tunerinfo-ab", choices = [
				("infobar-tunerinfo-ab", _("2 Tuner")),
				("infobar-tunerinfo-abc", _("3 Tuner")),								
				("infobar-tunerinfo-abcd", _("4 Tuner")),
				("infobar-tunerinfo-abd", _("5 Tuner")),
				("infobar-tunerinfo-6", _("6 Tuner")),	
				("infobar-tunerinfo-8", _("8 Tuner")),				
				("infobar-bottom-center-snr", _("Signal %")),
				("infobar-bottom-center-resolution", _("Resolution")),				
				("no-widget", _("off"))
				])				
config.plugins.MetrixStyleFHD.InfobarBottomRight = ConfigSelection(default="infobar-bottom-right-icons", choices = [
				("infobar-bottom-right-icons", _("Icons classic")),
				("infobar-bottom-right-icons_new", _("Icons new")),							
				("no-widget", _("off"))				
				])
config.plugins.MetrixStyleFHD.InfobarRecordState = ConfigSelection(default="infobar-recordstate-red", choices = [
				("infobar-recordstate-png", _("Metrix")),
				("infobar-recordstate-red", _("Text REC")),
				("no-widget", _("off"))				
				])								
#SecondInfoBar
config.plugins.MetrixStyleFHD.SecondInfobarTopLeft = ConfigSelection(default="no-widget", choices = [
				("no-widget", _("off")),
				("infobar-top-left-clockdate", _("Clock/Date")),
				("infobar-top-left-clockdateextended", _("Clock/Date extended")),				
				("infobar-top-left-msnweather", _("Weather"))				
				])
config.plugins.MetrixStyleFHD.SecondInfobarTopCenter = ConfigSelection(default="no-widget", choices = [
				("no-widget", _("off")),
				("infobar-top-center-cryptinfo", _("Show CAID/ECM Info")),
				("infobar-top-center-serviceinfo", _("Serviceinfo")),
				("infobar-top-center-satinfo", _("Serviceinfo")),				
				("infobar-top-center-syteminfo", _("Show System Info")),
				("infobar-top-center-weather-clockdate", _("Weather/Clock/Date full size"))
				])				
config.plugins.MetrixStyleFHD.SecondInfobarTopRight = ConfigSelection(default="infobar-top-right-clockdate", choices = [
				("no-widget", _("off")),
				("infobar-top-right-clockdate", _("Clock/Date")),				
				("infobar-top-right-clockdateextended", _("Clock/Date extended")),				
				("infobar-top-right-msnweather", _("Weather"))				
				])				
config.plugins.MetrixStyleFHD.SecondInfobarEPGWidget = ConfigSelection(default="no-widget", choices = [
				("secondinfobar-epgwidget", _("Now/Next description")),
				("secondinfobar-extendedinfo", _("Service extendedinfo")),				
				("no-widget", _("off"))
				])								

def main(session, **kwargs):
	session.open(MetrixStyleFHD,"/usr/lib/enigma2/python/Plugins/Extensions/MetrixStyleFHD/images/metrixcolors.png")

def Plugins(**kwargs):
	return PluginDescriptor(name="MetrixStyleFHD", description=_("Setup for Skin MetrixStyleFHD"), where = PluginDescriptor.WHERE_PLUGINMENU, icon="plugin.png", fnc=main)
#######################################################################
class MetrixStyleFHD(ConfigListScreen, Screen):
	skin = """
<screen name="MetrixStyleFHD-Setup" position="60,60" size="1800,960" flags="wfNoBorder" backgroundColor="#40000000">
	<eLabel position="30,23" size="450,75" text="MetrixStyleFHD" font="Regular; 60" valign="center" transparent="1" backgroundColor="#40000000" />
	<eLabel position="488,27" size="525,75" text="Setup" foregroundColor="#00ffffff" font="Regular; 45" valign="center" backgroundColor="#40000000" transparent="1" halign="left" />
	<widget name="config" position="30,150" scrollbarMode="showOnDemand" size="885,675" transparent="1" />	
	<eLabel font="Regular; 30" foregroundColor="#00ffffff" backgroundColor="#40000000" valign="center" position="53,900" size="375,45" text="Cancel" transparent="1" />
	<eLabel font="Regular; 30" foregroundColor="#00ffffff" backgroundColor="#40000000" valign="center" position="503,900" size="375,45" text="Save" transparent="1" />
	<eLabel font="Regular; 30" foregroundColor="#00ffffff" backgroundColor="#40000000" valign="center" position="953,900" size="375,45" text="Restart GUI" transparent="1" />
	<eLabel font="Regular; 30" foregroundColor="#00ffffff" backgroundColor="#40000000" valign="center" position="1403,900" size="375,45" text="Info" transparent="1" />			
	<eLabel position="30,900" size="9,45" backgroundColor="#00ff0000" />
	<eLabel position="480,900" size="9,45" backgroundColor="#0000ff00" />	
	<eLabel position="930,900" size="9,45" backgroundColor="#00ffff00" />
	<eLabel position="1380,900" size="9,45" backgroundColor="#000000ff" />	
	<widget name="helperimage" position="938,150" size="840,473" zPosition="1" />
	<eLabel font="Regular;45" halign="center" valign="center" position="938,675" size="840,60" text="Skin MetrixStyleFHD" transparent="1" />		
	<eLabel font="Regular;39" halign="center" valign="center" position="938,750" size="840,60" text="modded for DreamOS" transparent="1" />	
</screen>
"""

	def __init__(self, session, args = None, picPath = None):
		self.version = "v1.1b"
		self.skin_lines = []
		Screen.__init__(self, session)
		self.session = session
		self.datei = "/usr/share/enigma2/MetrixStyleFHD/skin.xml"
		self.dateiTMP = "/usr/share/enigma2/MetrixStyleFHD/skin.xml.tmp"
		self.daten = "/usr/lib/enigma2/python/Plugins/Extensions/MetrixStyleFHD/data/"
		self.picPath = picPath
		self.Scale = AVSwitch().getFramebufferScale()
		self.PicLoad = ePicLoad()
		self["helperimage"] = Pixmap()
		list = []		
		list.append(getConfigListEntry(_("Selection backgroundcolor"), config.plugins.MetrixStyleFHD.SkinSelectedBackgroundColor))
		list.append(getConfigListEntry(_("... with line"), config.plugins.MetrixStyleFHD.SkinSelectedLine))		
		list.append(getConfigListEntry(_("Selection textcolor"), config.plugins.MetrixStyleFHD.SkinSelectedForegroundColor))		
		list.append(getConfigListEntry(_("Backgroundcolor"), config.plugins.MetrixStyleFHD.SkinBackgroundColor))
		list.append(getConfigListEntry(_("font color"), config.plugins.MetrixStyleFHD.SkinForegroundColor))
		list.append(getConfigListEntry(_("Helptext color"), config.plugins.MetrixStyleFHD.SkinSelectedHelpTextColor))		
		list.append(getConfigListEntry(_("Date color"), config.plugins.MetrixStyleFHD.SkinClockColor))
		list.append(getConfigListEntry(_("CAID color"), config.plugins.MetrixStyleFHD.SkinCaidInfoColor))		
		list.append(getConfigListEntry(_("Health color"), config.plugins.MetrixStyleFHD.SkinTunerInfoColor))	
		list.append(getConfigListEntry(_("Progressbar color"), config.plugins.MetrixStyleFHD.SkinProgressbarColor))
		list.append(getConfigListEntry(_("Display backgroundcolor (only DM 9x0)"), config.plugins.MetrixStyleFHD.SkinLCDbackgroundColor))		
		list.append(getConfigListEntry(_("Display Infobar"), config.plugins.MetrixStyleFHD.DisplayStyle))
		list.append(getConfigListEntry(_("Volume"), config.plugins.MetrixStyleFHD.VolumeStyle))
		list.append(getConfigListEntry(_("Text subtitle presentation"), config.plugins.MetrixStyleFHD.SubtitleStyle))		
		list.append(getConfigListEntry(_("Team Image"), config.plugins.MetrixStyleFHD.TeamImageStyle))
		list.append(getConfigListEntry(_("*** Mainmenu ***"), ))			
		list.append(getConfigListEntry(_("Style"), config.plugins.MetrixStyleFHD.MenuStyle))	
		list.append(getConfigListEntry(_("backgrouncolor symbol"), config.plugins.MetrixStyleFHD.MenuIconBackColor))		
		list.append(getConfigListEntry(_("*** Plugins ***"), ))
		list.append(getConfigListEntry(_("AMS"), config.plugins.MetrixStyleFHD.AMSStyle))		
		list.append(getConfigListEntry(_("EMC"), config.plugins.MetrixStyleFHD.EMCStyle))
		list.append(getConfigListEntry(_("Video DB"), config.plugins.MetrixStyleFHD.VideoDBStyle))
		list.append(getConfigListEntry(_("Media Portal"), config.plugins.MetrixStyleFHD.MediaPortalStyle))		
		list.append(getConfigListEntry(_("*** Channel Selection ***"), ))		
		list.append(getConfigListEntry(_("Channellist Style"), config.plugins.MetrixStyleFHD.ChannelselectionStyle))
		list.append(getConfigListEntry(_("Infopanel"), config.plugins.MetrixStyleFHD.ChannelselectionInfo))
		list.append(getConfigListEntry(_("Picon on top"), config.plugins.MetrixStyleFHD.ChannelselectionPicon))		
		list.append(getConfigListEntry(_("Description color"), config.plugins.MetrixStyleFHD.Channeldescription))		
		list.append(getConfigListEntry(_("*** InfoBar ***"), ))
		list.append(getConfigListEntry(_("Style"), config.plugins.MetrixStyleFHD.InfobarStyle))
		list.append(getConfigListEntry(_("Servicename and number"), config.plugins.MetrixStyleFHD.InfobarShowChannelname))				
		list.append(getConfigListEntry(_("picon path"), config.plugins.MetrixStyleFHD.InfobarPiconPath))		
		list.append(getConfigListEntry(_("top left"), config.plugins.MetrixStyleFHD.InfobarTopLeft))
		list.append(getConfigListEntry(_("top center"), config.plugins.MetrixStyleFHD.InfobarTopCenter))		
		list.append(getConfigListEntry(_("top right"), config.plugins.MetrixStyleFHD.InfobarTopRight))		
		list.append(getConfigListEntry(_("above the infobar"), config.plugins.MetrixStyleFHD.InfobarHead))				
		list.append(getConfigListEntry(_("bottom left"), config.plugins.MetrixStyleFHD.InfobarBottomLeft))
		list.append(getConfigListEntry(_("bottom center"), config.plugins.MetrixStyleFHD.InfobarBottomCenter))		
		list.append(getConfigListEntry(_("bottom right"), config.plugins.MetrixStyleFHD.InfobarBottomRight))		
		list.append(getConfigListEntry(_("Show Record Icon"), config.plugins.MetrixStyleFHD.InfobarRecordState))		
		list.append(getConfigListEntry(_("*** SecondInfoBar ***"), ))		
		list.append(getConfigListEntry(_("top left"), config.plugins.MetrixStyleFHD.SecondInfobarTopLeft))
		list.append(getConfigListEntry(_("top center"), config.plugins.MetrixStyleFHD.SecondInfobarTopCenter))		
		list.append(getConfigListEntry(_("top right"), config.plugins.MetrixStyleFHD.SecondInfobarTopRight))						
		list.append(getConfigListEntry(_("Info Panel"), config.plugins.MetrixStyleFHD.SecondInfobarEPGWidget))		

		ConfigListScreen.__init__(self, list)
		self["actions"] = ActionMap(["OkCancelActions","DirectionActions", "InputActions", "ColorActions"], {"left": self.keyLeft,"down": self.keyDown,"up": self.keyUp,"right": self.keyRight,"red": self.exit,"yellow": self.reboot, "blue": self.showInfo, "green": self.save,"cancel": self.exit}, -1)
		self.onLayoutFinish.append(self.UpdateComponents)
		
	def GetPicturePath(self):
		try:
			returnValue = self["config"].getCurrent()[1].value
			#print "\n selectedOption: " + returnValue + "\n"
			path = "/usr/lib/enigma2/python/Plugins/Extensions/MetrixStyle/images/" + returnValue + ".png"
			return path
		except:
			return "/usr/lib/enigma2/python/Plugins/Extensions/MetrixStyle/images/no-widget.png"
		
	def UpdatePicture(self):
		self.PicLoad_conn = self.PicLoad.PictureData.connect(self.DecodePicture)
		self.onLayoutFinish.append(self.ShowPicture)
	
	def ShowPicture(self):
		self.PicLoad.setPara([self["helperimage"].instance.size().width(),self["helperimage"].instance.size().height(),self.Scale[0],self.Scale[1],0,1,"#002C2C39"])
		self.PicLoad.startDecode(self.GetPicturePath())
		#print "showing image"
		
	def DecodePicture(self, PicInfo = ""):
		#print "decoding picture"
		ptr = self.PicLoad.getData()
		self["helperimage"].instance.setPixmap(ptr)	

	def UpdateComponents(self):
		self.UpdatePicture()

	def keyLeft(self):	
		ConfigListScreen.keyLeft(self)	
		self.ShowPicture()

	def keyRight(self):
		ConfigListScreen.keyRight(self)
		self.ShowPicture()
	
	def keyDown(self):
		#print "key down"
		self["config"].instance.moveSelection(self["config"].instance.moveDown)
		#ConfigListScreen.keyDown(self)
		self.ShowPicture()
		
	def keyUp(self):
		#print "key up"
		self["config"].instance.moveSelection(self["config"].instance.moveUp)
		#ConfigListScreen.keyUp(self)
		self.ShowPicture()
	
	def reboot(self):
		restartbox = self.session.openWithCallback(self.restartGUI,MessageBox,_("Do you really want to reboot now?"), MessageBox.TYPE_YESNO)
		restartbox.setTitle(_("Restart GUI"))
		
	def showInfo(self):
		self.session.open(MessageBox, _("Skin MetrixStyle  8.6 \n\nmodded for DreamOS by arki \n\nsupport www.nachtfalke.biz"), MessageBox.TYPE_INFO)

	def save(self):
		for x in self["config"].list:
			if len(x) > 1:
        			x[1].save()
			else:
       				pass
       			
		###########READING DATA FILES
		try:
			self.appendSkinFile(self.daten + "header.xml")				
			###InfoBar
			self.appendSkinFile(self.daten + "infobar-header.xml")
			#Style
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.InfobarStyle.value + ".xml")
			#Picon			
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.InfobarPiconPath.value + ".xml")			
			#TopLeft			
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.InfobarTopLeft.value + ".xml")
			#TopCenter
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.InfobarTopCenter.value + ".xml")
			#TopRight
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.InfobarTopRight.value + ".xml")
			#InfobarHeadPanel
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.InfobarHead.value + ".xml")			
			#ChannelName
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.InfobarShowChannelname.value + ".xml")		
			#BottomLeft
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.InfobarBottomLeft.value + ".xml")
			#BottomCenter
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.InfobarBottomCenter.value + ".xml")			
			#BottomRight
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.InfobarBottomRight.value + ".xml")
			#RecordState
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.InfobarRecordState.value + ".xml")			
			#Footer
			self.appendSkinFile(self.daten + "infobar-footer.xml")			
			###SecondInfoBar
			self.appendSkinFile(self.daten + "secondinfobar-header.xml")
			#TopLeft
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.SecondInfobarTopLeft.value + ".xml")
			#TopCenter
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.SecondInfobarTopCenter.value + ".xml")
			#TopRight
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.SecondInfobarTopRight.value + ".xml")			
			#EPGWidget
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.SecondInfobarEPGWidget.value + ".xml")			
			#Footer
			self.appendSkinFile(self.daten + "secondinfobar-footer.xml")
			#Channelselection			
			self.appendSkinFile(self.daten + "channelselection-header.xml")
			#Channelselectionlist
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.ChannelselectionStyle.value + ".xml")
			#Channelselectioninfo
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.ChannelselectionInfo.value + ".xml")
			#Channelselection picon
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.ChannelselectionPicon.value + ".xml")			
			#Footer			
			self.appendSkinFile(self.daten + "channelselection-footer.xml")			
			#VOLUMESTYLE
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.VolumeStyle.value + ".xml")
			#SUBTITLESTYLE
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.SubtitleStyle.value + ".xml")			
			#MAINMENU
			self.appendSkinFile(self.daten + "menu-header.xml")
			#MENUSTYLE			
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.MenuStyle.value +".xml")
			#ICONSTYLE			
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.MenuIconBackColor.value +".xml")			
			#Footer
			self.appendSkinFile(self.daten + "menu-footer.xml")			
			#NN2
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.TeamImageStyle.value +".xml")
			#AMS
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.AMSStyle.value +".xml")			
			#EMC
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.EMCStyle.value +".xml")
			#VideoDB
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.VideoDBStyle.value +".xml")
			#MediaPortal
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.MediaPortalStyle.value +".xml")			
			#Display
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.DisplayStyle.value +".xml")			
			#SelectedLine
			self.appendSkinFile(self.daten + config.plugins.MetrixStyleFHD.SkinSelectedLine.value +".xml")									
			###Main XML
			self.appendSkinFile(self.daten + "main.xml")

			xFile = open(self.dateiTMP, "w")
			for xx in self.skin_lines:
				xFile.writelines(xx)
			xFile.close()
			#Replaces <color name="metrixSelection" value="#001677d1" /> with SkinSelectedBackgroundColor.value
			o = open(self.datei,"w")
			for line in open(self.dateiTMP):
				
				line = line.replace("#001677d1", config.plugins.MetrixStyleFHD.SkinSelectedBackgroundColor.value )				
				line = line.replace("#00fffffd", config.plugins.MetrixStyleFHD.SkinSelectedForegroundColor.value )
				line = line.replace("#40000000", config.plugins.MetrixStyleFHD.SkinBackgroundColor.value )				
				line = line.replace("#00fffffe", config.plugins.MetrixStyleFHD.SkinForegroundColor.value )
				line = line.replace("#00fffffc", config.plugins.MetrixStyleFHD.SkinSelectedHelpTextColor.value )				
				line = line.replace("#00dddddd", config.plugins.MetrixStyleFHD.SkinClockColor.value )
				line = line.replace("#00008A01", config.plugins.MetrixStyleFHD.SkinCaidInfoColor.value )				
				line = line.replace("#0070ad10", config.plugins.MetrixStyleFHD.SkinTunerInfoColor.value )				
				line = line.replace("#00999998", config.plugins.MetrixStyleFHD.Channeldescription.value )			
				line = line.replace("p_bar", config.plugins.MetrixStyleFHD.SkinProgressbarColor.value )
				line = line.replace("#000001", config.plugins.MetrixStyleFHD.SkinLCDbackgroundColor.value )				
				o.write(line)
			o.close()
			system('rm -rf ' + self.dateiTMP)

		except:
			self.session.open(MessageBox, _("Error creating Skin!"), MessageBox.TYPE_ERROR)
		configfile.save()
		restartbox = self.session.openWithCallback(self.restartGUI,MessageBox,_("GUI needs a restart to apply a new skin\nDo you want to Restart the GUI now?"), MessageBox.TYPE_YESNO)
		restartbox.setTitle(_("Restart GUI"))

	def restartGUI(self, answer):
		if answer:
			self.session.open(TryQuitMainloop, 3)
			
	def appendSkinFile(self,appendFileName):
		skFile = open(appendFileName, "r")
		file_lines = skFile.readlines()
		skFile.close()	
		for x in file_lines:
			self.skin_lines.append(x)
			
	def exit(self):
		for x in self["config"].list:
			if len(x) > 1:
					x[1].cancel()
			else:
       				pass
		del self.PicLoad
		self.close()
