from Plugins.Plugin import PluginDescriptor
from Components.ServiceEventTracker import ServiceEventTracker
from Screens.Screen import Screen
from enigma import iPlayableService
from GlobalActions import globalActionMap

# list of mode choices to cycle through
# MODE_CHOICES = [540, 600, 660, 720]
# MODE_CHOICES = [540, 570, 600, 630, 660, 690, 720]
MODE_CHOICES = [540, 720]

def get_mode():
	f = open("/proc/stb/vmpeg/0/dst_width", "r")
	#mode = f.read().strip("\n")
	mode = f.read()
	f.close()
	return int(mode, 16)
	
def set_mode(mode):
	w = open("/proc/stb/vmpeg/0/dst_width", "w")
	w.write("%x" % mode)
	w.close()
	l = open("/proc/stb/vmpeg/0/dst_left", "w")
	left = (720 - mode) / 2
	l.write("%x" % left)
	l.close()
	a = open("/proc/stb/vmpeg/0/dst_apply", "w")
	a.write("%x" % 0)
	a.close()

class LetterBoxHD(Screen):
	def __init__(self, session):
		Screen.__init__(self, session)
		self.default = None
		self.tracker = ServiceEventTracker(screen=self, eventmap=
				{ iPlayableService.evStart: self.reset, })
		self.used = False
		global globalActionMap
		globalActionMap.actions["toggle_reduce"] = self.toggle

	def reset(self):
		if self.used:
			set_mode(self.default)
			self.used = False
		else:
			self.default = get_mode()

	def toggle(self):
		mode = get_mode()
		if not mode in MODE_CHOICES:
			MODE_CHOICES.append(mode)
		modeidx = MODE_CHOICES.index(mode)
		modeidx = (modeidx + 1) % len(MODE_CHOICES)
		set_mode(MODE_CHOICES[modeidx])
		self.used = True

letterboxHD = None

def reduce_init(reason, **kwargs):
	global letterboxHD
	letterboxHD = LetterBoxHD(kwargs["session"])

def Plugins(**kwargs):
	return [PluginDescriptor(where=PluginDescriptor.WHERE_SESSIONSTART, fnc=reduce_init)]
