from Components.Converter.Converter import Converter
from Components.Element import cached
from Poll import Poll
from time import time
import json
import urllib2
import os


CHECKIP = "http://ip-api.com/json"
IPDATA = "/tmp/ipdata"
UPDATEPAUSE = 5


def del_ipfiles():
    if os.path.isfile(IPDATA):
        os.remove(IPDATA)
        

def get_device():
    dev_device = "tun0"
    try:
        if os.path.exists("/etc/openvpn"):
            for i in os.listdir("/etc/openvpn"):
                if i.split('.')[-1] == 'conf':
                    f = open("/etc/openvpn/%s" % i, "r").readlines()
                    for line in f:
                        if "dev" in line:
                            if not "#" == line[0]:
                                dev_device = line[4:].strip() + "0"
                                break
    except:
        dev_device = "tun0"
    return dev_device


def get_ipdata():
    is_vpn = True if get_device() in str(os.listdir("/sys/devices/virtual/net")) else False
    try:
        if is_vpn:
            if not os.path.exists(IPDATA) or time() - os.path.getmtime(r"%s" % IPDATA) > UPDATEPAUSE:
                data = urllib2.urlopen(CHECKIP, timeout=4).read()
                f = open(IPDATA, 'w')
                f.write(data)
                f.close()
                data = json.loads(data)
            else:
                data = json.loads(open(IPDATA, 'r').read())
            country = data["country"].encode("utf-8") if isinstance(data["country"], unicode) else data["country"]
            city = data["city"].encode("utf-8") if isinstance(data["city"], unicode) else data["city"]
            ip = data["query"].encode("utf-8") if isinstance(data["query"], unicode) else data["query"]
        else:
            country = city = ip = None
    except:
        country = city = ip = None
    return country, city, ip, is_vpn


del_ipfiles()


class SuissVpnInfo(Poll, Converter, object):
    def __init__(self, type):
        Converter.__init__(self, type)
        self.type = type
        Poll.__init__(self)
        self.poll_interval = 60000
        self.poll_enabled = True

    @cached
    def getBoolean(self):
        is_vpn = False
        if self.type == "VPN":
            country, city, ip, is_vpn = get_ipdata()
        if is_vpn:
            return True
        return False

    boolean = property(getBoolean)
    