#!/bin/bash
# (c) Fred Bogus Trumper 2023
# https://board.newnigma2.to/wbb4/index.php/Thread/34646-FAQ-Festplatte-tauschen-Daten-kopieren-klonen/?postID=350419#post350419

case $1 in
	-h|--help|"")
		echo "[USAGE]: $0 <directory 1> <directory 2> .. <directory 9>"
		echo -e "\texample: $0 /media/hdd/movie /media/usb/movie\n"
		exit 1
	;;
esac

for directory in $1 $2 $3 $4 $5 $6 $7 $8 $9
do 
	if [ -d $directory ]
	then
                #echo "used space human readable of $directory: "$(du -sh $directory|awk '{print $1}')
		echo $directory:
                echo "used space usage of $directory: $(du -sb $directory|awk '{print $1}') bytes ( $(du -sh $directory|awk '{print $1}') )"
		echo directories, files and symbolic links in $directory:
		for filetype in d f l
			do
				case $filetype in
					d) echo -n "directories:    ";;
					f) echo -n "files:          ";;
					l) echo -n "symbolic links: ";;
				esac
				number=$(find $directory -type $filetype|wc -l)
				printf "%8s \n" $number
			done
			echo
	else 
		echo -e directory $directory does not exist\\n$directory will be ignored ...\\n
	fi
done

exit 0
