#!/bin/bash
# Fred Bogus Trumper (c) 2023
# newnigma2.to


license (){
echo "
license: GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
license text: https://www.gnu.org/licenses/gpl-3.0.txt
support forum: https://www.newnigma2.to

"
}

disclaimer (){
echo "
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

"
}

read_me (){
echo "
cp2list.sh - copy picon to service list
by Fred Bogus Trumper (c) 2023

This script will copy enigma 2 service picons from a source directory
to a target directory by zapping automaticly from a defined start channel
to a defined end channel and creates a .csv file to open in Excel which
including following information:

channel number | Service Reference | Service Name | picon name

If no source or no target directy is defined only the .csv file will be
created.

The symlink options will create a symlink from the service_reference_picon.png
to a service_name_picon(.png)

"
}

help (){
echo -e "
[USAGE]:\n$0 <start number> <end number> [<picon source directory> <picon target directory>] [<symlink option>]

example:
$0 1 10 /picons/piconHD/ /tmp/test/ <symlink option>

will start on channel number 1
will end on channel number 10
/picons/piconHD/      picon source directory
/tmp/test:            picon target directory, will be created if does not exist
symlink option:       additional option to create symlinks

symlink options:
ln or --link-name     create a symlink from picon.png to 'service name' in target directory
lp or --link-picon    create a symlin from picon.png to 'service name.png' in target directory
lb or --link-both     create symlinks from picon.png to 'service name' and 'service name.png'

--help, -h	      show this help
--readme              short description
--license             show lisence information
--disclaimer          show disclaimer information

"
}


##### VARIABLES #####

CURRENT_SERVICE=
SERVICE_NAME=
SERVICE_REFERENCE=
PICON_NAME=
PIC0N_SOURCE_DIRECTORY=
USED_SPACE_PICON_SOURCE_DIRECTORY=
PICON_TARGET_DIRECTORY=
FREE_SPACE_PICON_TARGET_DIRECTORY=
COPY=
CSV_FILE=
ERROR_LOG=
SYMLINK_TAG=
NUMBER=
PICON_NUMBER=0
PICON_ERROR=0

### VARIABLES END ###


clear_double_slash (){
sed 's/\/\//\//g'
}

get_service_dreamboxctl () {
CURRENT_SERVICE=$(dreamboxctl currentService)
SERVICE_NAME=$(grep name <<< "$CURRENT_SERVICE"|sed 's/name://g')
SERVICE_REFERENCE=$(grep reference <<< "$CURRENT_SERVICE"|sed 's/reference://g')
PICON_NAME=$(echo "$SERVICE_REFERENCE"|tr ':' _ |sed 's/\(_*\).$/\.png/')
echo -e "service name:              $SERVICE_NAME\nservice reference:         $SERVICE_REFERENCE\npicon name:                $PICON_NAME\n"
}

get_service_webif () {
CURRENT_SERVICE=$(curl -s -X POST "http://localhost/web/getcurrent?&sessionid=$SESSIONID")
SERVICE_NAME=$(echo "$CURRENT_SERVICE"|grep servicename|tail -n 1|sed 's/e2eventservicename\|<\|>\|\///g'|awk '{gsub(/^[ \t]+/,""); print$0}')
SERVICE_REFERENCE=$(echo "$CURRENT_SERVICE"|grep servicereference|tail -n 1|sed 's/e2eventservicereference\|<\|>\|\///g'|awk '{gsub(/^[ \t]+/,""); print$0}')
PICON_NAME=$(echo "$CURRENT_SERVICE"|grep servicereference|tail -n 1|sed 's/e2eventservicereference\|<\|>\|\///g'|tr ':' _ |sed 's/\(_*\).$/\.png/'| awk '{print $1}')
echo -e "service name:\t\t$SERVICE_NAME\nservice reference:\t$SERVICE_REFERENCE\npicon name:\t\t$PICON_NAME\n"
}

zap () {
SESSIONID=$(curl -s -X POST "http://localhost/web/session"|grep e2sessionid|sed 's/e2sessionid\|<\|>\|\///g')
curl -s -X POST "http://localhost/web/remotecontrol?command=106&sessionid=$SESSIONID" &>/dev/null
sleep 0.5
}

start_service () {
LENGH=${#1}
offset=0
SESSIONID=$(curl -s -X POST "http://localhost/web/session"|grep e2sessionid|sed 's/e2sessionid\|<\|>\|\///g')
for number in $(seq 1 $LENGH)
do	
	key=$(echo "${1:$offset:$number}")
#	echo $key
	if [ $key = 0 ]
	then	
		key=11
	else
		key=$(( $key+1 ))
	fi
#	echo key: $key
	curl -s -X POST "http://localhost/web/remotecontrol?command=$key&sessionid=$SESSIONID" 1>/dev/null
	sleep 0.5
#	echo $offset $number
	offset=$(( $offset+1 ))
done
curl -s -X POST "http://localhost/web/remotecontrol?command=352&sessionid=$SESSIONID" 1>/dev/null	
sleep 0.5
}

check_free_space (){
FREE_SPACE_PICON_TARGET_DIRECTORY=$(df -B 1048576 $PICON_TARGET_DIRECTORY|tail -n 1| awk '{print $4}')
#echo $FREE_SPACE_PICON_TARGET_DIRECTORY
if [ $(( $FREE_SPACE_PICON_TARGET_DIRECTORY+1 )) -lt $USED_SPACE_PICON_SOURCE_DIRECTORY ]
then
	echo -e "\nto less space left on target directory '$PICON_TARGET_DIRECTORY' !\n\nused space on source directory '$PIC0N_SOURCE_DIRECTORY': ${USED_SPACE_PICON_SOURCE_DIRECTORY}MB"
	echo -e "free space on target directory '$PICON_TARGET_DIRECTORY': ${FREE_SPACE_PICON_TARGET_DIRECTORY}MB\nplease check the directories\n\n$0 terminated ...\n"
	exit 7
fi
}

case $1 in 
        "") 			echo -e "option #1 empty\n";help;exit 1;;	
	-h|help|--help)		help;exit 1;;
	--readme)		read_me;exit 1;;
	--license)		license;exit 1;;
	--disclaimer)		disclaimer;exit 1;;
esac


if ! [[ `echo "$1" | grep -E ^[[:digit:]]+$` ]]
then
	echo -e "\n'$1' is not a number (type integer) !\n$0 terminated ...\n"
	exit 3
else
	START_CHANNEL=$(echo $1)
	CHANNEL_NUMBER=$(echo $1)
fi

case $2 in                                                                                                                                     
        "") echo -e "option #2 empty\n";help;exit 2;;
esac


if ! [[ `echo "$2" | grep -E ^[[:digit:]]+$` ]]
then
echo -e "\n'$2' is not a number (type integer) !\n$0 terminated ...i\n"
exit 4
else
	END_CHANNEL=$(echo $2)
fi
if [ $END_CHANNEL -lt $START_CHANNEL ]
then
	echo -e "end channel number ($END_CHANNEL) have to be equal or greater than start channel number ($START_CHANNEL)\n"
	exit 5
fi

PIC0N_SOURCE_DIRECTORY=$(echo $3)
PICON_TARGET_DIRECTORY=$(echo $4)

case $PIC0N_SOURCE_DIRECTORY in
	"")
#		CSV_FILE="/tmp/service_picon_list_$START_CHANNEL-$END_CHANNEL.csv"
		echo -e "no picon source directory defined\nno picons will be copied\nonly create $CSV_FILE\n"
		COPY=0
		;;
	*)	
		if [ ! -d $PIC0N_SOURCE_DIRECTORY ]
		then
			echo -e "source directory '$PIC0N_SOURCE_DIRECTORY' does not exist\nterminated ...\n"
			exit 6
		else
			USED_SPACE_PICON_SOURCE_DIRECTORY=$(du -sm $PIC0N_SOURCE_DIRECTORY|awk '{print $1}')
		fi
		COPY=1
		CSV_FILE="$PICON_TARGET_DIRECTORY/service_picon_list_${START_CHANNEL}-${END_CHANNEL}.csv"
		ERROR_LOG="$PICON_TARGET_DIRECTORY/service_picon_list_${START_CHANNEL}-${END_CHANNEL}_error.log"
		;;
esac

case $PICON_TARGET_DIRECTORY in
	"")	if [ $COPY = 1 ]
		then
			echo -e "no picon target directory defined\nno picons will be copied\n"
			COPY=0
		fi
		;;
	*)	if [ ! -d $PICON_TARGET_DIRECTORY ]
		then
			mkdir -p $PICON_TARGET_DIRECTORY
			COPY=1
		fi
		;;
	esac


case $COPY in
	0)	decision=false
		while [ $decision = false ]
		do
			echo -en "continue anyway? (y/n) "
			read -sn 1 choice
			case $choice in "y"|"Y"|"n"|"N") decision=true;;esac
			echo
		done
		case $choice in
			y|Y)    clear;CSV_FILE="/tmp/service_picon_list_$START_CHANNEL-$END_CHANNEL.csv";;
			n|N)    clear;echo -e "$0 terminated!\n";exit 8;;
			esac
			choice=
		;;
	1)	check_free_space
		CSV_FILE="$PICON_TARGET_DIRECTORY/service_picon_list_${START_CHANNEL}-${END_CHANNEL}.csv"
		ERROR_LOG="$PICON_TARGET_DIRECTORY/service_picon_list_${START_CHANNEL}-${END_CHANNEL}_error.log"
		;;
esac

create_name_link (){
echo -e "create symlink from $PICON_TARGET_DIRECTORY/$PICON_NAME '$PICON_TARGET_DIRECTORY/$SERVICE_NAME'" | clear_double_slash
[ "$(/bin/pwd)" != "$PICON_TARGET_DIRECTORY" ] && cd $PICON_TARGET_DIRECTORY
ln -sf "$PICON_NAME" "$SERVICE_NAME"
}

create_picon_link () {
echo -e "create symlink from $PICON_TARGET_DIRECTORY/$PICON_NAME $PICON_TARGET_DIRECTORY/$SERVICE_NAME.png" | clear_double_slash
[ "$(/bin/pwd)" != "$PICON_TARGET_DIRECTORY" ] && cd $PICON_TARGET_DIRECTORY
ln -sf "$PICON_NAME" "$SERVICE_NAME.png"
}

startservice=0
NUMBER=$(( $END_CHANNEL-$START_CHANNEL+1 ))
SYMLINK_TAG=$(echo $5)
CURRENT_LANG=$(echo $LANG)
[ "$LOCALE" != "en_US.UTF-8" ] && export LANG="en_US.UTF-8"
echo -e "#SERVICE/PICON list: $(hostname) - created on $(date +%A,\ %d.\ %B\ %Y\ at\ %H:%M:%S)\nchannel number;service reference;service name;picon name" > $CSV_FILE
export LANG="echo $CURRENT_LANG"
while true
do
	if [ $CHANNEL_NUMBER -gt $END_CHANNEL ]
	then
		clear
		echo -e "$0 $1 $2 $3 $4 $5 completed\n\n$NUMBER channel(s) scaned - find list in $CSV_FILE\n"
		if [ $COPY = 1 ]
		then
			echo -e "$PICON_NUMBER picon(s) copied to $PICON_TARGET_DIRECTORY"
			[ -e $ERROR_LOG ] && echo -e "$PICON_ERROR picon(s) not found - find errors in $ERROR_LOG\n" || echo -e "no errors logged\n"
		fi
		exit 8
	fi
	if [ $startservice = 0 ]
	then
		start_service $CHANNEL_NUMBER
		startservice=1
		[ -e $ERROR_LOG ] && rm $ERROR_LOG &>/dev/null
		clear
	else
		zap
	fi
	echo -e "channel number:\t\t$CHANNEL_NUMBER"
	#get_service_dreamboxctl
	get_service_webif
	echo "$CHANNEL_NUMBER;$SERVICE_REFERENCE;$SERVICE_NAME;$PICON_NAME" >> $CSV_FILE
	if [ $COPY = 1 ]
	then
		if [ -e $PIC0N_SOURCE_DIRECTORY/$PICON_NAME ]
		then
			echo "copy $PIC0N_SOURCE_DIRECTORY/$PICON_NAME to $PICON_TARGET_DIRECTORY/" | clear_double_slash
			cp -a $PIC0N_SOURCE_DIRECTORY/$PICON_NAME $PICON_TARGET_DIRECTORY/
			PICON_NUMBER=$(( $PICON_NUMBER+1 ))
			case $SYMLINK_TAG in
				"nl"|"ln"|"--link-name")	create_name_link;;
				"pl"|"lp"|"--link-picon")	create_picon_link;;
				"bl"|"lb"|"--link-both")	create_name_link && create_picon_link;;
				"" ) ;;
				*)				choice=4
								while [ $choice -lt 0 -o $choice -gt 3 ]
								do
									echo -e "\nsymlink option '$SYMLINK_TAG' is not defined!\n"
									echo -e "   1 ... nl	- create a symlink from $PICON_NAME to '$SERVICE_NAME'"
									echo -e "   2 ... pl	- create a symlink from $PICON_NAME to '$SERVICE_NAME.png'"
									echo -e "   3 ... bl	- create both, '$SERVICE_NAME' and '$SERVICE_NAME.png'"
									echo -e "   0 ... continue without symlinks"
									echo -en "\nyour choice: "
									read -sn 1 choice
									case $choice in
										1) SYMLINK_TAG="nl";echo -e "$SYMLINK_TAG\n";create_name_link;;
										2) SYMLINK_TAG="pl";echo -e "$SYMLINK_TAG\n";create_picon_link;;
										3) SYMLINK_TAG="bl";echo -e "$SYMLINK_TAG\n";create_name_link;create_picon_link;;
										0) SYMLINK_TAG="";echo -e "continue without symlinks";;
									esac
								done
								echo
				;;
			esac
		else
			echo "picon for '$SERVICE_NAME' $PIC0N_SOURCE_DIRECTORY/$PICON_NAME not found" | clear_double_slash >> $ERROR_LOG
			tail -n 1 $ERROR_LOG
			PICON_ERROR=$(( $PICON_ERROR+1 ))
		fi
	fi
	echo
	CHANNEL_NUMBER=$(( $CHANNEL_NUMBER+1 ))
done

exit 0

