#!/usr/bin/python
# bskybsat.py  by Ambrosa http://www.dreamboxonline.com
# this module is used for download EPG data from transponder using OpenTV format

__author__ = "ambrosa http://www.dreamboxonline.com"
__version__ = "0.52 beta"
__copyright__ = "Copyright (C) 2008-2009 Alessandro Ambrosini"
__license__ = "CreativeCommons by-nc-sa http://creativecommons.org/licenses/by-nc-sa/3.0/"

import os
import sys
import time
import codecs
import socket
import string
import random
import urllib2
import ConfigParser
from xml.dom import minidom

from e2_coremod.stuff import fn_escape


class download_and_cache:
    


    # =================================================================

    CONF_FILENAME=''
    CONF_CHLIST=''
    CONF_MAX_DAY_EPG=7
    CONF_GMT_DELTA=1
    CONF_DEFAULT_PROVIDER=''
    CONF_CACHEDIR='cache'
    CONF_TRANSPONDER_SID_CHANNEL=''
    CONF_USE_WEBIF=1
    CONF_RETURN_PREV_CH=1
    CONF_CRCCHECK=0
    CONF_RECOVERY=1
    CONF_ENABLE_OSD=1
    CONF_SOURCE_CHARSET=''
    CONF_CACHE_CHARSET=''
    CONF_WAIT_FOR_MOTOR=0
    
    TODAY=''
    DAYCACHE=[]
    FIELD_SEPARATOR=''
    
    
    # external program for downloading transponder data located in dl_modules/
    TRANSPONDER_BINARY="bskybsat.bin"
    TRANSPONDER_OUTPUT_PATH=''
    TRANSPONDER_DATA="bskybsat.dat"
    TRANSPONDER_ERROR="australiasat.err"

    
    def log_dummy(self,s,l):
        pass
    log=log_dummy
        
    def set_log_function(self,lf):
        self.log=lf

    def set_webif_function(self,wi):
        self.webif=wi
        self.CONF_USE_WEBIF=self.webif.get_use_webif()
        
        
    def __init__(self,dldir,cachedir,separator):
        
        self.CONF_CACHEDIR=cachedir
        self.FIELD_SEPARATOR=separator
        
        self.CONF_FILENAME=os.path.join(dldir,'australiasat.conf')        
        config=ConfigParser.ConfigParser()
        config.read(self.CONF_FILENAME)
        
        self.CONF_CHLIST=os.path.join(dldir,config.get("australiasat","CHLIST"))
        self.CONF_MAX_DAY_EPG=config.getint("australiasat","MAX_DAY_EPG")
        self.CONF_GMT_DELTA=config.getint("australiasat","GMT_DELTA")
        self.CONF_RETURN_PREV_CH=config.getint("australiasat","RETURN_PREV_CH")
        self.CONF_ENABLE_OSD=config.getint("australiasat","ENABLE_OSD")
        self.CONF_CRCCHECK=config.getint("australiasat","ENABLE_CRCCHECK")
        self.CONF_RECOVERY=config.getint("australiasat","ENABLE_RECOVERY")
        
        self.CONF_TRANSPONDER_SID_CHANNEL=string.lower(string.strip(config.get("australiasat","TRANSPONDER_SID_CHANNEL")))
        self.CONF_WAIT_FOR_MOTOR=config.getint("australiasat","WAIT_FOR_MOTOR")
        
        self.TRANSPONDER_OUTPUT_PATH=dldir
        self.TRANSPONDER_BINARY=os.path.join(dldir,self.TRANSPONDER_BINARY)
        self.TRANSPONDER_DATA=os.path.join(dldir,self.TRANSPONDER_DATA)
        self.TRANSPONDER_ERROR=os.path.join(dldir,self.TRANSPONDER_ERROR)

        self.TODAY=time.strftime("%Y%m%d")

        # create a list filled with dates (format AAAAMMDD) from today to today+ MAX_DAY_EPG
        self.DAYCACHE=[self.TODAY]
        for day in range(1,self.CONF_MAX_DAY_EPG):
            self.DAYCACHE.append(time.strftime("%Y%m%d",time.localtime(time.time()+86400*day)))




# =================================================================

    
    def start(self):
        
        self.log("Using SAT mode (decode OpenTV data). Please wait about 90 sec. ...")
        
        # ** read channel_list.conf file **
        if not os.path.exists(self.CONF_CHLIST):
            self.log("ERROR ! \'" + self.CONF_CHLIST + "\' NOT FOUND");
            sys.exit(10)
            
        config=ConfigParser.ConfigParser()
        config.read(self.CONF_CHLIST)
        self.CONF_DEFAULT_PROVIDER=string.lower(config.get("default_provider","PROVIDER"))
        
        temp=config.items("channel_list");
        chlist={}

        # create a dictionary (Python array) with index=channel ID
        for i in temp:
            chlist[i[0]]=unicode(i[1],'utf-8')
        
        if len(chlist) == 0 :
            self.log("ERROR ! " + self.CONF_CHLIST + " is empty")
            sys.exit(10)

        
        if not os.path.exists(self.TRANSPONDER_BINARY) :
            self.log("ERROR : "+self.TRANSPONDER_BINARY+" not found !")
            sys.exit(10)
        
        # switch on and read current channel sid
        if self.CONF_USE_WEBIF == 1:
            dm_is_switched_on=self.webif.currentchannelsid() # return 'None' if DM is switched off
            
            if self.webif.is_recording()==True:
                self.log("ERROR: Recording in place. Cannot run australiasat module")
                if self.CONF_ENABLE_OSD==1:
                    self.webif.message("Recording in place. Cannot run australiasat module. Abort !",300,3)
                sys.exit(1)
                
            self.log("Switching on Dreambox",2)
            current_sid=self.webif.switchon()
            if current_sid == None:
                self.log("ERROR switching on Dreambox")
                sys.exit(1)
            
            self.log("Current channel SID: "+current_sid,2)

        sid=self.CONF_TRANSPONDER_SID_CHANNEL
        
        # strange conversion for removing leading '0'
        EPG_CHANNEL_INFO_sid="%X" % int(string.split(sid,":")[0],16)
        temp="%X" % int(string.split(sid,":")[1],16)
        EPG_CHANNEL_INFO_tsid="%X" % int(string.split(sid,":")[2],16)
        EPG_CHANNEL_INFO_onid="%X" % int(string.split(sid,":")[3],16)
        webifsid='1:0:1:'+EPG_CHANNEL_INFO_sid+':'+EPG_CHANNEL_INFO_tsid+':'+EPG_CHANNEL_INFO_onid+':'+temp+':0:0:0:'
        
        if self.CONF_USE_WEBIF==1 :
            self.log("Changing channel (SID: "+sid+" -> WEBIF SID: "+webifsid+" )",2)
            if self.CONF_ENABLE_OSD==1:
                self.webif.message("Start download OpenTV data, changing channel (SID: "+sid+"), please wait about 90 sec",30)
            self.webif.zap(webifsid)
            time.sleep(5)
            
        if self.CONF_CRCCHECK==1:
            crccheck='-c'
        else:
            crccheck=''

        if self.CONF_RECOVERY==1:
            recovery=''
        else:
            recovery='-r'
        
        time.sleep(self.CONF_WAIT_FOR_MOTOR)
        
        extbin=os.popen(self.TRANSPONDER_BINARY+' '+crccheck+' '+recovery+' -l -p '+self.TRANSPONDER_OUTPUT_PATH)
        for line in extbin.readlines():
            self.log(line.strip())
        retcode=extbin.close()
            
        if retcode != None:
            if self.CONF_USE_WEBIF==1 and self.CONF_ENABLE_OSD==1:
                self.webif.message(self.TRANSPONDER_BINARY+" ERROR. Abort !",300,3)
            self.log("ERROR reported by external binary module \'"+self.TRANSPONDER_BINARY+"\',retcode="+str(retcode))
            self.log("ABORTING");
            sys.exit(1)
        
        #os.system(self.TRANSPONDER_BINARY+' -p '+self.TRANSPONDER_OUTPUT_PATH)
        #os.spawnl(os.P_WAIT,os.path.join(CONF_DLMODDIR,TRANSPONDER_BINARY),TRANSPONDER_BINARY, '-f',CONF_DLMODDIR)
        #os.spawnl(os.P_WAIT,os.path.join(INSTALLDIR,TRANSPONDER_BINARY),TRANSPONDER_BINARY, '-q','-f',INSTALLDIR) # quiet mode
        
        # restore previous channel
        if self.CONF_USE_WEBIF==1 and self.CONF_RETURN_PREV_CH==1:
            self.log("Changing to previous channel sid",2)
            if self.CONF_ENABLE_OSD==1:
                self.webif.message("End download OpenTV data, changing to previous channel",8)
            self.webif.zap(current_sid)
            time.sleep(10)

        if self.CONF_USE_WEBIF==1:
            # id DM was switched off, then switch it off
            if dm_is_switched_on == None:
                self.log("Switching off Dreambox",2)
                self.webif.standby()


    #-----------
    
        if not os.path.exists(self.TRANSPONDER_DATA):
            self.log("ERROR : "+self.TRANSPONDER_DATA+" not found !")
            sys.exit(10)
                
        self.log("Opening " + self.TRANSPONDER_DATA,2)
        
        # skyitaliasat.dat is in 'iso-8859-1' format
        fd=codecs.open(self.TRANSPONDER_DATA,"r",'iso-8859-1')
        
        ch_list_addendum=[]
        unixnow=time.time()

        if self.CONF_USE_WEBIF==1 and self.CONF_ENABLE_OSD==1:
            self.webif.message("\'australiasat\' now postprocesses data, please wait about 2 min",30)
        
        while True:
            
            line=string.strip(fd.readline());
            if line == None or line == '' :
                # reached end of file, quit loop
                break
            
            line=string.split(line,"###")
            if line[0] == u"CHANNEL":
                if line[1] == u"ERROR":
                    continue
                else:
                    channel_sat_id=string.strip(line[1])
                    channel_skybox=string.strip(line[2])
                    channel_sat_name=string.strip(string.lower(line[3]))
            else:
                continue
            
            if not chlist.has_key(channel_sat_id):
                self.log("Warning ! Channel \'" + channel_sat_name + "\' id=" + channel_sat_id + \
                    " not present in australiasat-channel_list.conf, skip it (see below for complete listing)")
                ch_list_addendum.append("# " + channel_sat_name + " , id=" + channel_sat_id)
                ch_list_addendum.append(channel_sat_id + "=1,"+channel_sat_name)
                # skip to next channel C section
                continue        
            
                
            # get channel options
            #  0 : don't download/cache
            opt=chlist[channel_sat_id]
            cacheopt=int(string.split(opt,",")[0])

            
            # if  cache opt == 0 , skip (do nothing)
            if cacheopt == 0:
                continue
        
            channel_name=''
            if (len(string.split(opt,","))>=2) and (string.split(opt,",")[1]!=''):
                # channel renamed into DM7025, new name provided by user in channel_list.conf
                channel_name=string.lower(string.strip(string.split(opt,",")[1]))
            else:
                channel_name=channel_sat_name
                
            if (len(string.split(opt,",")) >= 3) and (string.split(opt,",")[2]!=''):
                channel_provider=string.lower(string.strip(string.split(opt,",")[2]))
            else:
                channel_provider=self.CONF_DEFAULT_PROVIDER
            
            self.log("Processing \'"+channel_name+"\'  id="+channel_sat_id,2)

            
            # parse events for the channel
            eventfile_opened=False
            previous_ch_date=''
            max_day_epg=self.DAYCACHE[self.CONF_MAX_DAY_EPG - 1]
            
            
            while True:
                line=string.strip(fd.readline())
                if line == u"ENDCHANNEL":
                    # end events
                    break
                
                line=string.split(line,"###")
                
                channel_sat_starttime=int(line[0])
                
                # if event is in the past (minus 4 hours) , skip it
                if channel_sat_starttime < (unixnow-14400):
                    continue
                
                channel_sat_startime_humanformat=line[1]  # NOT USED
                channel_sat_lengthtime=int(line[2])       # NOT USED
                channel_sat_title=string.strip(line[3])
                channel_sat_description=string.strip(line[4])
                
                # if record has >1 {R}ecovery, skip it
                if string.count(channel_sat_description,'{R}') > 1:
                    continue
                
                
                ch_date=time.strftime("%Y%m%d",time.localtime(channel_sat_starttime))
                
                if ch_date > max_day_epg :
                    continue
                
                if ch_date != previous_ch_date:
                    if eventfile_opened == True:
                        fdcache.close()
                        eventfile_opened = False
                    previous_ch_date=ch_date
                    
                    eventfilename=fn_escape("australiasat" + self.FIELD_SEPARATOR + channel_name + "_" + channel_sat_id + "-" + channel_skybox + self.FIELD_SEPARATOR + ch_date)
                    eventfilepath=os.path.join(self.CONF_CACHEDIR,eventfilename)

                    if (cacheopt == 1) and  os.path.exists(eventfilepath):
                        continue
                    if (cacheopt == 3) and os.path.exists(eventfilepath) and (ch_date != self.TODAY):
                        continue
                    self.log("  Writing in cache \'"+eventfilename+"\'",2)

                    fdcache=codecs.open(eventfilepath,"w",'utf-8')
                    
                    fdcache.write(channel_name+self.FIELD_SEPARATOR+ channel_provider + self.FIELD_SEPARATOR+channel_sat_id+'\n')
                    eventfile_opened = True
                    
            
                if eventfile_opened == True:
                    fdcache.write(str(channel_sat_starttime - self.CONF_GMT_DELTA*3600) + self.FIELD_SEPARATOR + \
                                time.strftime("%H:%M:%S",time.localtime(channel_sat_starttime)) + self.FIELD_SEPARATOR + \
                                channel_sat_title + self.FIELD_SEPARATOR + \
                                channel_sat_description + '\n')
                
            if eventfile_opened == True:
                fdcache.close()
                eventfile_opened = False
        
        self.log("End processing dat file",2)
        
        if len(ch_list_addendum) > 0:
            self.log("Missing channels list (copy and paste in your australiasat-channel_list.conf) :")
            for e in ch_list_addendum:
                # log in 'raw' mode
                self.log(e,1,1)
                


    # ****************************************************************************************************************************

