#!/usr/bin/python
# flashza.py  by Ambrosa http://www.dreamboxonline.com
# this module is used for download EPG data from FLASH ZA website

__author__ = "ambrosa http://www.dreamboxonline.com"
__version__ = "0.52 beta"
__copyright__ = "Copyright (C) 2008-2009 Alessandro Ambrosini"
__license__ = "CreativeCommons by-nc-sa http://creativecommons.org/licenses/by-nc-sa/3.0/"

import os
import sys
import time
import codecs
import socket
import string
import random
import urllib2
import ConfigParser
from xml.dom import minidom

from e2_coremod.stuff import fn_escape


class download_and_cache:
    

    # retry number if HTTP error
    HTTP_ERROR_RETRY = 3

    # seconds to wait between retries
    HTTP_ERROR_WAIT_RETRY=10


    # =================================================================

    CONF_FILENAME=''
    CONF_SOCKET_TIMEOUT=0.0
    CONF_CHLIST=''
    CONF_MAX_DAY_EPG=7
    CONF_URL=''
    CONF_DEFAULT_PROVIDER=''
    CONF_CACHEDIR='cache'
    CONF_WDRUN=1
    
    
    TODAY=''
    DAYCACHE=[]
    FIELD_SEPARATOR=''
    TMPDIR='flashza.tmp'
    
    
    def log_dummy(self,s,l):
        pass
    log=log_dummy
        
    def set_log_function(self,lf):
        self.log=lf
        
    def set_webif_function(self,wi):
        self.webif=wi
        self.CONF_USE_WEBIF=self.webif.get_use_webif()

        
    def __init__(self,dldir,cachedir,separator):
        
        self.CONF_CACHEDIR=cachedir
        self.FIELD_SEPARATOR=separator
        
        self.CONF_FILENAME=os.path.join(dldir,'flashza.conf')        
        config=ConfigParser.ConfigParser()
        config.read(self.CONF_FILENAME)
        self.CONF_SOCKET_TIMEOUT=config.getfloat("flashza","SOCKET_TIMEOUT")
        self.CONF_CHLIST=os.path.join(dldir,config.get("flashza","CHLIST"))
        self.CONF_MAX_DAY_EPG=config.getint("flashza","MAX_DAY_EPG")
        self.CONF_URL=config.get("flashza","FLASHZAURL")
        self.CONF_WDRUN=config.getint("flashza","WD_RUN")-1
        self.TMPDIR=os.path.join(dldir,self.TMPDIR)

        self.TODAY=time.strftime("%Y%m%d")
        # create a list filled with dates (format AAAAMMDD) from today to today+ MAX_DAY_EPG
        self.DAYCACHE=[self.TODAY]
        for day in range(1,self.CONF_MAX_DAY_EPG):
            self.DAYCACHE.append(time.strftime("%Y%m%d",time.localtime(time.time()+86400*day)))




# =================================================================


    # get XML file from website
    def start(self):
        
        # ** read channel_list.conf file **
        if not os.path.exists(self.CONF_CHLIST):
            self.log("ERROR ! \'" + self.CONF_CHLIST + "\' NOT FOUND");
            sys.exit(10)
            
        # if exists, deleting old temporary dir.
        if os.path.exists(self.TMPDIR):
            self.log("Deleting old temp. dir. \'" + self.TMPDIR+"\'")
            for tempfile in os.listdir(self.TMPDIR):
                os.unlink(os.path.join(self.TMPDIR,tempfile))
            os.rmdir(self.TMPDIR)
        
        if self.CONF_WDRUN!=-1:
            if int(time.strftime("%w"))!=self.CONF_WDRUN:
                self.log("STOP PROCESS : today (="+str(time.strftime("%w"))+") doesn't match with WD_RUN (="+str(self.CONF_WDRUN)+") option in flashza.conf ")
                return
        
        self.log("Reading \'" + self.CONF_CHLIST+"\'",2)
        config=ConfigParser.ConfigParser()
        config.read(self.CONF_CHLIST)
        self.CONF_DEFAULT_PROVIDER=string.lower(config.get("default_provider","PROVIDER"))
        
        temp=config.items("channel_list");
        
        chlist={}

        # create a dictionary (Python array) with index=channel ID
        for i in temp:
            chlist[i[0]]=unicode(i[1],'utf-8')
        
        if len(chlist) == 0 :
            self.log("ERROR ! \'" + self.CONF_CHLIST + "\' empty ?")
            sys.exit(10)

        # set network socket timeout
        socket.setdefaulttimeout(self.CONF_SOCKET_TIMEOUT)
        
        # read remote file
        
        os.mkdir(self.TMPDIR)
        self.log("Downloading \'" + self.CONF_URL+"\' ...",2)
        if os.system('wget -q -O '+self.TMPDIR+'/SEPARATE.tar.bz2 '+self.CONF_URL) != 0:
            self.log("ERROR download \'"+self.CONF_URL+"\' , abort !")
            sys.exit()
        self.log("Untarring file ...",2)
        if os.system('cd '+self.TMPDIR+' ; tar -xj -f SEPARATE.tar.bz2') != 0:
            self.log("ERROR untar SEPARATE.tar.bz2 , abort !")
            sys.exit()
        os.unlink(os.path.join(self.TMPDIR,'SEPARATE.tar.bz2'))
        

        ch_list_addendum=[]
        # parse all XML files
        for f in sorted(os.listdir(self.TMPDIR)):
            
            c=string.split(string.split(f,'.')[0],'-')[1]
            xmlfile=os.path.join(self.TMPDIR,f)
            self.log("Processing "+xmlfile,2)
            
            try:
                xmldoc = minidom.parse(xmlfile)
            except:
                self.log("Warning ! " + xmlfile + " is not a valid XML file. Skipped.")
                continue
        
            # get the ref to the first XML "<channel>" section (there is only 1 "<channel>" section)
            xmlref_channel=xmldoc.getElementsByTagName('channel')[0]
            # get the ref to the first XML "<display-name>" section inside <channel> (there is only 1 "<display-name>" section)
            xmlref_displayname=xmlref_channel.getElementsByTagName('display-name')[0]
            # get the channel name
            xml_channel_name=string.lower(string.strip(xmlref_displayname.firstChild.data))
            
            if chlist.has_key(c)==False:
                self.log("Warning ! Channel \'" + xml_channel_name + "\' id=" + c + \
                    " not present in flashza-channel_list.conf, skipping (see below for complete listing)")
                ch_list_addendum.append("# " + xml_channel_name + " , id=" + c)
                ch_list_addendum.append(c + "=1")
                continue
                
            # get cacheopt
            #  0 : don't download/cache
            #  1 : download and cache (optional 1,new_name )
            #  2 : always download overwriting existing files (optional 2,new_name )
            #  3 : always download overwriting existing files only for TODAY (optional 2,new_name )
            
            cacheopt=int(string.split(chlist[c],",")[0])
        
            # if cacheopt == 0, do nothing
            if cacheopt == 0:
                continue
        
            channel_name=''
            if (len(string.split(chlist[c],",")) >= 2) and (string.split(chlist[c],",")[1]!=''):
                # channel renamed into DM7025, new name provided by user in channel_list.conf
                channel_name=string.lower(string.strip(string.split(chlist[c],",")[1]))
            else:
                # channel name is not present as option in channel_list.conf , so get it from XML file
                channel_name=xml_channel_name
                
            if (len(string.split(chlist[c],",")) >= 3) and (string.split(chlist[c],",")[2]!=''):
                channel_provider=string.lower(string.strip(string.split(chlist[c],",")[2]))
            else:
                channel_provider=self.CONF_DEFAULT_PROVIDER
             
            
            
            # get the refs to all XML "<programme>" 
            xmlref_events=xmldoc.getElementsByTagName('programme')

            file_opened=False
            previous_event_day="!*!DUMMY!*!"
            
            # extract all events and put in eventfile
            for xml_event in xmlref_events:
                
                event_starttime=string.strip(xml_event.attributes['start'].value)
                #self.log("  event date "+event_starttime,2)
                event_day=event_starttime[:8]
                
                # if event day is in the past, skip event
                if event_day < self.TODAY:
                    #self.log("  event in the past, continue",2)
                    continue
                
                # if event day is in the far future (>MAX_DAY_EPG), stop process
                if event_day > self.DAYCACHE[self.CONF_MAX_DAY_EPG - 1]:
                    #self.log("  event in the future, break",2)
                    #self.log("  "+str(event_day)+"  "+str(self.DAYCACHE[self.CONF_MAX_DAY_EPG - 1]),2)
                    break

                if event_day != previous_event_day:
                    eventfilename=fn_escape("flashza" + self.FIELD_SEPARATOR + channel_name+"_"+ c + self.FIELD_SEPARATOR + event_day)
                    eventfilepath=os.path.join(self.CONF_CACHEDIR,eventfilename)
                    
                    if file_opened:
                        fd.close()
                        file_opened=False
                        
                    if (cacheopt==1) and os.path.exists(eventfilepath):
                            continue
                    if (cacheopt==3) and (event_day!=self.TODAY) and os.path.exists(eventfilepath):
                            continue
                        
                    
                    fd=codecs.open(eventfilepath,"w",'utf-8')
                    file_opened=True
                    self.log("  Writing in cache \'"+eventfilename+"\'",2)
                    # write the first line
                    fd.write(channel_name +self.FIELD_SEPARATOR+ channel_provider +self.FIELD_SEPARATOR+ str(c)+'\n')

                    previous_event_day=event_day


                event_startime_unix_gmt=int(time.mktime(time.strptime(event_starttime[:14],"%Y%m%d%H%M%S")))
                if event_starttime[15:16] == '+' :
                    event_startime_unix_gmt = event_startime_unix_gmt - (3600*int(event_starttime[16:18]) + 60*int(event_starttime[18:20]))
                else:
                    event_startime_unix_gmt = event_startime_unix_gmt + (3600*int(event_starttime[16:18]) + 60*int(event_starttime[18:20]))
                
                if xml_event.getElementsByTagName('title')[0].hasChildNodes():
                    event_title=string.strip(xml_event.getElementsByTagName('title')[0].firstChild.data)
                    #event_title=event_title.encode('ascii','replace')
                else:
                    event_title="NO-TITLE"
                
                if xml_event.getElementsByTagName('desc')[0].hasChildNodes():
                    event_description=string.strip(xml_event.getElementsByTagName('desc')[0].firstChild.data)
                    #event_description=event_description.encode('ascii','replace')
                else:
                    event_description="NO-DESCRIPTION-AVAILABLE"
                    
                fd.write(str(event_startime_unix_gmt)+self.FIELD_SEPARATOR+event_starttime+self.FIELD_SEPARATOR+event_title+self.FIELD_SEPARATOR+event_description+'\n')
    
            if file_opened:
                fd.close()

        if len(ch_list_addendum) > 0:
            self.log("Missing channels list (copy and paste in your flashza-channel_list.conf) :")
            for e in ch_list_addendum:
                # log in 'raw' mode
                self.log(e,1,1)


        # remove temporary dir.
        if os.path.exists(self.TMPDIR):
            self.log("Deleting temp. dir. \'" + self.TMPDIR+"\'")
            for tempfile in os.listdir(self.TMPDIR):
                os.unlink(os.path.join(self.TMPDIR,tempfile))
            os.rmdir(self.TMPDIR)


# ****************************************************************************************************************************
