#!/usr/bin/python
# channel_list_generator.py
#
# thanks to microch (CH) for suggestions and beta testing
#
#
# WARNING : existing channel_list file will be overwritten/destroyed
#           make backup before running channel_list_generator.py
#
# see e2_loadepg.conf for common options

__author__ = "ambrosa http://www.dreamboxonline.com"
__version__ = "0.50 beta"
__copyright__ = "Copyright (C) 2008 Alessandro Ambrosini"
__license__ = "CreativeCommons by-nc-sa http://creativecommons.org/licenses/by-nc-sa/3.0/"

import urllib2
import socket
import time
import sys
import string
import os.path
import ConfigParser
from xml.dom import minidom

# ****** CONSTANT ******

# retry number if HTTP error
HTTP_ERROR_RETRY = 3
HTTP_ERROR_WAIT_RETRY=10
HTTP_QUIT_NOERROR=-1
HTTP_QUIT_404=-10


CONF_OZURL="http://xmltv.radiotimes.com/xmltv/channels.dat"
CONF_CHLIST="radiotimes-channel_list.conf"
CONF_SOCKET_TIMEOUT=20


# ---------------------------------------------------------------------------




# ****** FUNCTION ******

def log(s,level=1):
    if (CONF_LOG_LEVEL>0):
        if (level<=CONF_LOG_LEVEL):
            print time.strftime("%d-%m-%Y %H:%M:%S",time.localtime()),
            print " " + s
    
    
def confirm(s):
    print s,
    while True:
        ok = raw_input()
        if ok in ('y','yes'): return True
        if ok in ('n','no'): return False


# -------------------------------------------------------------------------


# ****** MAIN CODE ******

    
log("CHANNEL_LIST_GENERATOR.PY by " + __author__ + " , ver. " + __version__ )
log("License: " + __license__)
log(__copyright__)


if not confirm("Warning ! File channel_list.conf will be overwritten ! " \
                "Continue [y/n] ?"):
    sys.exit(2)
    

START_TIME=time.time()

# set socket timeout
socket.setdefaulttimeout(CONF_SOCKET_TIMEOUT)

TODAY=time.strftime("%Y%m%d",time.localtime())

log("Downloading channel list from " + CONF_RTCL)

# read remote file
i = HTTP_ERROR_RETRY
while i > 0 :
    try:
        sock=urllib2.urlopen(CONF_RTCL)
        data=sock.readlines()

    except IOError, e:
        serr="unknown"
        if hasattr(e, 'reason'):
            serr=str(e.reason)
        elif hasattr(e, 'code'):
            serr=str(e.code)
            if hasattr(e, 'msg'):
                serr+=" , "+str(e.msg)
            if e.code==404:
                log("  connection error. Reason: "+serr+". Skip it.")
                i=HTTP_QUIT_404
                
        if i != HTTP_QUIT_404:
            log("  connection error. Reason: "+serr+". Waiting "+str(HTTP_ERROR_WAIT_RETRY)+" sec. and retry ["+str(i)+"] ...")
            time.sleep(HTTP_ERROR_WAIT_RETRY) # add sleep
            i -= 1 
                
    else:
        i=HTTP_QUIT_NOERROR # quit WHILE loop
        sock.close()        
        
        
if i != HTTP_QUIT_NOERROR :
    log("Download error. Abort process")
    sys.exit(1)

chlist={}

num_ch=0
for i in data:
    id=int(string.split(string.strip(i),"|")[0])
    chname=string.split(string.strip(i),"|")[1]
    chlist[id]=string.strip(chname)
    num_ch+=1



# start parsing channels
        
        
log("Open for writing " + CONF_CHLIST,2)
conf=open(CONF_CHLIST,'w')

confheader="# RADIOTIMES channel_list_generator.py  by " + __author__ + " , rel. " + __version__ + "\n" + \
        "# Creation time: " + time.strftime("%d-%m-%Y %H:%M:%S",time.localtime()) + "\n" \
        "#\n# YOU must configure every channel ID\n" + \
        "#\n" + \
	"# id=0   EPG will not be downloaded\n" + \
	"# id=1,DM7025_channel_name[,provider_name]   EPG will be downloaded and cached, optional set provider_name if it's different from 'defaul_provider'\n" + \
	"# id=2,DM7025_channel_name[,provider_name]   EPG will be downloaded every time\n" + \
	"# id=3,DM7025_channel_name[,provider_name]   EPG will be downloaded and cached (like '1') but only TODAY will be forced downloading (like '2')\n" + \
	"#\n" + \
	"# Examples:\n" + \
	"# 101=0               channel id 101 ('Sky Cinema 1') EPG will NOT be dowloaded\n" + \
	"# 101=1,SkyCinema 1   'Sky Cinema 1' EPG will be dowloaded and cached and name in DM is 'SkyCinema 1'\n" + \
	"# 111=2,E!            'E! Entertaiment' EPG will be dowloaded every time and it's name in DM is 'E!'\n" + \
	"# 891=1,bbc world news,globecast uk    'bbc worldnews' EPG will be dowloaded and cached and name in DM is 'bbc world news' and it's provider is 'globecast uk'\n" + \
	"# 892=2,retequattro,noprovider         'rete 4' EPG will be dowloaded every time, name in DM is 'retequattro' and it's provider is 'noprovider'\n" + \
	"#                                         (special case where there are no provider assigned)\n" + \
	"#\n" + \
	"# note 1: channel name and provider name are case insensitive\n" + \
	"# note 2: if provider name is empty use the special word 'noprovider'\n" + \
	"# note 3: you can add many providers using '|' character as separator but you MUST also include the default_provider\n" + \
	"#            i.e.  891=1,bbc world news,globecast uk|cyfra|noprovider\n" + \
        "\n\n[default_provider]\nPROVIDER=bskyb\n" + \
        "\n\n[channel_list]\n\n"

conf.write(confheader)

for id in sorted(chlist.keys()):
    sout="# "+str(id)+" , " + chlist[id] + "\n"
    sout=sout+str(id)+"=1,"+string.lower(chlist[id])+"\n"
    conf.write(sout)
    
    

conf.close()

log("Saved file " + CONF_CHLIST,2)

END_TIME=time.time()
log("End processing, elapsed " + str(int(END_TIME - START_TIME)) + " seconds")
log("Found "+str(num_ch)+" channels")
sys.exit(0)

# **************** E N D ********************
