#!/usr/bin/python
# radiotimes.py  by Ambrosa http://www.dreamboxonline.com
# this module is used for download EPG data from RADIOTIMES.COM
#
# thanks to microch (CH) and AJMILLER for suggestions and beta testing
#

__author__ = "ambrosa http://www.dreamboxonline.com"
__version__ = "0.52 beta"
__copyright__ = "Copyright (C) 2008-2009 Alessandro Ambrosini"
__license__ = "CreativeCommons by-nc-sa http://creativecommons.org/licenses/by-nc-sa/3.0/"

import os
import sys
import time
import codecs
import socket
import string
import random
import urllib2
import ConfigParser

from e2_coremod.stuff import fn_escape


class download_and_cache:
    

    # retry number if HTTP error
    HTTP_ERROR_RETRY = 3

    # seconds to wait between retries
    HTTP_ERROR_WAIT_RETRY=10
    


    # =================================================================
    HTTP_QUIT_NOERROR=-1
    HTTP_QUIT_404=-10

    CONF_FILENAME=''
    CONF_SOCKET_TIMEOUT=0.0
    CONF_CHLIST=''
    CONF_MAX_DAY_EPG=7
    CONF_RANDOM_MIN=0.0
    CONF_RANDOM_MAX=1.0
    CONF_GMT_DELTA=1
    CONF_URL=''
    CONF_DEFAULT_PROVIDER=''
    CONF_CACHEDIR='cache'
    
    TODAY=''
    DAYCACHE=[]
    FIELD_SEPARATOR=''
    
    def log_dummy(self,s,l):
        pass
    log=log_dummy
        
    def set_log_function(self,lf):
        self.log=lf
        
    def set_webif_function(self,wi):
        self.webif=wi
        self.CONF_USE_WEBIF=self.webif.get_use_webif()


    def __init__(self,dldir,cachedir,separator):
        
        self.CONF_CACHEDIR=cachedir
        self.FIELD_SEPARATOR=separator
        
        self.CONF_FILENAME=os.path.join(dldir,'radiotimes.conf')        
        config=ConfigParser.ConfigParser()
        config.read(self.CONF_FILENAME)
        self.CONF_SOCKET_TIMEOUT=config.getfloat("radiotimes","SOCKET_TIMEOUT")
        self.CONF_CHLIST=os.path.join(dldir,config.get("radiotimes","CHLIST"))
        self.CONF_MAX_DAY_EPG=config.getint("radiotimes","MAX_DAY_EPG")
        self.CONF_RANDOM_MIN=config.getfloat("radiotimes","RANDOM_MIN")
        self.CONF_RANDOM_MAX=config.getfloat("radiotimes","RANDOM_MAX")
        self.CONF_GMT_DELTA=config.getint("radiotimes","GMT_DELTA")
        self.CONF_URL=config.get("radiotimes","RTURL")
        if self.CONF_URL[-1] != "/":
            self.CONF_URL += "/"

        self.TODAY=time.strftime("%Y%m%d")
        # create a list filled with dates (format AAAAMMDD) from today to today+ MAX_DAY_EPG
        self.DAYCACHE=[self.TODAY]
        for day in range(1,self.CONF_MAX_DAY_EPG):
            self.DAYCACHE.append(time.strftime("%Y%m%d",time.localtime(time.time()+86400*day)))



    # get epg data file from radiotimes.com

    def start(self):
        
        # ** read channel_list.conf file **
        if not os.path.exists(self.CONF_CHLIST):
            self.log("ERROR ! \'" + self.CONF_CHLIST + "\' NOT FOUND");
            sys.exit(10)
       
        self.log("Reading \'" + self.CONF_CHLIST+"\'",2)
        config=ConfigParser.ConfigParser()
        config.read(self.CONF_CHLIST)
        temp=config.items("channel_list");
        
        self.CONF_DEFAULT_PROVIDER=string.lower(config.get("default_provider","PROVIDER"))

        chlist={}

        # create a dictionary (Python array) with index=channel ID
        for i in temp:
            chlist[i[0]]=unicode(i[1],'utf-8')
        
        if len(chlist) == 0 :
            self.log("ERROR ! \'" + self.CONF_CHLIST + "\' empty ?")
            sys.exit(10)

        # set network socket timeout
        socket.setdefaulttimeout(self.CONF_SOCKET_TIMEOUT)

        self.log("Start download epg data from \'" + self.CONF_URL +"\'")
        
        random.seed() # initialize random generator

        # get remote files
        #   chid format: channel id , 0|1,new name
        #   i.e. ("101" , "1,SkyCinema1")
        for c in sorted(chlist.keys()):
            # get cacheopt
            #  0 : don't download/cache
            #  1 : download and cache (optional 1,new_name )
            
            cacheopt=int(string.split(chlist[c],",")[0])
        
            # if cacheopt == 0, do nothing
            if cacheopt == 0:
                continue
        
            channel_name=''
            if (len(string.split(chlist[c],","))>=2) and (string.split(chlist[c],",")[1]!=''):
                # channel renamed into DM7025, new name provided by user in channel_list.conf
                channel_name=string.lower(string.strip(string.split(chlist[c],",")[1]))
            else:
                self.log("ERROR ! ID "+str(c)+" have not channel name declared. Abort !")
                sys.exit(10)
                
            if (len(string.split(chlist[c],",")) >= 3) and (string.split(chlist[c],",")[2]!=''):
                channel_provider=string.lower(string.strip(string.split(chlist[c],",")[2]))
            else:
                channel_provider=self.CONF_DEFAULT_PROVIDER

        
            epgfile=str(c) + ".dat"
        
            # read remote file
            self.log("Downloading \'" + epgfile +"\'",2)
            i = self.HTTP_ERROR_RETRY
            while i > 0 :
                # to avoid overloading SKYURL website, wait randomly
                time.sleep(random.uniform(self.CONF_RANDOM_MIN, self.CONF_RANDOM_MAX))
                    
                try:
                    sock=urllib2.urlopen(self.CONF_URL + epgfile)
                    data=sock.readlines()
                            
                except IOError, e:
                    serr="unknown"
                    if hasattr(e, 'reason'):
                        serr=str(e.reason)
                    elif hasattr(e, 'code'):
                        serr=str(e.code)
                        if hasattr(e, 'msg'):
                            serr+=" , "+str(e.msg)
                        if e.code==404:
                            self.log("\'" + epgfile +"\' connection error. Reason: "+serr+". Skip it.")
                            i=self.HTTP_QUIT_404
                            
                    if i != self.HTTP_QUIT_404:
                        self.log("\'" + epgfile +"\' connection error. Reason: "+serr+". Waiting "+str(self.HTTP_ERROR_WAIT_RETRY)+" sec. and retry ["+str(i)+"] ...")
                        time.sleep(self.HTTP_ERROR_WAIT_RETRY) # add sleep
                        i -= 1 
                            
                else:
                    i=self.HTTP_QUIT_NOERROR # quit WHILE loop
                    sock.close()
            
            
            if i != self.HTTP_QUIT_NOERROR:
                continue # skip this file
            
            if (len(data)<1):
                self.log("Warning ! No data for channel \'"+channel_name+"\' id="+str(c)+" , skip it")
                continue

            file_opened=False
            previous_event_day="!*!START_LOOP!*!"
            linenum=0
            
            for e in data:
                linenum += 1
                
                if e.count('~') != 22:
                    self.log("Warning ! Skipped record in source data \'"+channel_name+"\' id="+str(c)+" (line num: "+str(linenum)+")",2)
                    continue
                
                linenum += 1
                if type(e).__name__=='str':
                    # convert string to unicode UTF-8
                    eUTF=e.decode('utf-8')
                
                if type(e).__name__=='unicode':
                    # convert unknown unicode to unicode UTF-8
                    eUTF=e.encode('utf-8')
                
                title,sub_title,episode,year,director,cast, \
                premiere,film,repeat,subtitles,widescreen, \
                new_series,deaf_signed,black_and_white, \
                star_rating,certificate,genre,desc,choice, \
                date,start,stop,duration_mins=string.split(string.strip(eUTF.replace('\r','')," \n"),'~')
                
                # convert date dd/mm/yyyy -> yyyymmdd
                event_day=string.split(date,'/')[2]+string.split(date,'/')[1]+string.split(date,'/')[0]
                
                if event_day > self.DAYCACHE[self.CONF_MAX_DAY_EPG - 1]:
                    break
                
                if event_day != previous_event_day:
                    eventfilename=fn_escape("radiotimes" + self.FIELD_SEPARATOR + channel_name + self.FIELD_SEPARATOR + event_day)
                    eventfilepath=os.path.join(self.CONF_CACHEDIR,eventfilename)
                    
                    if file_opened:
                        fd.close()
                        file_opened=False
                        
                    if (cacheopt==1) and os.path.exists(eventfilepath):
                            continue
                    if (cacheopt==3) and (event_day!=self.TODAY) and os.path.exists(eventfilepath):
                            continue
                        
                    # write the first line
                    fd=codecs.open(eventfilepath,"w",'utf-8')
                    file_opened=True
                    self.log("Writing \'"+eventfilename+"\'",2)
                    fd.write(channel_name+ self.FIELD_SEPARATOR+channel_provider+ self.FIELD_SEPARATOR+str(c)+'\n')

                    previous_event_day=event_day

                
                event_startime_unix_gmt=str(int(time.mktime(time.strptime(event_day + " " + start + ":00","%Y%m%d %H:%M:%S"))) - self.CONF_GMT_DELTA*3600)                
                
                
                # read cache file structure.txt and modify to match your needs
                fd.write(event_startime_unix_gmt + self.FIELD_SEPARATOR+ start+":00" +self.FIELD_SEPARATOR+ title +self.FIELD_SEPARATOR+ desc +'\n')
                
                    
            if file_opened:
                fd.close()
            

# ****************************************************************************************************************************
