#!/usr/bin/python
# raisat.py  by Ambrosa http://www.dreamboxonline.com
# this module is used for download EPG data from RaiSat website

__author__ = "ambrosa http://www.dreamboxonline.com"
__version__ = "0.52 beta"
__copyright__ = "Copyright (C) 2008-2009 Alessandro Ambrosini"
__license__ = "CreativeCommons by-nc-sa http://creativecommons.org/licenses/by-nc-sa/3.0/"

import os
import time
import codecs
import socket
import string
import random
import urllib2
import ConfigParser
from xml.dom import minidom

from e2_coremod.stuff import fn_escape


class download_and_cache:
    

    # retry number if HTTP error
    HTTP_ERROR_RETRY = 3

    # seconds to wait between retries
    HTTP_ERROR_WAIT_RETRY=10


    # =================================================================

    CONF_FILENAME=''
    CONF_SOCKET_TIMEOUT=0.0
    CONF_CHLIST=''
    CONF_MAX_DAY_EPG=7
    CONF_RANDOM_MIN=0.0
    CONF_RANDOM_MAX=1.0
    CONF_GMT_DELTA=1
    CONF_URL=''
    CONF_DEFAULT_PROVIDER=''
    CONF_CACHEDIR='cache'
    
    TODAY=''
    DAYCACHE=[]
    FIELD_SEPARATOR=''
    
    
    def log_dummy(self,s,l):
        pass
    log=log_dummy
        
    def set_log_function(self,lf):
        self.log=lf
    
    def set_webif_function(self,wi):
        self.webif=wi
        self.CONF_USE_WEBIF=self.webif.get_use_webif()

        
    def __init__(self,dldir,cachedir,separator):
        
        self.CONF_CACHEDIR=cachedir
        self.FIELD_SEPARATOR=separator
        
        self.CONF_FILENAME=os.path.join(dldir,'raisat.conf')        
        config=ConfigParser.ConfigParser()
        config.read(self.CONF_FILENAME)
        self.CONF_SOCKET_TIMEOUT=config.getfloat("raisat","SOCKET_TIMEOUT")
        self.CONF_CHLIST=os.path.join(dldir,config.get("raisat","CHLIST"))
        self.CONF_MAX_DAY_EPG=config.getint("raisat","MAX_DAY_EPG")
        self.CONF_RANDOM_MIN=config.getfloat("raisat","RANDOM_MIN")
        self.CONF_RANDOM_MAX=config.getfloat("raisat","RANDOM_MAX")
        self.CONF_GMT_DELTA=config.getint("raisat","GMT_DELTA")
        self.CONF_URL=config.get("raisat","RAISATURL")

        self.TODAY=time.strftime("%Y%m%d")
        # create a list filled with dates (format AAAAMMDD) from today to today+ MAX_DAY_EPG
        self.DAYCACHE=[self.TODAY]
        for day in range(1,self.CONF_MAX_DAY_EPG):
            self.DAYCACHE.append(time.strftime("%Y%m%d",time.localtime(time.time()+86400*day)))



# =================================================================


    # get XML file from SKY Italia website
    def start(self):
        
        # ** read channel_list.conf file **
        if not os.path.exists(self.CONF_CHLIST):
            self.log("ERROR ! \'" + self.CONF_CHLIST + "\' NOT FOUND");
            sys.exit(10)
       
        self.log("Reading \'" + self.CONF_CHLIST+"\'",2)
        config=ConfigParser.ConfigParser()
        config.read(self.CONF_CHLIST)
        self.CONF_DEFAULT_PROVIDER=string.lower(config.get("default_provider","PROVIDER"))
        
        temp=config.items("channel_list");
        
        chlist={}

        # create a dictionary (Python array) with index=channel ID
        for i in temp:
            chlist[i[0]]=unicode(i[1],'utf-8')
        
        if len(chlist) == 0 :
            self.log("ERROR ! \'" + self.CONF_CHLIST + "\' empty ?")
            sys.exit(10)

        # set network socket timeout
        socket.setdefaulttimeout(self.CONF_SOCKET_TIMEOUT)

        self.log("Start download XML files from \'" + self.CONF_URL+"\'")
        
        random.seed() # initialize random generator


        # get remote XML files
        #   chid format: channel id , 0|1|2(,new name)
        #   i.e. ("101" , "1,SkyCinema1")
        for c in sorted(chlist.keys()):
            # get cacheopt
            #  0 : don't download/cache
            #  1 : download and cache (optional 1,new_name )
            #  2 : always download overwriting existing files (optional 2,new_name )
            #  3 : always download overwriting existing files only for TODAY (optional 2,new_name )
            
            
            cacheopt=int(string.split(chlist[c],",")[0])
        
            # if cacheopt == 0, do nothing
            if cacheopt == 0:
                continue
        
            channel_name=''
            if (len(string.split(chlist[c],",")) >= 2) and (string.split(chlist[c],",")[1]!=''):
                # channel renamed into DM7025, new name provided by user in channel_list.conf
                channel_name=string.lower(string.strip(string.split(chlist[c],",")[1]))
                
            if (len(string.split(chlist[c],",")) >= 3) and (string.split(chlist[c],",")[2]!=''):
                channel_provider=string.lower(string.strip(string.split(chlist[c],",")[2]))
            else:
                channel_provider=self.CONF_DEFAULT_PROVIDER

            # if channel name is not present as option in channel_list.conf , quit with error
            if channel_name == '':
                self.log("ERROR ! ID="+str(c)+" channel name not present. Abort !")
                sys.exit()


            for day in self.DAYCACHE:
                day_get=time.strftime("%d/%m/%Y",time.strptime(day,"%Y%m%d"))
                xmlfile="?id=" + str(c) + "&dat=" + day_get
                
                
                # download only if file doesn't exist or cacheopt == 2 (always download),
                # using open(...,"w") files will be overwritten (saving a delete + create)
                                            
                eventfilename=fn_escape("raisat" + self.FIELD_SEPARATOR + channel_name + "_" + str(c) + self.FIELD_SEPARATOR + day)
                eventfilepath=os.path.join(self.CONF_CACHEDIR,eventfilename)
                if (cacheopt == 1) and  os.path.exists(eventfilepath):
                    continue
                if (cacheopt == 3) and os.path.exists(eventfilepath) and (day != self.TODAY):
                    continue
                    
                # read remote file
                self.log("Downloading \'" + xmlfile + "\'",2)
                i = self.HTTP_ERROR_RETRY
                while i > 0  :
                    # to avoid overloading URL website, wait randomly
                    time.sleep(random.uniform(self.CONF_RANDOM_MIN,self.CONF_RANDOM_MAX))
                    
                    try:
                        sock=urllib2.urlopen(self.CONF_URL + xmlfile)
                        data=sock.read()
                        
                    except IOError, e:
                        serr="unknown"
                        if hasattr(e, 'reason'):
                            serr=str(e.reason)
                        elif hasattr(e, 'code'):
                            serr=str(e.code)
                            if hasattr(e, 'msg'):
                                serr+=" , "+str(e.msg)
                            if e.code==404:
                                self.log("\'" + self.CONF_URL + '?' + xmlfile + "\' connection error. Reason: "+serr+". Skip it.")
                                i=0
                                continue
                        self.log("\'" + self.CONF_URL + '?' + xmlfile + "\' connection error. Reason: "+serr+". Waiting "+str(self.HTTP_ERROR_WAIT_RETRY)+" sec. and retry ["+str(i)+"] ...")
                        time.sleep(self.HTTP_ERROR_WAIT_RETRY) # add sleep
                        i -= 1                            
                            
                    else:
                        i=0 # quit WHILE loop
                        sock.close()
                        
                        try:
                            xmldoc = minidom.parseString(data)
                                
                        except:
                            self.log("Warning ! " + self.CONF_URL + '?' + xmlfile + " doesn't generate valid XML data. Skipped.")
                            #xml_errors += 1
                            continue
            
                        # get the ref to the first XML "<palinsesto>" section (there is only 1 "<palinsesto>" section)
                        xmlref_channel=xmldoc.getElementsByTagName('palinsesto')[0]
            
                        self.log("  Writing in cache \'"+eventfilename+"\'",2)
                        fd=codecs.open(eventfilepath,"w",'utf-8')
                        fd.write(channel_name+self.FIELD_SEPARATOR+ channel_provider + self.FIELD_SEPARATOR+str(c)+'\n')
                        
                        # get the refs to all XML "<prog>" inside the "<palinsesto>" section
                        xmlref_events=xmlref_channel.getElementsByTagName('prog')
            
                        # extract all events and put in eventfile
                        for xml_event in xmlref_events:
                            event_starttime=string.strip(xml_event.attributes["ora"].value)
                            event_startime_unix_gmt=str(int(time.mktime(time.strptime(day + " " + event_starttime,"%Y%m%d %H:%M:%S"))) - self.CONF_GMT_DELTA*3600)
                            
                            event_title=string.strip(xml_event.getElementsByTagName('titolo')[0].firstChild.data)
                            #event_title=event_title.encode('ascii','replace')
                            
                            e_desc=''
                            e_regia=''
                            e_cast=''
                            e_nazione=''
                            e_anno=''
                            
                            if len(xml_event.getElementsByTagName('dati'))>0 :
                                eventref_dati=xml_event.getElementsByTagName('dati')[0]
                            
                                if eventref_dati.getElementsByTagName('descrizione')[0].hasChildNodes():
                                    e_desc=string.strip(eventref_dati.getElementsByTagName('descrizione')[0].firstChild.data)
                                    
                                if eventref_dati.getElementsByTagName('regia')[0].hasChildNodes():
                                    e_regia=" Di "+string.strip(eventref_dati.getElementsByTagName('regia')[0].firstChild.data)

                                if eventref_dati.getElementsByTagName('cast')[0].hasChildNodes():
                                    e_cast=" con "+string.strip(eventref_dati.getElementsByTagName('cast')[0].firstChild.data)
                                    
                                if eventref_dati.getElementsByTagName('nazione')[0].hasChildNodes():
                                    e_nazione=" - " +string.strip(eventref_dati.getElementsByTagName('nazione')[0].firstChild.data)
                                    
                                if eventref_dati.getElementsByTagName('anno')[0].hasChildNodes():
                                    e_anno=" "+string.strip(eventref_dati.getElementsByTagName('anno')[0].firstChild.data)
                                    if e_nazione == '':
                                        e_anno=" -"+e_anno
                                
                            event_description=e_desc + e_regia + e_cast + e_nazione + e_anno
                            event_description=event_description.replace('\r','')
                            event_description=event_description.replace('\n',' ')
                            event_description=event_description.strip()
                            #event_description=event_description.encode('ascii','replace')
                                
                            fd.write(event_startime_unix_gmt+self.FIELD_SEPARATOR+event_starttime+self.FIELD_SEPARATOR+event_title+self.FIELD_SEPARATOR+event_description+'\n')
                
                
                        fd.close()

# ****************************************************************************************************************************
